/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.translation;

import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.configuration.adventure.internal.properties.AdventureProperties;
import com.plotsquared.core.configuration.adventure.translation.Translator;
import java.util.Locale;
import java.util.function.Supplier;

final class TranslationLocales {
    private static final Supplier<Locale> GLOBAL;

    private TranslationLocales() {
    }

    static Locale global() {
        return GLOBAL.get();
    }

    static {
        @Nullable String string = AdventureProperties.DEFAULT_TRANSLATION_LOCALE.value();
        if (string == null || string.isEmpty()) {
            GLOBAL = () -> Locale.US;
        } else if (string.equals("system")) {
            GLOBAL = Locale::getDefault;
        } else {
            Locale locale = Translator.parseLocale(string);
            GLOBAL = () -> locale;
        }
    }
}

