/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption;

import com.google.common.collect.ImmutableSet;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LocalizedCaptionMap
implements CaptionMap {
    private final Locale locale;
    private final Map<TranslatableCaption, String> captions;

    public LocalizedCaptionMap(Locale locale, Map<TranslatableCaption, String> map) {
        this.locale = locale;
        this.captions = map;
    }

    @Override
    public @NonNull String getMessage(@NonNull TranslatableCaption translatableCaption) {
        String string = this.captions.get(translatableCaption);
        if (string == null) {
            throw new CaptionMap.NoSuchCaptionException(translatableCaption);
        }
        return string;
    }

    @Override
    public @NonNull String getMessage(@NonNull TranslatableCaption translatableCaption, @NonNull LocaleHolder localeHolder) {
        return this.getMessage(translatableCaption);
    }

    @Override
    public boolean supportsLocale(@NonNull Locale locale) {
        return this.locale.equals(locale);
    }

    @Override
    public @NonNull Locale getLocale() {
        return this.locale;
    }

    @Override
    public @NonNull Set<TranslatableCaption> getCaptions() {
        return ImmutableSet.copyOf(this.captions.keySet());
    }
}

