/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.caption.load;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plotsquared.core.configuration.caption.CaptionMap;
import com.plotsquared.core.configuration.caption.LocalizedCaptionMap;
import com.plotsquared.core.configuration.caption.PerUserLocaleCaptionMap;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.caption.load.DefaultCaptionProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CaptionLoader {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + CaptionLoader.class.getSimpleName()));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> defaultMessages;
    private final Locale defaultLocale;
    private final Function<Path, Locale> localeExtractor;
    private final DefaultCaptionProvider captionProvider;
    private final String namespace;

    private CaptionLoader(@NonNull Locale locale, @NonNull Function<@NonNull Path, @NonNull Locale> function, @NonNull DefaultCaptionProvider defaultCaptionProvider, @NonNull String string) {
        Map<String, String> map;
        this.defaultLocale = locale;
        this.localeExtractor = function;
        this.captionProvider = defaultCaptionProvider;
        this.namespace = string;
        try {
            map = this.captionProvider.loadDefaults(locale);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load default messages", (Throwable)exception);
            map = Collections.emptyMap();
        }
        this.defaultMessages = map;
    }

    public static @NonNull CaptionLoader of(@NonNull Locale locale, @NonNull Function<@NonNull Path, @NonNull Locale> function, @NonNull DefaultCaptionProvider defaultCaptionProvider, @NonNull String string) {
        return new CaptionLoader(locale, function, defaultCaptionProvider, string);
    }

    public static @NonNull Function<@NonNull Path, @NonNull Locale> patternExtractor(@NonNull Pattern pattern) {
        return path -> {
            String string = path.getFileName().toString();
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return Locale.forLanguageTag(matcher.group(1));
            }
            throw new IllegalArgumentException(string + " is an invalid message file (cannot extract locale)");
        };
    }

    static @NonNull Map<@NonNull String, @NonNull String> loadFromReader(@NonNull Reader reader) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return new LinkedHashMap<String, String>((Map)GSON.fromJson(reader, type));
    }

    private static void save(Path path, Map<String, String> map) {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(map, (Appendable)bufferedWriter);
            LOGGER.info("Saved {} with new content", (Object)path.getFileName());
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to save caption file '{}'", (Object)path.getFileName().toString(), (Object)iOException);
        }
    }

    public @NonNull CaptionMap loadAll(@NonNull Path path2) {
        HashMap<Locale, CaptionMap> hashMap = new HashMap<Locale, CaptionMap>();
        try (Stream<Path> stream = Files.list(path2);){
            List<Path> list = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).toList();
            for (Path path3 : list) {
                try {
                    CaptionMap captionMap = this.loadSingle(path3);
                    hashMap.put(captionMap.getLocale(), captionMap);
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to load language file '{}'", (Object)path3.getFileName().toString(), (Object)exception);
                }
            }
            LOGGER.info("Loaded {} message files. Loaded Languages: {}", (Object)hashMap.size(), hashMap.keySet());
            PerUserLocaleCaptionMap perUserLocaleCaptionMap = new PerUserLocaleCaptionMap(hashMap);
            return perUserLocaleCaptionMap;
        }
    }

    public @NonNull CaptionMap loadSingle(@NonNull Path path) {
        Locale locale = this.localeExtractor.apply(path);
        try (BufferedReader bufferedReader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            Map<String, String> map = CaptionLoader.loadFromReader(bufferedReader);
            if (this.patch(map, locale)) {
                CaptionLoader.save(path, map);
            }
            LocalizedCaptionMap localizedCaptionMap = new LocalizedCaptionMap(locale, this.mapToCaptions(map));
            return localizedCaptionMap;
        }
    }

    public @NonNull CaptionMap loadOrCreateSingle(@NonNull Path path) {
        Locale locale = this.localeExtractor.apply(path);
        if (!Files.exists(path, new LinkOption[0])) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            this.patch(linkedHashMap, locale);
            CaptionLoader.save(path, linkedHashMap);
            return new LocalizedCaptionMap(locale, this.mapToCaptions(linkedHashMap));
        }
        return this.loadSingle(path);
    }

    private @NonNull Map<TranslatableCaption, String> mapToCaptions(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> TranslatableCaption.of(this.namespace, (String)entry.getKey()), Map.Entry::getValue));
    }

    private boolean patch(Map<String, String> map, Locale locale) {
        Map<String, String> map2;
        boolean bl = false;
        if (locale.equals(this.defaultLocale)) {
            map2 = this.defaultMessages;
        } else {
            map2 = this.captionProvider.loadDefaults(locale);
            if (map2 == null) {
                map2 = this.defaultMessages;
            }
        }
        for (Map.Entry<String, String> entry : this.defaultMessages.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            String string = map2.getOrDefault(entry.getKey(), entry.getValue());
            map.put(entry.getKey(), string);
            bl = true;
        }
        return bl;
    }
}

