/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.file;

import com.plotsquared.core.configuration.Configuration;
import com.plotsquared.core.configuration.MemoryConfiguration;
import com.plotsquared.core.configuration.file.FileConfigurationOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

public abstract class FileConfiguration
extends MemoryConfiguration {
    FileConfiguration() {
    }

    public FileConfiguration(Configuration configuration) {
        super(configuration);
    }

    public void save(File file) {
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        String string = this.saveToString();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            outputStreamWriter.write(string);
        }
    }

    public abstract String saveToString();

    public void load(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
        }
    }

    public void load(Reader reader) {
        String string2;
        try (BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            string2 = bufferedReader.lines().map(string -> string + "\n").collect(Collectors.joining());
        }
        this.loadFromString(string2);
    }

    public abstract void loadFromString(String var1);

    protected abstract String buildHeader();

    @Override
    public FileConfigurationOptions options() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }
}

