/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.file;

import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.serialization.ConfigurationSerializable;
import com.plotsquared.core.configuration.serialization.ConfigurationSerialization;
import java.util.LinkedHashMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

class YamlRepresenter
extends Representer {
    YamlRepresenter() {
        super(new DumperOptions());
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
    }

    private class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super((SafeRepresenter)YamlRepresenter.this);
        }

        public Node representData(Object object) {
            return super.representData(((ConfigurationSection)object).getValues(false));
        }
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super((SafeRepresenter)YamlRepresenter.this);
        }

        public Node representData(Object object) {
            ConfigurationSerializable configurationSerializable = (ConfigurationSerializable)object;
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("==", ConfigurationSerialization.getAlias(configurationSerializable.getClass()));
            linkedHashMap.putAll(configurationSerializable.serialize());
            return super.representData(linkedHashMap);
        }
    }
}

