/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SingleWorldGenerator
extends IndependentPlotGenerator {
    private static final Location bedrock1 = Location.at("", 0, 0, 0);
    private static final Location bedrock2 = Location.at("", 15, 0, 15);
    private static final Location dirt1 = Location.at("", 0, 1, 0);
    private static final Location dirt2 = Location.at("", 15, 2, 15);
    private static final Location grass1 = Location.at("", 0, 3, 0);
    private static final Location grass2 = Location.at("", 15, 3, 15);
    private static final BlockState BEDROCK = BlockTypes.BEDROCK.getDefaultState();
    private static final BlockState DIRT = BlockTypes.DIRT.getDefaultState();
    private static final BlockState GRASS_BLOCK = BlockTypes.GRASS_BLOCK.getDefaultState();
    private final PlotAreaManager plotAreaManager;

    @Inject
    public SingleWorldGenerator(@NonNull PlotAreaManager plotAreaManager) {
        this.plotAreaManager = plotAreaManager;
    }

    @Override
    public String getName() {
        return "PlotSquared:single";
    }

    @Override
    public void generateChunk(ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator, PlotArea plotArea, boolean bl) {
        SinglePlotArea singlePlotArea = (SinglePlotArea)plotArea;
        if (singlePlotArea.VOID) {
            Location location = zeroedDelegateScopedQueueCoordinator.getMin();
            if (location.getX() == 0 && location.getZ() == 0) {
                zeroedDelegateScopedQueueCoordinator.setBlock(0, 0, 0, BEDROCK);
            }
        } else {
            zeroedDelegateScopedQueueCoordinator.setCuboid(bedrock1, bedrock2, BEDROCK);
            zeroedDelegateScopedQueueCoordinator.setCuboid(dirt1, dirt2, DIRT);
            zeroedDelegateScopedQueueCoordinator.setCuboid(grass1, grass2, GRASS_BLOCK);
        }
        if (bl) {
            zeroedDelegateScopedQueueCoordinator.fillBiome(BiomeTypes.PLAINS);
        }
    }

    @Override
    public PlotArea getNewPlotArea(String string, String string2, PlotId plotId, PlotId plotId2) {
        return ((SinglePlotAreaManager)this.plotAreaManager).getArea();
    }

    @Override
    public void initialize(PlotArea plotArea) {
    }

    @Override
    public BiomeType getBiome(PlotArea plotArea, int n, int n2, int n3) {
        return BiomeTypes.PLAINS;
    }
}

