/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.generator;

import com.plotsquared.core.generator.GridPlotManager;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.HashUtil;
import com.plotsquared.core.util.RegionManager;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SquarePlotManager
extends GridPlotManager {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SquarePlotManager.class.getSimpleName()));
    private final SquarePlotWorld squarePlotWorld;
    private final RegionManager regionManager;

    public SquarePlotManager(@NonNull SquarePlotWorld squarePlotWorld, @NonNull RegionManager regionManager) {
        super(squarePlotWorld);
        this.squarePlotWorld = squarePlotWorld;
        this.regionManager = regionManager;
    }

    @Override
    public boolean clearPlot(final @NonNull Plot plot, final @Nullable Runnable runnable, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        final Set<CuboidRegion> set = plot.getRegions();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (set.isEmpty()) {
                    if (runnable != null) {
                        runnable.run();
                    }
                    return;
                }
                Iterator iterator = set.iterator();
                CuboidRegion cuboidRegion = (CuboidRegion)iterator.next();
                iterator.remove();
                Location location = Location.at(plot.getWorldName(), cuboidRegion.getMinimumPoint());
                Location location2 = Location.at(plot.getWorldName(), cuboidRegion.getMaximumPoint());
                SquarePlotManager.this.regionManager.regenerateRegion(location, location2, false, this);
            }
        };
        runnable2.run();
        return true;
    }

    @Override
    public Location getPlotTopLocAbs(@NonNull PlotId plotId) {
        int n = plotId.getX();
        int n2 = plotId.getY();
        int n3 = this.squarePlotWorld.ROAD_OFFSET_X + n * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2) - 1;
        int n4 = this.squarePlotWorld.ROAD_OFFSET_Z + n2 * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2) - 1;
        return Location.at(this.squarePlotWorld.getWorldName(), n3, this.squarePlotWorld.getMaxGenHeight(), n4);
    }

    @Override
    public PlotId getPlotIdAbs(int n, int n2, int n3) {
        int n4;
        int n5;
        if (this.squarePlotWorld.ROAD_OFFSET_X != 0) {
            n -= this.squarePlotWorld.ROAD_OFFSET_X;
        }
        if (this.squarePlotWorld.ROAD_OFFSET_Z != 0) {
            n3 -= this.squarePlotWorld.ROAD_OFFSET_Z;
        }
        if (this.squarePlotWorld.ROAD_WIDTH == 0) {
            n5 = -1;
            n4 = this.squarePlotWorld.PLOT_WIDTH;
        } else {
            n5 = this.squarePlotWorld.ROAD_WIDTH % 2 == 0 ? this.squarePlotWorld.ROAD_WIDTH / 2 - 1 : this.squarePlotWorld.ROAD_WIDTH / 2;
            n4 = n5 + this.squarePlotWorld.PLOT_WIDTH;
        }
        int n6 = this.squarePlotWorld.PLOT_WIDTH + this.squarePlotWorld.ROAD_WIDTH;
        int n7 = Math.floorDiv(n, n6) + 1;
        int n8 = Math.floorMod(n, n6);
        int n9 = Math.floorDiv(n3, n6) + 1;
        int n10 = Math.floorMod(n3, n6);
        if (n10 <= n5 || n10 > n4 || n8 <= n5 || n8 > n4) {
            return null;
        }
        return PlotId.of(n7, n9);
    }

    public PlotId getNearestPlotId(@NonNull PlotArea plotArea, int n, int n2, int n3) {
        SquarePlotWorld squarePlotWorld = (SquarePlotWorld)plotArea;
        if (squarePlotWorld.ROAD_OFFSET_X != 0) {
            n -= squarePlotWorld.ROAD_OFFSET_X;
        }
        if (squarePlotWorld.ROAD_OFFSET_Z != 0) {
            n3 -= squarePlotWorld.ROAD_OFFSET_Z;
        }
        int n4 = squarePlotWorld.PLOT_WIDTH + squarePlotWorld.ROAD_WIDTH;
        int n5 = n < 0 ? n / n4 : n / n4 + 1;
        int n6 = n3 < 0 ? n3 / n4 : n3 / n4 + 1;
        return PlotId.of(n5, n6);
    }

    @Override
    public PlotId getPlotId(int n, int n2, int n3) {
        try {
            int n4;
            int n5;
            n -= this.squarePlotWorld.ROAD_OFFSET_X;
            n3 -= this.squarePlotWorld.ROAD_OFFSET_Z;
            int n6 = this.squarePlotWorld.PLOT_WIDTH + this.squarePlotWorld.ROAD_WIDTH;
            if (this.squarePlotWorld.ROAD_WIDTH == 0) {
                n5 = -1;
                n4 = this.squarePlotWorld.PLOT_WIDTH;
            } else {
                n5 = this.squarePlotWorld.ROAD_WIDTH % 2 == 0 ? this.squarePlotWorld.ROAD_WIDTH / 2 - 1 : this.squarePlotWorld.ROAD_WIDTH / 2;
                n4 = n5 + this.squarePlotWorld.PLOT_WIDTH;
            }
            int n7 = Math.floorDiv(n, n6) + 1;
            int n8 = Math.floorMod(n, n6);
            int n9 = Math.floorDiv(n3, n6) + 1;
            int n10 = Math.floorMod(n3, n6);
            PlotId plotId = PlotId.of(n7, n9);
            boolean[] blArray = new boolean[]{n10 <= n5, n8 > n4, n10 > n4, n8 <= n5};
            int n11 = HashUtil.hash(blArray);
            if (n11 == 0) {
                return plotId;
            }
            Plot plot = this.squarePlotWorld.getOwnedPlotAbs(plotId);
            if (plot == null) {
                return null;
            }
            switch (n11) {
                case 8: {
                    return plot.isMerged(Direction.NORTH) ? plotId : null;
                }
                case 4: {
                    return plot.isMerged(Direction.EAST) ? plotId : null;
                }
                case 2: {
                    return plot.isMerged(Direction.SOUTH) ? plotId : null;
                }
                case 1: {
                    return plot.isMerged(Direction.WEST) ? plotId : null;
                }
                case 12: {
                    return plot.isMerged(Direction.NORTHEAST) ? plotId : null;
                }
                case 6: {
                    return plot.isMerged(Direction.SOUTHEAST) ? plotId : null;
                }
                case 3: {
                    return plot.isMerged(Direction.SOUTHWEST) ? plotId : null;
                }
                case 9: {
                    return plot.isMerged(Direction.NORTHWEST) ? plotId : null;
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Invalid plot / road width in settings.yml for world: {}", (Object)this.squarePlotWorld.getWorldName());
        }
        return null;
    }

    @Override
    public Location getPlotBottomLocAbs(@NonNull PlotId plotId) {
        int n = plotId.getX();
        int n2 = plotId.getY();
        int n3 = this.squarePlotWorld.ROAD_OFFSET_X + n * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - this.squarePlotWorld.PLOT_WIDTH - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2);
        int n4 = this.squarePlotWorld.ROAD_OFFSET_Z + n2 * (this.squarePlotWorld.ROAD_WIDTH + this.squarePlotWorld.PLOT_WIDTH) - this.squarePlotWorld.PLOT_WIDTH - (int)Math.floor(this.squarePlotWorld.ROAD_WIDTH / 2);
        return Location.at(this.squarePlotWorld.getWorldName(), n3, this.squarePlotWorld.getMinGenHeight(), n4);
    }
}

