/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.ContentType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class EntityMapper {
    private final Map<Class<?>, EntitySerializer<?>> serializers = new HashMap();
    private final Map<Class<?>, EntityDeserializer<?>> deserializers = new HashMap();

    private static <T> T castUnsafe(@NotNull Object object) {
        return (T)object;
    }

    @NotNull
    public static EntityMapper newInstance() {
        EntityMapper entityMapper = new EntityMapper();
        entityMapper.registerDeserializer(String.class, new StringDeserializer());
        entityMapper.registerSerializer(String.class, new StringSerializer());
        return entityMapper;
    }

    @NotNull
    public <T> EntityMapper registerSerializer(@NotNull Class<T> clazz, @NotNull EntitySerializer<T> entitySerializer) {
        Objects.requireNonNull(clazz, "Class may not be null");
        Objects.requireNonNull(entitySerializer, "Serializer may not be null");
        this.serializers.put(clazz, entitySerializer);
        return this;
    }

    @NotNull
    public <T> EntityMapper registerDeserializer(@NotNull Class<T> clazz, @NotNull EntityDeserializer<T> entityDeserializer) {
        Objects.requireNonNull(clazz, "Type may not be null");
        Objects.requireNonNull(entityDeserializer, "Deserializer may not be null");
        this.deserializers.put(clazz, entityDeserializer);
        return this;
    }

    public <T> Optional<EntitySerializer<T>> getSerializer(@NotNull Class<T> clazz) {
        EntitySerializer<?> entitySerializer = this.serializers.get(clazz);
        if (entitySerializer == null) {
            return Optional.empty();
        }
        return Optional.of((EntitySerializer)EntityMapper.castUnsafe(entitySerializer));
    }

    public <T> Optional<EntityDeserializer<T>> getDeserializer(@NotNull Class<T> clazz) {
        EntityDeserializer<?> entityDeserializer = this.deserializers.get(clazz);
        if (entityDeserializer == null) {
            return Optional.empty();
        }
        return Optional.of(entityDeserializer);
    }

    private static final class StringDeserializer
    implements EntityDeserializer<String> {
        private StringDeserializer() {
        }

        @Override
        @NotNull
        public String deserialize(@Nullable ContentType contentType, @NotNull byte[] byArray) {
            Charset charset = contentType != null && contentType.toString().toLowerCase().contains("utf-8") ? StandardCharsets.UTF_8 : (contentType != null && contentType.toString().toLowerCase().contains("utf-16") ? StandardCharsets.UTF_16 : StandardCharsets.US_ASCII);
            return new String(byArray, charset);
        }
    }

    @FunctionalInterface
    public static interface EntityDeserializer<T> {
        @NotNull
        public T deserialize(@Nullable ContentType var1, @NotNull byte[] var2);
    }

    private static final class StringSerializer
    implements EntitySerializer<String> {
        private StringSerializer() {
        }

        @Override
        @NotNull
        public byte[] serialize(@NotNull String string) {
            return string.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public ContentType getContentType() {
            return ContentType.STRING_UTF8;
        }
    }

    public static interface EntitySerializer<T> {
        @NotNull
        public byte[] serialize(@NotNull T var1);

        public ContentType getContentType();
    }
}

