/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.Headers;
import com.plotsquared.core.http.HttpMethod;
import com.plotsquared.core.http.HttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class HttpRequest {
    private static final int READ_TIMEOUT = 3600000;
    @NotNull
    private final HttpMethod method;
    @NotNull
    private final URL url;
    @NotNull
    private final Headers headers;
    @NotNull
    private final EntityMapper mapper;
    @Nullable
    private final Supplier<Object> inputSupplier;
    @NotNull
    private final Consumer<Throwable> throwableConsumer;

    private HttpRequest(@NotNull HttpMethod httpMethod, @NotNull URL uRL, @NotNull Headers headers, @Nullable Supplier<Object> supplier, @NotNull EntityMapper entityMapper, @NotNull Consumer<Throwable> consumer) {
        this.method = httpMethod;
        this.url = uRL;
        this.headers = headers;
        this.inputSupplier = supplier;
        this.mapper = entityMapper;
        this.throwableConsumer = consumer;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    HttpResponse executeRequest() {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
        try {
            List<String> list;
            Object object2;
            httpURLConnection.setRequestMethod(this.method.name());
            httpURLConnection.setDoOutput(this.method.hasBody());
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setReadTimeout(3600000);
            Object object3 = this.headers.getHeaders().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                list = this.headers.getHeaders((String)object2);
                if (list.size() == 1) {
                    httpURLConnection.addRequestProperty((String)object2, list.get(0));
                    continue;
                }
                if (list.size() <= 1) continue;
                StringBuilder object4 = new StringBuilder();
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    object4.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    object4.append(',');
                }
                httpURLConnection.addRequestProperty((String)object2, object4.toString());
            }
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(this.inputSupplier != null);
            if (this.inputSupplier != null && (object3 = this.inputSupplier.get()) != null) {
                object2 = this.mapper.getSerializer(object3.getClass()).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered serializer for type '%s'", object3.getClass().getCanonicalName())));
                if (this.headers.getHeader("Content-Type").isEmpty()) {
                    httpURLConnection.setRequestProperty("Content-Type", object2.getContentType().toString());
                }
                list = (List<String>)object2.serialize(object3);
                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(((Object)list).length));
                try (DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());){
                    dataOutputStream.write((byte[])list);
                    dataOutputStream.flush();
                }
            }
            httpURLConnection.connect();
            object3 = this.method.hasBody() ? (httpURLConnection.getResponseCode() != 200 ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream()) : null;
            object2 = HttpResponse.builder().withStatus(httpURLConnection.getResponseCode()).withStatusMessage(httpURLConnection.getResponseMessage()).withEntityMapper(this.mapper);
            for (Map.Entry entry : httpURLConnection.getHeaderFields().entrySet()) {
                if (entry.getKey() == null) continue;
                for (String string : (List)entry.getValue()) {
                    ((HttpResponse.Builder)object2).withHeader((String)entry.getKey(), string);
                }
            }
            if (object3 != null) {
                list = object3;
                try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    int n;
                    while ((n = ((InputStream)object3).read()) != -1) {
                        byteArrayOutputStream.write(n);
                    }
                    ((HttpResponse.Builder)object2).withBody(byteArrayOutputStream.toByteArray());
                }
                finally {
                    if (list != null) {
                        ((InputStream)((Object)list)).close();
                    }
                }
            }
            list = ((HttpResponse.Builder)object2).build();
            return list;
        }
        catch (Throwable throwable) {
            this.throwableConsumer.accept(throwable);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return null;
    }

    static final class Builder {
        private final Headers headers = Headers.newInstance();
        private EntityMapper mapper;
        private HttpMethod method;
        private URL url;
        private Supplier<Object> inputSupplier;
        private Consumer<Throwable> throwableConsumer = Throwable::printStackTrace;

        private Builder() {
        }

        @NotNull
        Builder withMapper(@NotNull EntityMapper entityMapper) {
            this.mapper = Objects.requireNonNull(entityMapper, "Mapper may not be null");
            return this;
        }

        @NotNull
        Builder withMethod(@NotNull HttpMethod httpMethod) {
            this.method = Objects.requireNonNull(httpMethod, "Method may not be null");
            return this;
        }

        @NotNull
        Builder withURL(@NotNull URL uRL) {
            this.url = Objects.requireNonNull(uRL, "URL may not be null");
            return this;
        }

        @NotNull
        Builder withHeader(@NotNull String string, @NotNull String string2) {
            this.headers.addHeader(Objects.requireNonNull(string, "Key may not be null"), Objects.requireNonNull(string2, "Value may not be null"));
            return this;
        }

        @NotNull
        Builder withInput(@NotNull Supplier<Object> supplier) {
            this.inputSupplier = Objects.requireNonNull(supplier, "Input supplier may not be null");
            return this;
        }

        @NotNull
        Builder onException(@NotNull Consumer<Throwable> consumer) {
            this.throwableConsumer = Objects.requireNonNull(consumer, "Consumer may not be null");
            return this;
        }

        @NotNull
        HttpRequest build() {
            Objects.requireNonNull(this.method, "No method was supplied");
            Objects.requireNonNull(this.url, "No URL was supplied");
            Objects.requireNonNull(this.mapper, "No mapper was supplied");
            Objects.requireNonNull(this.throwableConsumer, "No throwable consumer was supplied");
            return new HttpRequest(this.method, this.url, this.headers, this.inputSupplier, this.mapper, this.throwableConsumer);
        }
    }
}

