/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.http.ContentType;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.Headers;
import java.util.Objects;

public final class HttpResponse {
    private final Headers headers;
    private final EntityMapper entityMapper;
    private final int code;
    private final String status;
    private final byte[] body;

    private HttpResponse(int n, @NotNull String string, @NotNull Headers headers, @NotNull EntityMapper entityMapper, @NotNull byte[] byArray) {
        this.status = string;
        this.code = n;
        this.headers = headers;
        this.entityMapper = entityMapper;
        this.body = byArray;
    }

    @NotNull
    static Builder builder() {
        return new Builder();
    }

    @NotNull
    public String getStatus() {
        return this.status;
    }

    public int getStatusCode() {
        return this.code;
    }

    @NotNull
    public byte[] getRawResponse() {
        return this.body;
    }

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public <T> T getResponseEntity(@NotNull Class<T> clazz) {
        String string = this.headers.getOrDefault("content-type", null);
        ContentType contentType = string != null ? ContentType.of(string) : null;
        return (T)this.entityMapper.getDeserializer(clazz).map(entityDeserializer -> entityDeserializer.deserialize(contentType, this.getRawResponse())).orElseThrow(() -> new IllegalStateException(String.format("Could not deserialize response into type '%s'", clazz.getCanonicalName())));
    }

    static class Builder {
        private final Headers headers = Headers.newInstance();
        private int status;
        private String statusMessage;
        private EntityMapper entityMapper;
        private byte[] bytes = new byte[0];

        private Builder() {
        }

        @NotNull
        Builder withStatus(int n) {
            this.status = n;
            return this;
        }

        @NotNull
        Builder withStatusMessage(@NotNull String string) {
            this.statusMessage = string;
            return this;
        }

        @NotNull
        Builder withHeader(@NotNull String string, @NotNull String string2) {
            this.headers.addHeader(Objects.requireNonNull(string, "Key may not be null"), Objects.requireNonNull(string2, "Value may not be null"));
            return this;
        }

        @NotNull
        Builder withEntityMapper(@NotNull EntityMapper entityMapper) {
            this.entityMapper = Objects.requireNonNull(entityMapper, "Mapper may not be null");
            return this;
        }

        @NotNull
        Builder withBody(@NotNull byte[] byArray) {
            this.bytes = Objects.requireNonNull(byArray, "Bytes may not be null");
            return this;
        }

        @NotNull
        HttpResponse build() {
            return new HttpResponse(this.status, this.statusMessage, this.headers, this.entityMapper, this.bytes);
        }
    }
}

