/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.listener;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.listener.ProcessedWEExtent;
import com.plotsquared.core.listener.WEExtent;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.WEManager;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.eventbus.EventHandler;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WESubscriber {
    private final PlotAreaManager plotAreaManager;
    private final WorldUtil worldUtil;

    @Inject
    public WESubscriber(@NonNull PlotAreaManager plotAreaManager, @NonNull WorldUtil worldUtil) {
        this.plotAreaManager = plotAreaManager;
        this.worldUtil = worldUtil;
    }

    @Subscribe(priority=EventHandler.Priority.VERY_EARLY)
    public void onEditSession(EditSessionEvent editSessionEvent) {
        if (!Settings.Enabled_Components.WORLDEDIT_RESTRICTIONS) {
            WorldEdit.getInstance().getEventBus().unregister((Object)this);
            return;
        }
        if (editSessionEvent.getStage() != EditSession.Stage.BEFORE_HISTORY) {
            return;
        }
        World world = editSessionEvent.getWorld();
        if (world == null) {
            return;
        }
        String string = world.getName();
        Actor actor = editSessionEvent.getActor();
        if (actor != null && actor.isPlayer()) {
            Set<CuboidRegion> set;
            String string2 = actor.getName();
            PlotPlayer<?> plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(string2);
            if (plotPlayer == null) {
                Player player = (Player)actor;
                com.sk89q.worldedit.util.Location location = player.getLocation();
                Location location2 = Location.at(player.getWorld().getName(), location.toVector().toBlockPoint());
                Plot plot = location2.getPlot();
                if (plot == null) {
                    editSessionEvent.setExtent((Extent)new NullExtent());
                    return;
                }
                set = plot.getRegions();
            } else {
                if (plotPlayer.getAttribute("worldedit")) {
                    return;
                }
                set = WEManager.getMask(plotPlayer);
                if (set.isEmpty()) {
                    if (plotPlayer.hasPermission("plots.worldedit.bypass")) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("worldedit.worldedit_bypass"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot toggle worldedit"))));
                    }
                    if (this.plotAreaManager.hasPlotArea(string)) {
                        editSessionEvent.setExtent((Extent)new NullExtent());
                    }
                    return;
                }
            }
            if (Settings.Enabled_Components.CHUNK_PROCESSOR) {
                if (this.plotAreaManager.hasPlotArea(string)) {
                    editSessionEvent.setExtent((Extent)new ProcessedWEExtent(string, set, editSessionEvent.getMaxBlocks(), editSessionEvent.getExtent(), editSessionEvent.getExtent(), this.worldUtil));
                }
            } else if (this.plotAreaManager.hasPlotArea(string)) {
                editSessionEvent.setExtent((Extent)new WEExtent(set, editSessionEvent.getExtent()));
            }
        }
    }
}

