/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class TemporaryMetaDataAccess<T>
extends MetaDataAccess<T> {
    TemporaryMetaDataAccess(@NonNull PlotPlayer<?> plotPlayer, @NonNull MetaDataKey<T> metaDataKey,  @NonNull LockRepository.LockAccess lockAccess) {
        super(plotPlayer, metaDataKey, lockAccess);
    }

    @Override
    public boolean isPresent() {
        this.checkClosed();
        return this.getPlayer().getMeta(this.getMetaDataKey().toString()) != null;
    }

    @Override
    public @Nullable T remove() {
        this.checkClosed();
        Object object = this.getPlayer().deleteMeta(this.getMetaDataKey().toString());
        if (object == null) {
            return null;
        }
        return (T)object;
    }

    @Override
    public void set(@NonNull T t) {
        this.checkClosed();
        this.getPlayer().setMeta(this.getMetaDataKey().toString(), t);
    }

    @Override
    public @NonNull Optional<T> get() {
        this.checkClosed();
        return Optional.ofNullable(this.getPlayer().getMeta(this.getMetaDataKey().toString()));
    }
}

