/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableMap;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.serialization.ConfigurationSerializable;
import com.plotsquared.core.util.BlockUtil;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.core.util.StringMan;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BlockBucket
implements ConfigurationSerializable {
    private static final Pattern regex = Pattern.compile("((?<namespace>[A-Za-z_]+):)?(?<block>([A-Za-z_]+(\\[?[\\S\\s]+\\])?))(:(?<chance>[0-9]{1,3}))?");
    private final StringBuilder input;
    private boolean compiled;
    private BlockState single;
    private com.sk89q.worldedit.function.pattern.Pattern pattern;

    public BlockBucket(@NonNull BlockType blockType) {
        this(blockType.getId());
        this.single = blockType.getDefaultState();
        this.pattern = new BlockPattern((BlockStateHolder)this.single);
        this.compiled = true;
    }

    public BlockBucket(@NonNull BlockState blockState) {
        this(blockState.getAsString());
        this.single = blockState;
        this.pattern = new BlockPattern((BlockStateHolder)this.single);
        this.compiled = true;
    }

    public BlockBucket(@NonNull String string) {
        this.input = new StringBuilder(string);
    }

    public BlockBucket() {
        this.input = new StringBuilder();
    }

    public static BlockBucket withSingle(@NonNull BlockState blockState) {
        BlockBucket blockBucket = new BlockBucket();
        blockBucket.addBlock(blockState, 100);
        return blockBucket;
    }

    public static BlockBucket deserialize(@NonNull Map<String, Object> map) {
        if (!map.containsKey("blocks")) {
            return null;
        }
        return ConfigurationUtil.BLOCK_BUCKET.parseString(map.get("blocks").toString());
    }

    public void addBlock(@NonNull BlockState blockState) {
        this.addBlock(blockState, -1);
    }

    public void addBlock(@NonNull BlockState blockState, int n) {
        this.addBlock(blockState, (double)n);
    }

    private void addBlock(@NonNull BlockState blockState, double d) {
        if (d == -1.0) {
            d = 1.0;
        }
        String string = this.input.length() == 0 ? "" : ",";
        this.input.append(string).append(blockState).append(":").append(d);
        this.compiled = false;
    }

    public boolean isEmpty() {
        return this.input == null || this.input.length() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        if (this.isCompiled()) {
            return;
        }
        BlockBucket blockBucket = this;
        synchronized (blockBucket) {
            if (this.isCompiled()) {
                return;
            }
            Object object = this.input.toString();
            if (((String)object).isEmpty()) {
                this.single = null;
                this.pattern = null;
                this.compiled = true;
                return;
            }
            boolean bl = false;
            Object[] objectArray = ((String)object).split(",(?![^\\(\\[]*[\\]\\)])");
            if (objectArray.length == 1) {
                try {
                    Matcher matcher = regex.matcher((CharSequence)object);
                    if (matcher.find()) {
                        String string = matcher.group("chance");
                        String string2 = matcher.group("block");
                        if (string != null && string2 != null && !MathMan.isInteger(string2) && MathMan.isInteger(string)) {
                            String string3 = matcher.group("namespace");
                            object = (String)(string3 == null ? "" : string3 + ":") + string2;
                        }
                    }
                    this.single = BlockUtil.get((String)object);
                    this.pattern = new BlockPattern((BlockStateHolder)this.single);
                    this.compiled = true;
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                Object object2 = objectArray[i];
                Matcher matcher = regex.matcher((CharSequence)object2);
                if (!matcher.find() || (string = matcher.group("chance")) == null || !MathMan.isInteger(string)) continue;
                Object[] objectArray2 = ((String)object2).split(":");
                objectArray2 = Arrays.copyOf(objectArray2, objectArray2.length - 1);
                objectArray[i] = object2 = string + "%" + StringMan.join(objectArray2, ":");
                bl = true;
            }
            if (bl) {
                object = StringMan.join(objectArray, ",");
            }
            this.pattern = PatternUtil.parse(null, (String)object);
            this.compiled = true;
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public com.sk89q.worldedit.function.pattern.Pattern toPattern() {
        this.compile();
        return this.pattern;
    }

    public String toString() {
        return this.input.toString();
    }

    public boolean isAir() {
        this.compile();
        return this.isEmpty() || this.single != null && this.single.getBlockType().getMaterial().isAir();
    }

    @Override
    public Map<String, Object> serialize() {
        if (!this.isCompiled()) {
            this.compile();
        }
        return ImmutableMap.of((Object)"blocks", (Object)this.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BlockBucket)) {
            return false;
        }
        BlockBucket blockBucket = (BlockBucket)object;
        StringBuilder stringBuilder = this.input;
        StringBuilder stringBuilder2 = blockBucket.input;
        return Objects.equals(stringBuilder, stringBuilder2);
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        StringBuilder stringBuilder = this.input;
        n2 = n2 * 59 + (stringBuilder == null ? 43 : stringBuilder.hashCode());
        return n2;
    }

    private record Range(int min, int max, boolean automatic) {
        public int getWeight() {
            return this.max - this.min;
        }

        public boolean isInRange(int n) {
            return n <= this.max && n >= this.min;
        }
    }
}

