/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Like;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.ComponentLike;
import com.plotsquared.core.configuration.adventure.text.TextComponent;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotCommentContainer;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.PlotModificationManager;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.InternalFlag;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DescriptionFlag;
import com.plotsquared.core.plot.flag.implementations.KeepFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.plot.flag.types.DoubleFlag;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlayerManager;
import com.plotsquared.core.util.RegionManager;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.TimeUtil;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.lang.ref.Cleaner;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Plot {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + Plot.class.getSimpleName()));
    private static final DecimalFormat FLAG_DECIMAL_FORMAT = new DecimalFormat("0");
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final Cleaner CLEANER = Cleaner.create();
    private final FlagContainer flagContainer = new FlagContainer(null);
    private final PlotCommentContainer plotCommentContainer = new PlotCommentContainer(this);
    private final PlotModificationManager plotModificationManager = new PlotModificationManager(this);
    @Deprecated
    public int temp;
    HashSet<UUID> trusted;
    HashSet<UUID> members;
    HashSet<UUID> denied;
    PlotSettings settings;
    private @NonNull PlotId id;
    @Inject
    private EventDispatcher eventDispatcher;
    @Inject
    private PlotListener plotListener;
    @Inject
    private RegionManager regionManager;
    @Inject
    private WorldUtil worldUtil;
    @Inject
    private SchematicHandler schematicHandler;
    private UUID owner;
    private long timestamp;
    private PlotArea area;
    private ConcurrentHashMap<String, Object> meta;
    private Plot origin;
    private Set<Plot> connectedCache;

    public Plot(PlotArea plotArea, @NonNull PlotId plotId, UUID uUID) {
        this(plotArea, plotId, uUID, 0);
    }

    public Plot(@NonNull PlotArea plotArea, @NonNull PlotId plotId) {
        this(plotArea, plotId, null, 0);
    }

    public Plot(PlotArea plotArea, @NonNull PlotId plotId, UUID uUID, int n) {
        this.area = plotArea;
        this.id = plotId;
        this.owner = uUID;
        this.temp = n;
        this.flagContainer.setParentContainer(plotArea.getFlagContainer());
        PlotSquared.platform().injector().injectMembers(this);
        CLEANER.register(this, this.flagContainer.createCleanupHook());
    }

    public Plot(@NonNull PlotId plotId, UUID uUID, HashSet<UUID> hashSet, HashSet<UUID> hashSet2, HashSet<UUID> hashSet3, String string, BlockLoc blockLoc, Collection<PlotFlag<?, ?>> collection, PlotArea plotArea, boolean[] blArray, long l, int n) {
        this.id = plotId;
        this.area = plotArea;
        this.owner = uUID;
        this.settings = new PlotSettings();
        this.members = hashSet2;
        this.trusted = hashSet;
        this.denied = hashSet3;
        this.settings.setAlias(string);
        this.settings.setPosition(blockLoc);
        this.settings.setMerged(blArray);
        this.timestamp = l;
        this.temp = n;
        if (plotArea != null) {
            this.flagContainer.setParentContainer(plotArea.getFlagContainer());
            if (collection != null) {
                for (PlotFlag<?, ?> plotFlag : collection) {
                    this.flagContainer.addFlag(plotFlag);
                }
            }
        }
        PlotSquared.platform().injector().injectMembers(this);
    }

    public static @Nullable Plot getPlotFromString(@Nullable PlotPlayer<?> plotPlayer, @Nullable String string, boolean bl) {
        PlotId plotId;
        String[] stringArray;
        PlotArea plotArea;
        if (string == null) {
            if (plotPlayer == null) {
                if (bl) {
                    LOGGER.info("No plot area string was supplied");
                }
                return null;
            }
            return plotPlayer.getCurrentPlot();
        }
        if (plotPlayer != null) {
            plotArea = PlotSquared.get().getPlotAreaManager().getPlotAreaByString(string);
            if (plotArea == null) {
                plotArea = plotPlayer.getApplicablePlotArea();
            }
        } else {
            plotArea = ConsolePlayer.getConsole().getApplicablePlotArea();
        }
        if ((stringArray = string.split("[;,]")).length == 4) {
            plotArea = PlotSquared.get().getPlotAreaManager().getPlotAreaByString(stringArray[0] + ";" + stringArray[1]);
            plotId = PlotId.fromString(stringArray[2] + ";" + stringArray[3]);
        } else if (stringArray.length == 3) {
            plotArea = PlotSquared.get().getPlotAreaManager().getPlotAreaByString(stringArray[0]);
            plotId = PlotId.fromString(stringArray[1] + ";" + stringArray[2]);
        } else if (stringArray.length == 2) {
            plotId = PlotId.fromString(string);
        } else {
            Collection<Plot> collection = plotArea == null ? PlotQuery.newQuery().allPlots().asList() : plotArea.getPlots();
            for (Plot plot : collection) {
                String string2 = plot.getAlias();
                if (string2.isEmpty() || !string2.equalsIgnoreCase(string)) continue;
                return plot.getBasePlot(false);
            }
            if (bl && plotPlayer != null) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("invalid.not_valid_plot_id"), new TagResolver[0]);
            }
            return null;
        }
        if (plotArea == null) {
            if (bl && plotPlayer != null) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.invalid_plot_world"), new TagResolver[0]);
            }
            return null;
        }
        return plotArea.getPlotAbs(plotId);
    }

    public static @Nullable Plot fromString(@Nullable PlotArea plotArea, @NonNull String string) {
        PlotArea plotArea2;
        String[] stringArray = string.split("[;,]");
        if (stringArray.length == 2) {
            if (plotArea != null) {
                PlotId plotId = PlotId.fromString(stringArray[0] + ";" + stringArray[1]);
                return plotArea.getPlotAbs(plotId);
            }
        } else if (stringArray.length == 3) {
            PlotArea plotArea3 = PlotSquared.get().getPlotAreaManager().getPlotArea(stringArray[0], null);
            if (plotArea3 != null) {
                PlotId plotId = PlotId.fromString(stringArray[1] + ";" + stringArray[2]);
                return plotArea3.getPlotAbs(plotId);
            }
        } else if (stringArray.length == 4 && (plotArea2 = PlotSquared.get().getPlotAreaManager().getPlotArea(stringArray[0], stringArray[1])) != null) {
            PlotId plotId = PlotId.fromString(stringArray[1] + ";" + stringArray[2]);
            return plotArea2.getPlotAbs(plotId);
        }
        return null;
    }

    public static @Nullable Plot getPlot(@NonNull Location location) {
        PlotArea plotArea = location.getPlotArea();
        if (plotArea != null) {
            return plotArea.getPlot(location);
        }
        return null;
    }

    static @NonNull Location[] getCorners(@NonNull String string, @NonNull CuboidRegion cuboidRegion) {
        BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
        BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
        return new Location[]{Location.at(string, blockVector3), Location.at(string, blockVector32)};
    }

    public @Nullable UUID getOwnerAbs() {
        return this.owner;
    }

    public void setOwnerAbs(@Nullable UUID uUID) {
        this.owner = uUID;
    }

    public @Nullable String getWorldName() {
        return this.area.getWorldName();
    }

    public void setMeta(@NonNull String string, @NonNull Object object) {
        if (this.meta == null) {
            this.meta = new ConcurrentHashMap();
        }
        this.meta.put(string, object);
    }

    public @Nullable Object getMeta(@NonNull String string) {
        if (this.meta != null) {
            return this.meta.get(string);
        }
        return null;
    }

    public void deleteMeta(@NonNull String string) {
        if (this.meta != null) {
            this.meta.remove(string);
        }
    }

    public @Nullable PlotCluster getCluster() {
        if (this.getArea() == null) {
            return null;
        }
        return this.getArea().getCluster(this.id);
    }

    public @NonNull List<PlotPlayer<?>> getPlayersInPlot() {
        ArrayList arrayList = new ArrayList();
        for (PlotPlayer<?> plotPlayer : PlotSquared.platform().playerManager().getPlayers()) {
            if (!this.equals(plotPlayer.getCurrentPlot())) continue;
            arrayList.add(plotPlayer);
        }
        return arrayList;
    }

    public boolean hasOwner() {
        return this.getOwnerAbs() != null;
    }

    public boolean isOwner(@NonNull UUID uUID) {
        if (uUID.equals(this.getOwner())) {
            return true;
        }
        if (!this.isMerged()) {
            return false;
        }
        Set<Plot> set = this.getConnectedPlots();
        for (Plot plot : set) {
            if (!uUID.equals(plot.getOwnerAbs())) continue;
            return true;
        }
        return false;
    }

    public boolean isOwnerAbs(@Nullable UUID uUID) {
        if (uUID == null) {
            return false;
        }
        return uUID.equals(this.getOwner());
    }

    public @Nullable UUID getOwner() {
        if (((Boolean)this.getFlag((PlotFlag)((Object)ServerPlotFlag.class))).booleanValue()) {
            return DBFunc.SERVER;
        }
        return this.getOwnerAbs();
    }

    public void setOwner(@NonNull UUID uUID) {
        if (!this.hasOwner()) {
            this.setOwnerAbs(uUID);
            this.getPlotModificationManager().create();
            return;
        }
        if (!this.isMerged()) {
            if (!uUID.equals(this.getOwnerAbs())) {
                this.setOwnerAbs(uUID);
                DBFunc.setOwner(this, uUID);
            }
            return;
        }
        for (Plot plot : this.getConnectedPlots()) {
            if (uUID.equals(plot.getOwnerAbs())) continue;
            plot.setOwnerAbs(uUID);
            DBFunc.setOwner(plot, uUID);
        }
    }

    public @NonNull Set<UUID> getOwners() {
        if (this.getOwner() == null) {
            return ImmutableSet.of();
        }
        if (this.isMerged()) {
            Set<Plot> set = this.getConnectedPlots();
            Plot[] plotArray = set.toArray(new Plot[0]);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            UUID uUID = this.getOwner();
            builder.add((Object)this.getOwner());
            for (Plot plot : plotArray) {
                if (plot.getOwner() == null || uUID != null && plot.getOwner().getMostSignificantBits() == uUID.getMostSignificantBits()) continue;
                builder.add((Object)plot.getOwner());
                uUID = plot.getOwner();
            }
            return builder.build();
        }
        return ImmutableSet.of((Object)this.getOwner());
    }

    public boolean isAdded(@NonNull UUID uUID) {
        if (!this.hasOwner() || this.getDenied().contains(uUID)) {
            return false;
        }
        if (this.isOwner(uUID)) {
            return true;
        }
        if (this.getMembers().contains(uUID)) {
            return this.isOnline();
        }
        if (this.getTrusted().contains(uUID) || this.getTrusted().contains(DBFunc.EVERYONE)) {
            return true;
        }
        if (this.getMembers().contains(DBFunc.EVERYONE)) {
            return this.isOnline();
        }
        return false;
    }

    public boolean isDenied(@NonNull UUID uUID) {
        return this.denied != null && (this.denied.contains(DBFunc.EVERYONE) && !this.isAdded(uUID) || !this.isAdded(uUID) && this.denied.contains(uUID));
    }

    public @NonNull PlotId getId() {
        return this.id;
    }

    public void setId(@NonNull PlotId plotId) {
        this.id = plotId;
    }

    public @Nullable PlotArea getArea() {
        return this.area;
    }

    public void setArea(@NonNull PlotArea plotArea) {
        if (this.getArea() == plotArea) {
            return;
        }
        if (this.getArea() != null) {
            this.area.removePlot(this.id);
        }
        this.area = plotArea;
        plotArea.addPlot(this);
        this.flagContainer.setParentContainer(plotArea.getFlagContainer());
    }

    public @NonNull PlotManager getManager() {
        return this.area.getPlotManager();
    }

    public @NonNull PlotSettings getSettings() {
        if (this.settings == null) {
            this.settings = new PlotSettings();
        }
        return this.settings;
    }

    public boolean isBasePlot() {
        return !this.isMerged() || this.equals(this.getBasePlot(false));
    }

    public Plot getBasePlot(boolean bl) {
        if (this.origin != null && !bl) {
            if (this.equals(this.origin)) {
                return this;
            }
            return this.origin.getBasePlot(false);
        }
        if (!this.isMerged()) {
            this.origin = this;
            return this.origin;
        }
        this.origin = this;
        PlotId plotId = this.id;
        for (Plot plot : this.getConnectedPlots()) {
            if (plot.id.getY() >= plotId.getY() && (plot.id.getY() != plotId.getY() || plot.id.getX() >= plotId.getX())) continue;
            this.origin = plot;
            plotId = plot.id;
        }
        for (Plot plot : this.getConnectedPlots()) {
            plot.origin = this.origin;
        }
        return this.origin;
    }

    public boolean isMerged() {
        return this.getSettings().getMerged(0) || this.getSettings().getMerged(2) || this.getSettings().getMerged(1) || this.getSettings().getMerged(3);
    }

    public long getTimestamp() {
        if (this.timestamp == 0L) {
            this.timestamp = System.currentTimeMillis();
        }
        return this.timestamp;
    }

    public boolean isMerged(int n) {
        if (this.settings == null) {
            return false;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.getSettings().getMerged(n);
            }
            case 7: {
                int n2 = n - 4;
                int n3 = 0;
                if (this.getSettings().getMerged(n3) && this.getSettings().getMerged(n2) && Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(n2)))).isMerged(n3)) {
                    return Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(n3)))).isMerged(n2);
                }
                return false;
            }
            case 4: 
            case 5: 
            case 6: {
                int n4 = n - 4;
                int n5 = n - 3;
                return this.getSettings().getMerged(n5) && this.getSettings().getMerged(n4) && Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(n4)))).isMerged(n5) && Objects.requireNonNull(this.area.getPlotAbs(this.id.getRelative(Direction.getFromIndex(n5)))).isMerged(n4);
            }
        }
        return false;
    }

    public @NonNull HashSet<UUID> getDenied() {
        if (this.denied == null) {
            this.denied = new HashSet();
        }
        return this.denied;
    }

    public void setDenied(@NonNull Set<UUID> set) {
        boolean bl = set.size() > this.getDenied().size();
        HashSet<UUID> hashSet = bl ? new HashSet<UUID>(this.getDenied()) : new HashSet<UUID>(set);
        if (bl) {
            hashSet.retainAll(set);
        } else {
            hashSet.retainAll(this.getDenied());
        }
        set.removeAll(hashSet);
        HashSet<UUID> hashSet2 = new HashSet<UUID>(this.getDenied());
        hashSet2.removeAll(hashSet);
        for (UUID uUID : hashSet2) {
            this.removeDenied(uUID);
        }
        for (UUID uUID : set) {
            this.addDenied(uUID);
        }
    }

    public @NonNull HashSet<UUID> getTrusted() {
        if (this.trusted == null) {
            this.trusted = new HashSet();
        }
        return this.trusted;
    }

    public void setTrusted(@NonNull Set<UUID> set) {
        boolean bl = set.size() > this.getTrusted().size();
        HashSet<UUID> hashSet = new HashSet<UUID>(bl ? this.getTrusted() : set);
        hashSet.retainAll(bl ? set : this.getTrusted());
        set.removeAll(hashSet);
        HashSet<UUID> hashSet2 = new HashSet<UUID>(this.getTrusted());
        hashSet2.removeAll(hashSet);
        for (UUID uUID : hashSet2) {
            this.removeTrusted(uUID);
        }
        for (UUID uUID : set) {
            this.addTrusted(uUID);
        }
    }

    public @NonNull HashSet<UUID> getMembers() {
        if (this.members == null) {
            this.members = new HashSet();
        }
        return this.members;
    }

    public void setMembers(@NonNull Set<UUID> set) {
        boolean bl = set.size() > this.getMembers().size();
        HashSet<UUID> hashSet = new HashSet<UUID>(bl ? this.getMembers() : set);
        hashSet.retainAll(bl ? set : this.getMembers());
        set.removeAll(hashSet);
        HashSet<UUID> hashSet2 = new HashSet<UUID>(this.getMembers());
        hashSet2.removeAll(hashSet);
        for (UUID uUID : hashSet2) {
            this.removeMember(uUID);
        }
        for (UUID uUID : set) {
            this.addMember(uUID);
        }
    }

    public void addDenied(@NonNull UUID uUID) {
        for (Plot plot : this.getConnectedPlots()) {
            if (!plot.getDenied().add(uUID)) continue;
            DBFunc.setDenied(plot, uUID);
        }
    }

    public void addTrusted(@NonNull UUID uUID) {
        for (Plot plot : this.getConnectedPlots()) {
            if (!plot.getTrusted().add(uUID)) continue;
            DBFunc.setTrusted(plot, uUID);
        }
    }

    public void addMember(@NonNull UUID uUID) {
        for (Plot plot : this.getConnectedPlots()) {
            if (!plot.getMembers().add(uUID)) continue;
            DBFunc.setMember(plot, uUID);
        }
    }

    public boolean setOwner(UUID uUID, PlotPlayer<?> plotPlayer) {
        if (!this.hasOwner()) {
            this.setOwnerAbs(uUID);
            this.getPlotModificationManager().create();
            return true;
        }
        if (!this.isMerged()) {
            if (!uUID.equals(this.getOwnerAbs())) {
                this.setOwnerAbs(uUID);
                DBFunc.setOwner(this, uUID);
            }
            return true;
        }
        for (Plot plot : this.getConnectedPlots()) {
            if (uUID.equals(plot.getOwnerAbs())) continue;
            plot.setOwnerAbs(uUID);
            DBFunc.setOwner(plot, uUID);
        }
        return true;
    }

    public boolean isLoaded() {
        return this.worldUtil.isWorld(this.getWorldName());
    }

    public PlotAnalysis getComplexity(Settings.Auto_Clear auto_Clear) {
        return PlotAnalysis.getAnalysis(this, auto_Clear);
    }

    public Set<PlotFlag<?, ?>> getFlags() {
        return ImmutableSet.copyOf(this.flagContainer.getFlagMap().values());
    }

    public <V> boolean setFlag(@NonNull PlotFlag<V, ?> plotFlag) {
        if (plotFlag instanceof KeepFlag && PlotSquared.platform().expireManager() != null) {
            PlotSquared.platform().expireManager().updateExpired(this);
        }
        for (Plot plot : this.getConnectedPlots()) {
            plot.getFlagContainer().addFlag(plotFlag);
            plot.reEnter();
            DBFunc.setFlag(plot, plotFlag);
        }
        return true;
    }

    public boolean setFlag(@NonNull Class<?> clazz, @NonNull String string) {
        try {
            this.setFlag((PlotFlag)GlobalFlagContainer.getInstance().getFlagErased(clazz).parse(string));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean removeFlag(@NonNull Class<? extends PlotFlag<?, ?>> clazz) {
        return this.removeFlag((PlotFlag<?, ?>)this.getFlagContainer().queryLocal(clazz));
    }

    public Collection<PlotFlag<?, ?>> getApplicableFlags(boolean bl, boolean bl2) {
        Map<Class<?>, PlotFlag<?, ?>> map;
        if (!this.hasOwner()) {
            return Collections.emptyList();
        }
        HashMap hashMap = new HashMap();
        if (!bl && this.getArea() != null && !this.getArea().getFlagContainer().getFlagMap().isEmpty()) {
            map = this.getArea().getFlagContainer().getFlagMap();
            hashMap.putAll(map);
        }
        map = this.getFlagContainer().getFlagMap();
        if (bl2) {
            for (PlotFlag<?, ?> plotFlag : map.values()) {
                if (plotFlag instanceof InternalFlag) continue;
                hashMap.put(plotFlag.getClass(), plotFlag);
            }
        } else {
            hashMap.putAll(map);
        }
        return hashMap.values();
    }

    public Collection<PlotFlag<?, ?>> getApplicableFlags(boolean bl) {
        return this.getApplicableFlags(false, bl);
    }

    public boolean removeFlag(@NonNull PlotFlag<?, ?> plotFlag) {
        if (plotFlag == null || this.origin == null) {
            return false;
        }
        boolean bl = false;
        for (Plot plot : this.origin.getConnectedPlots()) {
            Object v = plot.getFlagContainer().removeFlag(plotFlag);
            if (v == null) continue;
            plot.reEnter();
            DBFunc.removeFlag(plot, plotFlag);
            bl = true;
        }
        return bl;
    }

    public int[] countEntities() {
        int[] nArray = new int[6];
        for (Plot plot : this.getConnectedPlots()) {
            int[] nArray2 = this.regionManager.countEntities(plot);
            nArray[0] = nArray[0] + nArray2[0];
            nArray[1] = nArray[1] + nArray2[1];
            nArray[2] = nArray[2] + nArray2[2];
            nArray[3] = nArray[3] + nArray2[3];
            nArray[4] = nArray[4] + nArray2[4];
            nArray[5] = nArray[5] + nArray2[5];
        }
        return nArray;
    }

    public int addRunning() {
        int n = this.getRunning();
        for (Plot plot : this.getConnectedPlots()) {
            plot.setMeta("running", n + 1);
        }
        return n;
    }

    public int removeRunning() {
        int n = this.getRunning();
        if (n < 2) {
            for (Plot plot : this.getConnectedPlots()) {
                plot.deleteMeta("running");
            }
        } else {
            for (Plot plot : this.getConnectedPlots()) {
                plot.setMeta("running", n - 1);
            }
        }
        return n;
    }

    public int getRunning() {
        Integer n = (Integer)this.getMeta("running");
        return n == null ? 0 : n;
    }

    public boolean unclaim() {
        if (!this.hasOwner()) {
            return false;
        }
        for (Plot plot : this.getConnectedPlots()) {
            List<PlotPlayer<?>> list = plot.getPlayersInPlot();
            for (PlotPlayer<?> plotPlayer : list) {
                this.plotListener.plotExit(plotPlayer, plot);
            }
            if (Settings.Backup.DELETE_ON_UNCLAIM) {
                Objects.requireNonNull(PlotSquared.platform()).backupManager().getProfile(plot).destroy();
            }
            this.getArea().removePlot(this.getId());
            DBFunc.delete(plot);
            plot.setOwnerAbs(null);
            plot.settings = null;
            plot.clearCache();
            for (PlotPlayer<?> plotPlayer : list) {
                this.plotListener.plotEntry(plotPlayer, plot);
            }
        }
        return true;
    }

    public void getCenter(Consumer<Location> consumer) {
        Location[] locationArray = this.getCorners();
        Location location = locationArray[0];
        Location location2 = locationArray[1];
        Location location3 = Location.at(this.getWorldName(), MathMan.average(location2.getX(), location.getX()), MathMan.average(location2.getY(), location.getY()), MathMan.average(location2.getZ(), location.getZ()));
        this.worldUtil.getHighestBlock(this.getWorldName(), location3.getX(), location3.getZ(), n -> {
            int n2 = n;
            if (this.area.allowSigns()) {
                n2 = Math.max(n, this.getManager().getSignLoc(this).getY());
            }
            consumer.accept(location3.withY(1 + n2));
        });
    }

    @Deprecated
    public Location getCenterSynchronous() {
        Location[] locationArray = this.getCorners();
        Location location = locationArray[0];
        Location location2 = locationArray[1];
        if (!this.isLoaded()) {
            return Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0);
        }
        Location location3 = Location.at(this.getWorldName(), MathMan.average(location2.getX(), location.getX()), MathMan.average(location2.getY(), location.getY()), MathMan.average(location2.getZ(), location.getZ()));
        int n = this.worldUtil.getHighestBlockSynchronous(this.getWorldName(), location3.getX(), location3.getZ());
        if (this.area.allowSigns()) {
            n = Math.max(n, this.getManager().getSignLoc(this).getY());
        }
        return location3.withY(1 + n);
    }

    @Deprecated
    public Location getSideSynchronous() {
        int n;
        CuboidRegion cuboidRegion = this.getLargestRegion();
        int n2 = (cuboidRegion.getMaximumPoint().getX() >> 1) - (cuboidRegion.getMinimumPoint().getX() >> 1) + cuboidRegion.getMinimumPoint().getX();
        int n3 = cuboidRegion.getMinimumPoint().getZ() - 1;
        PlotManager plotManager = this.getManager();
        int n4 = n = this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(this.getWorldName(), n2, n3) : 62;
        if (this.area.allowSigns() && (n <= this.area.getMinGenHeight() || n >= this.area.getMaxGenHeight())) {
            n = Math.max(n, plotManager.getSignLoc(this).getY() - 1);
        }
        return Location.at(this.getWorldName(), n2, n + 1, n3);
    }

    public void getSide(Consumer<Location> consumer) {
        CuboidRegion cuboidRegion = this.getLargestRegion();
        int n = (cuboidRegion.getMaximumPoint().getX() >> 1) - (cuboidRegion.getMinimumPoint().getX() >> 1) + cuboidRegion.getMinimumPoint().getX();
        int n2 = cuboidRegion.getMinimumPoint().getZ() - 1;
        PlotManager plotManager = this.getManager();
        if (this.isLoaded()) {
            this.worldUtil.getHighestBlock(this.getWorldName(), n, n2, n3 -> {
                int n4 = n3;
                if (this.area.allowSigns() && (n3 <= this.area.getMinGenHeight() || n3 >= this.area.getMaxGenHeight())) {
                    n4 = Math.max(n3, plotManager.getSignLoc(this).getY() - 1);
                }
                consumer.accept(Location.at(this.getWorldName(), n, n4 + 1, n2));
            });
        } else {
            int n4 = 62;
            if (this.area.allowSigns()) {
                n4 = Math.max(n4, plotManager.getSignLoc(this).getY() - 1);
            }
            consumer.accept(Location.at(this.getWorldName(), n, n4 + 1, n2));
        }
    }

    @Deprecated
    public Location getHomeSynchronous() {
        BlockLoc blockLoc = this.getPosition();
        if (blockLoc == null || blockLoc.getX() == 0 && blockLoc.getZ() == 0) {
            return this.getDefaultHomeSynchronous(true);
        }
        Location location = this.getBottomAbs();
        if (!this.isLoaded()) {
            return Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0);
        }
        Location location2 = this.toHomeLocation(location, blockLoc);
        if (!this.worldUtil.getBlockSynchronous(location2).getBlockType().getMaterial().isAir()) {
            location2 = location2.withY(Math.max(1 + this.worldUtil.getHighestBlockSynchronous(this.getWorldName(), location2.getX(), location2.getZ()), location.getY()));
        }
        return location2;
    }

    public void getHome(Consumer<Location> consumer) {
        BlockLoc blockLoc = this.getPosition();
        if (blockLoc == null || blockLoc.getX() == 0 && blockLoc.getZ() == 0) {
            this.getDefaultHome(consumer);
        } else {
            if (!this.isLoaded()) {
                consumer.accept(Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0));
                return;
            }
            Location location = this.getBottomAbs();
            Location location2 = this.toHomeLocation(location, blockLoc);
            this.worldUtil.getBlock(location2, blockState -> {
                if (!blockState.getBlockType().getMaterial().isAir()) {
                    this.worldUtil.getHighestBlock(this.getWorldName(), location2.getX(), location2.getZ(), n -> consumer.accept(location2.withY(Math.max(1 + n, location.getY()))));
                } else {
                    consumer.accept(location2);
                }
            });
        }
    }

    private Location toHomeLocation(Location location, BlockLoc blockLoc) {
        return Location.at(location.getWorldName(), location.getX() + blockLoc.getX(), blockLoc.getY(), location.getZ() + blockLoc.getZ(), blockLoc.getYaw(), blockLoc.getPitch());
    }

    public void setHome(BlockLoc blockLoc) {
        Plot plot = this.getBasePlot(false);
        if (BlockLoc.ZERO.equals(blockLoc) || BlockLoc.MINY.equals(blockLoc)) {
            return;
        }
        plot.getSettings().setPosition(blockLoc);
        if (blockLoc != null) {
            DBFunc.setPosition(plot, plot.getSettings().getPosition().toString());
            return;
        }
        DBFunc.setPosition(plot, null);
    }

    public void getDefaultHome(Consumer<Location> consumer) {
        this.getDefaultHome(false, consumer);
    }

    @Deprecated
    public Location getDefaultHomeSynchronous(boolean bl) {
        BlockLoc blockLoc;
        Plot plot = this.getBasePlot(false);
        BlockLoc blockLoc2 = blockLoc = bl ? this.area.defaultHome() : this.area.nonmemberHome();
        if (blockLoc != null) {
            int n;
            int n2;
            if (blockLoc.getX() == Integer.MAX_VALUE && blockLoc.getZ() == Integer.MAX_VALUE) {
                if (this.getArea() instanceof SinglePlotArea) {
                    int n3 = blockLoc.getY() == Integer.MIN_VALUE ? (this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), 0, 0) + 1 : 63) : blockLoc.getY();
                    return Location.at(plot.getWorldName(), 0, n3, 0, 0.0f, 0.0f);
                }
                var6_5 = plot.getLargestRegion();
                n2 = (var6_5.getMaximumPoint().getX() >> 1) - (var6_5.getMinimumPoint().getX() >> 1) + var6_5.getMinimumPoint().getX();
                n = (var6_5.getMaximumPoint().getZ() >> 1) - (var6_5.getMinimumPoint().getZ() >> 1) + var6_5.getMinimumPoint().getZ();
            } else {
                var6_5 = plot.getBottomAbs();
                n2 = var6_5.getX() + blockLoc.getX();
                n = var6_5.getZ() + blockLoc.getZ();
            }
            int n4 = blockLoc.getY() == Integer.MIN_VALUE ? (this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), n2, n) + 1 : 63) : blockLoc.getY();
            return Location.at(plot.getWorldName(), n2, n4, n, blockLoc.getYaw(), blockLoc.getPitch());
        }
        if (this.getArea() instanceof SinglePlotArea) {
            int n = this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), 0, 0) + 1 : 63;
            return Location.at(plot.getWorldName(), 0, n, 0, 0.0f, 0.0f);
        }
        return plot.getSideSynchronous();
    }

    public void getDefaultHome(boolean bl, Consumer<Location> consumer) {
        BlockLoc blockLoc;
        Plot plot = this.getBasePlot(false);
        if (!this.isLoaded()) {
            consumer.accept(Location.at("", 0, this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 4, 0));
            return;
        }
        BlockLoc blockLoc2 = blockLoc = bl ? this.area.defaultHome() : this.area.nonmemberHome();
        if (blockLoc != null) {
            int n;
            int n2;
            if (blockLoc.getX() == Integer.MAX_VALUE && blockLoc.getZ() == Integer.MAX_VALUE) {
                if (this.getArea() instanceof SinglePlotArea) {
                    n2 = 0;
                    n = 0;
                } else {
                    var7_8 = plot.getLargestRegion();
                    n2 = (var7_8.getMaximumPoint().getX() >> 1) - (var7_8.getMinimumPoint().getX() >> 1) + var7_8.getMinimumPoint().getX();
                    n = (var7_8.getMaximumPoint().getZ() >> 1) - (var7_8.getMinimumPoint().getZ() >> 1) + var7_8.getMinimumPoint().getZ();
                }
            } else {
                var7_8 = plot.getBottomAbs();
                n2 = var7_8.getX() + blockLoc.getX();
                n = var7_8.getZ() + blockLoc.getZ();
            }
            if (blockLoc.getY() == Integer.MIN_VALUE) {
                if (this.isLoaded()) {
                    this.worldUtil.getHighestBlock(plot.getWorldName(), n2, n, n3 -> consumer.accept(Location.at(plot.getWorldName(), n2, n3 + 1, n)));
                } else {
                    int n4 = this.getArea() instanceof ClassicPlotWorld ? ((ClassicPlotWorld)this.getArea()).PLOT_HEIGHT + 1 : 63;
                    consumer.accept(Location.at(plot.getWorldName(), n2, n4, n, blockLoc.getYaw(), blockLoc.getPitch()));
                }
            } else {
                consumer.accept(Location.at(plot.getWorldName(), n2, blockLoc.getY(), n, blockLoc.getYaw(), blockLoc.getPitch()));
            }
            return;
        }
        if (this.getArea() instanceof SinglePlotArea) {
            int n = this.isLoaded() ? this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), 0, 0) + 1 : 63;
            consumer.accept(Location.at(plot.getWorldName(), 0, n, 0, 0.0f, 0.0f));
        }
        plot.getSide(consumer);
    }

    public double getVolume() {
        double d = 0.0;
        for (CuboidRegion cuboidRegion : this.getRegions()) {
            d += (double)(cuboidRegion.getLength() * cuboidRegion.getWidth() * (this.area.getMaxGenHeight() - this.area.getMinGenHeight() + 1));
        }
        return d;
    }

    public double getAverageRating() {
        Collection<Rating> collection = this.getRatings().values();
        double d = collection.stream().mapToDouble(Rating::getAverageRating).sum();
        return d / (double)collection.size();
    }

    public boolean addRating(UUID uUID, Rating rating) {
        Plot plot = this.getBasePlot(false);
        PlotSettings plotSettings = plot.getSettings();
        if (plotSettings.getRatings().containsKey(uUID)) {
            return false;
        }
        int n = rating.getAggregate();
        plotSettings.getRatings().put(uUID, n);
        DBFunc.setRating(plot, uUID, n);
        return true;
    }

    public void clearRatings() {
        Plot plot = this.getBasePlot(false);
        PlotSettings plotSettings = plot.getSettings();
        if (plotSettings.getRatings() != null && !plotSettings.getRatings().isEmpty()) {
            DBFunc.deleteRatings(plot);
            plotSettings.setRatings(null);
        }
    }

    public Map<UUID, Boolean> getLikes() {
        HashMap<UUID, Boolean> hashMap = new HashMap<UUID, Boolean>();
        HashMap<UUID, Rating> hashMap2 = this.getRatings();
        hashMap2.forEach((uUID, rating) -> hashMap.put((UUID)uUID, rating.getLike()));
        return hashMap;
    }

    public HashMap<UUID, Rating> getRatings() {
        Plot plot = this.getBasePlot(false);
        HashMap<UUID, Rating> hashMap = new HashMap<UUID, Rating>();
        if (!plot.hasRatings()) {
            return hashMap;
        }
        for (Map.Entry<UUID, Integer> entry : plot.getSettings().getRatings().entrySet()) {
            hashMap.put(entry.getKey(), new Rating(entry.getValue()));
        }
        return hashMap;
    }

    public boolean hasRatings() {
        Plot plot = this.getBasePlot(false);
        return plot.settings != null && plot.settings.getRatings() != null;
    }

    public boolean claim(final @NonNull PlotPlayer<?> plotPlayer, boolean bl2, String string, boolean bl3, boolean bl4) {
        PlotArea plotArea;
        this.eventDispatcher.callPlotClaimedNotify(this, bl4);
        if (bl3) {
            if (!this.getPlotModificationManager().create(plotPlayer.getUUID(), true)) {
                LOGGER.error("Player {} attempted to claim plot {}, but the database failed to update", (Object)plotPlayer.getName(), (Object)this.getId().toCommaSeparatedString());
                return false;
            }
        } else {
            this.area.addPlot(this);
            this.updateWorldBorder();
        }
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("working.claimed"), TagResolver.resolver("plot", Tag.inserting(Component.text(this.getId().toString()))));
        if (bl2) {
            if (!bl4 && Settings.Teleport.ON_CLAIM) {
                this.teleportPlayer(plotPlayer, TeleportCause.COMMAND_CLAIM, bl -> {});
            } else if (bl4 && Settings.Teleport.ON_AUTO) {
                this.teleportPlayer(plotPlayer, TeleportCause.COMMAND_AUTO, bl -> {});
            }
        }
        if ((plotArea = this.getArea()).isSchematicOnClaim()) {
            Schematic schematic;
            try {
                if (string == null || string.isEmpty()) {
                    schematic = this.schematicHandler.getSchematic(plotArea.getSchematicFile());
                } else {
                    schematic = this.schematicHandler.getSchematic(string);
                    if (schematic == null) {
                        schematic = this.schematicHandler.getSchematic(plotArea.getSchematicFile());
                    }
                }
            }
            catch (SchematicHandler.UnsupportedFormatException unsupportedFormatException) {
                unsupportedFormatException.printStackTrace();
                return true;
            }
            this.schematicHandler.paste(schematic, this, 0, this.getArea().getMinBuildHeight(), 0, Settings.Schematics.PASTE_ON_TOP, plotPlayer, new RunnableVal<Boolean>(){

                @Override
                public void run(Boolean bl) {
                    if (bl.booleanValue()) {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_success"), new TagResolver[0]);
                    } else {
                        plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_paste_failed"), new TagResolver[0]);
                    }
                }
            });
        }
        plotArea.getPlotManager().claimPlot(this, null);
        this.getPlotModificationManager().setSign(plotPlayer.getName());
        return true;
    }

    public void getBiome(Consumer<BiomeType> consumer) {
        this.getCenter(location -> this.worldUtil.getBiome(location.getWorldName(), location.getX(), location.getZ(), consumer));
    }

    @Deprecated
    public BiomeType getBiomeSynchronous() {
        Location location = this.getCenterSynchronous();
        return this.worldUtil.getBiomeSynchronous(location.getWorldName(), location.getX(), location.getZ());
    }

    public Location getTopAbs() {
        return this.getManager().getPlotTopLocAbs(this.id).withWorld(this.getWorldName());
    }

    public Location getBottomAbs() {
        return this.getManager().getPlotBottomLocAbs(this.id).withWorld(this.getWorldName());
    }

    public CompletableFuture<Boolean> swapData(Plot plot) {
        if (!this.hasOwner()) {
            if (plot != null && plot.hasOwner()) {
                plot.moveData(this, null);
                return CompletableFuture.completedFuture(true);
            }
            return CompletableFuture.completedFuture(false);
        }
        if (plot == null || plot.getOwner() == null) {
            this.moveData(plot, null);
            return CompletableFuture.completedFuture(true);
        }
        PlotId plotId = PlotId.of(this.getId().getX(), this.getId().getY());
        this.id = plot.getId();
        plot.id = plotId;
        this.area.removePlot(this.getId());
        plot.area.removePlot(plot.getId());
        this.area.addPlotAbs(this);
        plot.area.addPlotAbs(plot);
        return DBFunc.swapPlots(plot, this);
    }

    public boolean moveData(Plot plot, Runnable runnable) {
        if (!this.hasOwner()) {
            TaskManager.runTask(runnable);
            return false;
        }
        if (plot.hasOwner()) {
            TaskManager.runTask(runnable);
            return false;
        }
        this.area.removePlot(this.id);
        this.id = plot.getId();
        this.area.addPlotAbs(this);
        this.clearCache();
        DBFunc.movePlot(this, plot);
        TaskManager.runTaskLater(runnable, TaskTime.ticks(1L));
        return true;
    }

    public Location getExtendedTopAbs() {
        Location location = this.getTopAbs();
        if (!this.isMerged()) {
            return location;
        }
        if (this.isMerged(Direction.SOUTH)) {
            location = location.withZ(this.getRelative(Direction.SOUTH).getBottomAbs().getZ() - 1);
        }
        if (this.isMerged(Direction.EAST)) {
            location = location.withX(this.getRelative(Direction.EAST).getBottomAbs().getX() - 1);
        }
        return location;
    }

    public Location getExtendedBottomAbs() {
        Location location = this.getBottomAbs();
        if (!this.isMerged()) {
            return location;
        }
        if (this.isMerged(Direction.NORTH)) {
            location = location.withZ(this.getRelative(Direction.NORTH).getTopAbs().getZ() + 1);
        }
        if (this.isMerged(Direction.WEST)) {
            location = location.withX(this.getRelative(Direction.WEST).getTopAbs().getX() + 1);
        }
        return location;
    }

    @Deprecated
    public Location[] getCorners() {
        if (!this.isMerged()) {
            return new Location[]{this.getBottomAbs(), this.getTopAbs()};
        }
        return RegionUtil.getCorners(this.getWorldName(), this.getRegions());
    }

    @Deprecated
    public Location getBottom() {
        return this.getCorners()[0];
    }

    @Deprecated
    public Location getTop() {
        return this.getCorners()[1];
    }

    public String toString() {
        if (this.settings != null && this.settings.getAlias().length() > 1) {
            return this.settings.getAlias();
        }
        return this.area + ";" + this.id;
    }

    public boolean removeDenied(UUID uUID) {
        if (uUID == DBFunc.EVERYONE && !this.denied.contains(uUID)) {
            boolean bl = false;
            for (UUID uUID2 : new HashSet<UUID>(this.getDenied())) {
                bl = this.rmvDenied(uUID2) || bl;
            }
            return bl;
        }
        return this.rmvDenied(uUID);
    }

    private boolean rmvDenied(UUID uUID) {
        for (Plot plot : this.getConnectedPlots()) {
            if (plot.getDenied().remove(uUID)) {
                DBFunc.removeDenied(plot, uUID);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean removeTrusted(UUID uUID) {
        if (uUID == DBFunc.EVERYONE && !this.trusted.contains(uUID)) {
            boolean bl = false;
            for (UUID uUID2 : new HashSet<UUID>(this.getTrusted())) {
                bl = this.rmvTrusted(uUID2) || bl;
            }
            return bl;
        }
        return this.rmvTrusted(uUID);
    }

    private boolean rmvTrusted(UUID uUID) {
        for (Plot plot : this.getConnectedPlots()) {
            if (plot.getTrusted().remove(uUID)) {
                DBFunc.removeTrusted(plot, uUID);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean removeMember(UUID uUID) {
        if (this.members == null) {
            return false;
        }
        if (uUID == DBFunc.EVERYONE && !this.members.contains(uUID)) {
            boolean bl = false;
            for (UUID uUID2 : new HashSet<UUID>(this.members)) {
                bl = this.rmvMember(uUID2) || bl;
            }
            return bl;
        }
        return this.rmvMember(uUID);
    }

    private boolean rmvMember(UUID uUID) {
        for (Plot plot : this.getConnectedPlots()) {
            if (plot.getMembers().remove(uUID)) {
                DBFunc.removeMember(plot, uUID);
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Plot plot = (Plot)object;
        return this.hashCode() == plot.hashCode() && this.id.equals(plot.id) && this.area == plot.area;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public @NonNull String getAlias() {
        if (this.settings == null) {
            return "";
        }
        return this.settings.getAlias();
    }

    public void setAlias(String string) {
        for (Plot plot : this.getConnectedPlots()) {
            String string2 = this.getSettings().getAlias();
            if (string == null) {
                string = "";
            }
            if (string2.equals(string)) {
                return;
            }
            plot.getSettings().setAlias(string);
            DBFunc.setAlias(plot, string);
        }
    }

    public void setMerged(Direction direction, boolean bl) {
        if (this.getSettings().setMerged(direction, bl)) {
            if (bl) {
                Plot plot = this.getRelative(direction).getBasePlot(false);
                if (!plot.equals(this.getBasePlot(false))) {
                    Plot plot2;
                    this.origin.origin = plot2 = plot.id.getY() < this.id.getY() || plot.id.getY() == this.id.getY() && plot.id.getX() < this.id.getX() ? plot : this.origin;
                    plot.origin = plot2;
                    this.origin = plot2;
                    this.connectedCache = null;
                }
            } else {
                if (this.origin != null) {
                    this.origin.origin = null;
                    this.origin = null;
                }
                this.connectedCache = null;
            }
            DBFunc.setMerged(this, this.getSettings().getMerged());
        }
    }

    public boolean[] getMerged() {
        return this.getSettings().getMerged();
    }

    public void setMerged(boolean[] blArray) {
        this.getSettings().setMerged(blArray);
        DBFunc.setMerged(this, blArray);
        this.clearCache();
    }

    public void clearCache() {
        this.connectedCache = null;
        if (this.origin != null) {
            this.origin.origin = null;
            this.origin = null;
        }
    }

    public BlockLoc getPosition() {
        return this.getSettings().getPosition();
    }

    public boolean canClaim(@NonNull PlotPlayer<?> plotPlayer) {
        PlotCluster plotCluster = this.getCluster();
        if (plotCluster != null && !plotCluster.isAdded(plotPlayer.getUUID()) && !plotPlayer.hasPermission("plots.admin.command.claim")) {
            return false;
        }
        UUID uUID = this.getOwnerAbs();
        if (uUID != null) {
            return false;
        }
        return !this.isMerged();
    }

    public void mergeData(Plot plot) {
        FlagContainer flagContainer;
        FlagContainer flagContainer2 = this.getFlagContainer();
        if (!flagContainer2.equals(flagContainer = plot.getFlagContainer())) {
            boolean bl;
            boolean bl2 = bl = flagContainer2.getFlagMap().size() > flagContainer.getFlagMap().size();
            if (bl) {
                flagContainer2.addAll(flagContainer.getFlagMap().values());
            } else {
                flagContainer.addAll(flagContainer2.getFlagMap().values());
            }
            if (!bl) {
                this.flagContainer.clearLocal();
                this.flagContainer.addAll(flagContainer.getFlagMap().values());
            }
            plot.flagContainer.clearLocal();
            plot.flagContainer.addAll(this.flagContainer.getFlagMap().values());
        }
        if (!this.getAlias().isEmpty()) {
            plot.setAlias(this.getAlias());
        } else if (!plot.getAlias().isEmpty()) {
            this.setAlias(plot.getAlias());
        }
        for (UUID uUID : this.getTrusted()) {
            plot.addTrusted(uUID);
        }
        for (UUID uUID : plot.getTrusted()) {
            this.addTrusted(uUID);
        }
        for (UUID uUID : this.getMembers()) {
            plot.addMember(uUID);
        }
        for (UUID uUID : plot.getMembers()) {
            this.addMember(uUID);
        }
        for (UUID uUID : this.getDenied()) {
            plot.addDenied(uUID);
        }
        for (UUID uUID : plot.getDenied()) {
            this.addDenied(uUID);
        }
    }

    public Plot getRelative(int n, int n2) {
        return this.area.getPlotAbs(PlotId.of(this.id.getX() + n, this.id.getY() + n2));
    }

    public Plot getRelative(PlotArea plotArea, int n, int n2) {
        return plotArea.getPlotAbs(PlotId.of(this.id.getX() + n, this.id.getY() + n2));
    }

    public @Nullable Plot getRelative(@NonNull Direction direction) {
        return this.area.getPlotAbs(this.id.getRelative(direction));
    }

    public Set<Plot> getConnectedPlots() {
        Plot plot;
        if (this.settings == null) {
            return Collections.singleton(this);
        }
        if (!this.isMerged()) {
            return Collections.singleton(this);
        }
        Plot plot2 = this.getBasePlot(false);
        if (this.connectedCache == null && this != plot2) {
            Set<Plot> set = plot2.getConnectedPlots();
            this.connectedCache = set;
            return set;
        }
        if (this.connectedCache != null && this.connectedCache.contains(this)) {
            return this.connectedCache;
        }
        HashSet<Plot> hashSet = new HashSet<Plot>();
        hashSet.add(this);
        HashSet<Plot> hashSet2 = new HashSet<Plot>();
        ArrayDeque<Plot> arrayDeque = new ArrayDeque<Plot>();
        this.computeDirectMerged(hashSet2, arrayDeque, Direction.NORTH);
        this.computeDirectMerged(hashSet2, arrayDeque, Direction.EAST);
        this.computeDirectMerged(hashSet2, arrayDeque, Direction.SOUTH);
        this.computeDirectMerged(hashSet2, arrayDeque, Direction.WEST);
        while ((plot = arrayDeque.poll()) != null) {
            if (!plot.hasOwner() || plot.settings == null) continue;
            hashSet.add(plot);
            hashSet2.remove(plot);
            this.addIfIncluded(plot, Direction.NORTH, hashSet2, hashSet, arrayDeque);
            this.addIfIncluded(plot, Direction.EAST, hashSet2, hashSet, arrayDeque);
            this.addIfIncluded(plot, Direction.SOUTH, hashSet2, hashSet, arrayDeque);
            this.addIfIncluded(plot, Direction.WEST, hashSet2, hashSet, arrayDeque);
        }
        hashSet = Set.copyOf(hashSet);
        this.connectedCache = hashSet;
        return hashSet;
    }

    private void computeDirectMerged(Set<Plot> set, Deque<Plot> deque, Direction direction) {
        if (this.isMerged(direction)) {
            Plot plot = this.area.getPlotAbs(this.id.getRelative(direction));
            assert (plot != null);
            if (!plot.isMerged(direction.opposite())) {
                if (plot.isOwnerAbs(this.getOwnerAbs())) {
                    plot.getSettings().setMerged(direction.opposite(), true);
                    DBFunc.setMerged(plot, plot.getSettings().getMerged());
                } else {
                    this.getSettings().setMerged(direction, false);
                    DBFunc.setMerged(this, this.getSettings().getMerged());
                }
            }
            set.add(plot);
            deque.add(plot);
        }
    }

    private void addIfIncluded(Plot plot, Direction direction, Set<Plot> set, Set<Plot> set2, Deque<Plot> deque) {
        if (!plot.isMerged(direction)) {
            return;
        }
        Plot plot2 = plot.area.getPlotAbs(plot.id.getRelative(direction));
        if (plot2 != null && !set.contains(plot2) && !set2.contains(plot2)) {
            set.add(plot2);
            deque.add(plot2);
        }
    }

    public @NonNull Set<CuboidRegion> getRegions() {
        if (!this.isMerged()) {
            Location location = this.getBottomAbs().withY(this.getArea().getMinBuildHeight());
            Location location2 = this.getTopAbs().withY(this.getArea().getMaxBuildHeight());
            CuboidRegion cuboidRegion = new CuboidRegion(location.getBlockVector3(), location2.getBlockVector3());
            return Collections.singleton(cuboidRegion);
        }
        Set<Plot> set = this.getConnectedPlots();
        HashSet<CuboidRegion> hashSet = new HashSet<CuboidRegion>();
        HashSet hashSet2 = new HashSet();
        for (Plot plot : set) {
            BlockVector3 blockVector3;
            BlockVector3 blockVector32;
            Location location;
            Location location3;
            Location location4;
            Plot plot2;
            int n;
            Plot plot3;
            Object object2;
            int n2;
            if (hashSet2.contains(plot.getId())) continue;
            boolean bl = true;
            PlotId plotId = plot.getId();
            PlotId plotId2 = plot.getId();
            while (bl) {
                bl = false;
                PlotId.PlotRangeIterator plotRangeIterator = PlotId.PlotRangeIterator.range(PlotId.of(plotId.getX(), plotId.getY() - 1), PlotId.of(plotId2.getX(), plotId.getY() - 1));
                n2 = 1;
                for (Object object2 : plotRangeIterator) {
                    plot3 = this.area.getPlotAbs((PlotId)object2);
                    if (plot3 != null && plot3.isMerged(Direction.SOUTH) && !hashSet2.contains(plot3.getId())) continue;
                    n2 = 0;
                }
                if (n2 != 0) {
                    bl = true;
                    plotId = PlotId.of(plotId.getX(), plotId.getY() - 1);
                }
                plotRangeIterator = PlotId.PlotRangeIterator.range(PlotId.of(plotId2.getX() + 1, plotId.getY()), PlotId.of(plotId2.getX() + 1, plotId2.getY()));
                n2 = 1;
                for (Object object2 : plotRangeIterator) {
                    plot3 = this.area.getPlotAbs((PlotId)object2);
                    if (plot3 != null && plot3.isMerged(Direction.WEST) && !hashSet2.contains(plot3.getId())) continue;
                    n2 = 0;
                }
                if (n2 != 0) {
                    bl = true;
                    plotId2 = PlotId.of(plotId2.getX() + 1, plotId2.getY());
                }
                plotRangeIterator = PlotId.PlotRangeIterator.range(PlotId.of(plotId.getX(), plotId2.getY() + 1), PlotId.of(plotId2.getX(), plotId2.getY() + 1));
                n2 = 1;
                for (Object object2 : plotRangeIterator) {
                    plot3 = this.area.getPlotAbs((PlotId)object2);
                    if (plot3 != null && plot3.isMerged(Direction.NORTH) && !hashSet2.contains(plot3.getId())) continue;
                    n2 = 0;
                }
                if (n2 != 0) {
                    bl = true;
                    plotId2 = PlotId.of(plotId2.getX(), plotId2.getY() + 1);
                }
                plotRangeIterator = PlotId.PlotRangeIterator.range(PlotId.of(plotId.getX() - 1, plotId.getY()), PlotId.of(plotId.getX() - 1, plotId2.getY()));
                n2 = 1;
                for (Object object2 : plotRangeIterator) {
                    plot3 = this.area.getPlotAbs((PlotId)object2);
                    if (plot3 != null && plot3.isMerged(Direction.EAST) && !hashSet2.contains(plot3.getId())) continue;
                    n2 = 0;
                }
                if (n2 == 0) continue;
                bl = true;
                plotId = PlotId.of(plotId.getX() - 1, plotId.getY());
            }
            int n3 = this.getArea().getMinBuildHeight();
            n2 = this.getArea().getMaxBuildHeight() - 1;
            Iterator iterator = this.area.getPlotAbs(plotId2).getTopAbs();
            object2 = this.area.getPlotAbs(plotId).getBottomAbs();
            hashSet2.addAll(Lists.newArrayList((Iterable)PlotId.PlotRangeIterator.range(plotId, plotId2)));
            for (n = plotId.getX(); n <= plotId2.getX(); ++n) {
                plot2 = this.area.getPlotAbs(PlotId.of(n, plotId2.getY()));
                if (!plot2.isMerged(Direction.SOUTH)) continue;
                location4 = plot2.getExtendedTopAbs();
                location3 = plot2.getBottomAbs();
                location = plot2.getTopAbs();
                blockVector32 = BlockVector3.at((int)location3.getX(), (int)n3, (int)(location.getZ() + 1));
                blockVector3 = BlockVector3.at((int)location.getX(), (int)n2, (int)location4.getZ());
                hashSet.add(new CuboidRegion(blockVector32, blockVector3));
                if (!plot2.isMerged(Direction.SOUTHEAST)) continue;
                blockVector32 = BlockVector3.at((int)(location.getX() + 1), (int)n3, (int)(location.getZ() + 1));
                blockVector3 = BlockVector3.at((int)location4.getX(), (int)n2, (int)location4.getZ());
                hashSet.add(new CuboidRegion(blockVector32, blockVector3));
            }
            for (n = plotId.getY(); n <= plotId2.getY(); ++n) {
                plot2 = this.area.getPlotAbs(PlotId.of(plotId2.getX(), n));
                if (!plot2.isMerged(Direction.EAST)) continue;
                location4 = plot2.getExtendedTopAbs();
                location3 = plot2.getBottomAbs();
                location = plot2.getTopAbs();
                blockVector32 = BlockVector3.at((int)(location.getX() + 1), (int)n3, (int)location3.getZ());
                blockVector3 = BlockVector3.at((int)location4.getX(), (int)n2, (int)location.getZ());
                hashSet.add(new CuboidRegion(blockVector32, blockVector3));
                if (!plot2.isMerged(Direction.SOUTHEAST)) continue;
                blockVector32 = BlockVector3.at((int)(location.getX() + 1), (int)n3, (int)(location.getZ() + 1));
                blockVector3 = BlockVector3.at((int)location4.getX(), (int)n2, (int)location4.getZ());
                hashSet.add(new CuboidRegion(blockVector32, blockVector3));
            }
            plot3 = BlockVector3.at((int)((Location)object2).getX(), (int)n3, (int)((Location)object2).getZ());
            plot2 = BlockVector3.at((int)((Location)((Object)iterator)).getX(), (int)n2, (int)((Location)((Object)iterator)).getZ());
            hashSet.add(new CuboidRegion((BlockVector3)plot3, (BlockVector3)plot2));
        }
        return hashSet;
    }

    public CuboidRegion getLargestRegion() {
        Set<CuboidRegion> set = this.getRegions();
        CuboidRegion cuboidRegion = null;
        double d = Double.NEGATIVE_INFINITY;
        for (CuboidRegion cuboidRegion2 : set) {
            double d2 = ((double)cuboidRegion2.getMaximumPoint().getX() - (double)cuboidRegion2.getMinimumPoint().getX() + 1.0) * ((double)cuboidRegion2.getMaximumPoint().getZ() - (double)cuboidRegion2.getMinimumPoint().getZ() + 1.0);
            if (!(d2 > d)) continue;
            cuboidRegion = cuboidRegion2;
            d = d2;
        }
        return cuboidRegion;
    }

    public void reEnter() {
        TaskManager.runTaskLater(() -> {
            for (PlotPlayer<?> plotPlayer : this.getPlayersInPlot()) {
                this.plotListener.plotExit(plotPlayer, this);
                this.plotListener.plotEntry(plotPlayer, this);
            }
        }, TaskTime.ticks(1L));
    }

    public void debug(@NonNull String string) {
        try {
            Collection<PlotPlayer<?>> collection = PlotPlayer.getDebugModePlayersInPlot(this);
            if (collection.isEmpty()) {
                return;
            }
            TranslatableCaption translatableCaption = TranslatableCaption.of("debug.plot_debug");
            TagResolver tagResolver = TagResolver.builder().tag("plot", Tag.inserting(Component.text(this.toString()))).tag("message", Tag.inserting(Component.text(string))).build();
            for (PlotPlayer<?> plotPlayer : collection) {
                if (!this.isOwner(plotPlayer.getUUID()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_DEBUG_OTHER)) continue;
                plotPlayer.sendMessage((Caption)translatableCaption, tagResolver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void teleportPlayer(PlotPlayer<?> plotPlayer, Consumer<Boolean> consumer) {
        this.teleportPlayer(plotPlayer, TeleportCause.PLUGIN, consumer);
    }

    public void teleportPlayer(PlotPlayer<?> plotPlayer, TeleportCause teleportCause, Consumer<Boolean> consumer) {
        Plot plot = this.getBasePlot(false);
        Result result = this.eventDispatcher.callTeleport(plotPlayer, plotPlayer.getLocation(), plot, teleportCause).getEventResult();
        if (result == Result.DENY) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Teleport"))));
            consumer.accept(false);
            return;
        }
        Consumer<Location> consumer2 = location -> {
            if (Settings.Teleport.DELAY == 0 || plotPlayer.hasPermission("plots.teleport.delay.bypass")) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                plotPlayer.teleport((Location)location, teleportCause);
                consumer.accept(true);
                return;
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("teleport.teleport_in_seconds"), TagResolver.resolver("amount", Tag.inserting(Component.text(Settings.Teleport.DELAY))));
            String string = plotPlayer.getName();
            TaskManager.addToTeleportQueue(string);
            TaskManager.runTaskLater(() -> {
                if (!TaskManager.removeFromTeleportQueue(string)) {
                    return;
                }
                try {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_plot"), new TagResolver[0]);
                    plotPlayer.teleport((Location)location, teleportCause);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, TaskTime.seconds(Settings.Teleport.DELAY));
            consumer.accept(true);
        };
        if (this.area.isHomeAllowNonmember() || plot.isAdded(plotPlayer.getUUID())) {
            this.getHome(consumer2);
        } else {
            this.getDefaultHome(false, consumer2);
        }
    }

    public boolean isOnline() {
        if (!this.hasOwner()) {
            return false;
        }
        if (!this.isMerged()) {
            return PlotSquared.platform().playerManager().getPlayerIfExists(Objects.requireNonNull(this.getOwnerAbs())) != null;
        }
        for (Plot plot : this.getConnectedPlots()) {
            if (!plot.hasOwner() || PlotSquared.platform().playerManager().getPlayerIfExists(Objects.requireNonNull(plot.getOwnerAbs())) == null) continue;
            return true;
        }
        return false;
    }

    public int getDistanceFromOrigin() {
        Location location = this.getManager().getPlotBottomLocAbs(this.id);
        Location location2 = this.getManager().getPlotTopLocAbs(this.id);
        return Math.max(Math.max(Math.abs(location.getX()), Math.abs(location.getZ())), Math.max(Math.abs(location2.getX()), Math.abs(location2.getZ())));
    }

    public void updateWorldBorder() {
        int n = this.area.getBorder(false);
        if (n == Integer.MAX_VALUE) {
            return;
        }
        int n2 = this.getDistanceFromOrigin();
        if (n2 > n) {
            this.area.setMeta("worldBorder", n2);
        }
    }

    public void mergePlot(Plot plot, boolean bl, @Nullable QueueCoordinator queueCoordinator) {
        Plot plot2 = this;
        plot.getPlotModificationManager().removeSign();
        if (plot.getId().getX() == plot2.getId().getX()) {
            Plot plot3;
            if (plot.getId().getY() > plot2.getId().getY()) {
                plot3 = plot;
                plot = plot2;
                plot2 = plot3;
            }
            if (!plot.isMerged(Direction.SOUTH)) {
                plot.clearRatings();
                plot2.clearRatings();
                plot.setMerged(Direction.SOUTH, true);
                plot2.setMerged(Direction.NORTH, true);
                plot.mergeData(plot2);
                if (bl) {
                    Plot plot4;
                    plot.getPlotModificationManager().removeRoadSouth(queueCoordinator);
                    plot3 = plot2.getRelative(Direction.EAST);
                    if (plot3.isMerged(Direction.NORTHWEST)) {
                        plot.plotModificationManager.removeRoadSouthEast(queueCoordinator);
                    }
                    if ((plot4 = plot2.getRelative(Direction.WEST)).isMerged(Direction.NORTHEAST)) {
                        plot4.getRelative((Direction)Direction.NORTH).plotModificationManager.removeRoadSouthEast(queueCoordinator);
                    }
                }
            }
        } else {
            Plot plot5;
            if (plot.getId().getX() > plot2.getId().getX()) {
                plot5 = plot;
                plot = plot2;
                plot2 = plot5;
            }
            if (!plot.isMerged(Direction.EAST)) {
                plot.clearRatings();
                plot2.clearRatings();
                plot.setMerged(Direction.EAST, true);
                plot2.setMerged(Direction.WEST, true);
                plot.mergeData(plot2);
                if (bl) {
                    plot5 = plot2.getRelative(Direction.SOUTH);
                    if (plot5.isMerged(Direction.NORTHWEST)) {
                        plot.plotModificationManager.removeRoadSouthEast(queueCoordinator);
                    }
                    plot.plotModificationManager.removeRoadEast(queueCoordinator);
                }
                if ((plot5 = plot2.getRelative(Direction.NORTH)).isMerged(Direction.SOUTHWEST)) {
                    plot5.getRelative(Direction.WEST).getPlotModificationManager().removeRoadSouthEast(queueCoordinator);
                }
            }
        }
    }

    public boolean isMerged(@NonNull Direction direction) {
        return this.isMerged(direction.getIndex());
    }

    public <T> @NonNull T getFlag(@NonNull Class<? extends PlotFlag<T, ?>> clazz) {
        return this.flagContainer.getFlag(clazz).getValue();
    }

    public <T, V extends PlotFlag<T, ?>> @NonNull T getFlag(@NonNull V v) {
        Class<?> clazz = v.getClass();
        PlotFlag<?, ?> plotFlag = this.flagContainer.getFlagErased(clazz);
        return ((PlotFlag)FlagContainer.castUnsafe(plotFlag)).getValue();
    }

    public CompletableFuture<Caption> format(Caption caption, PlotPlayer<?> plotPlayer, boolean bl) {
        CompletableFuture<Caption> completableFuture = new CompletableFuture<Caption>();
        int n = this.getConnectedPlots().size();
        Component component = !this.getAlias().isEmpty() ? Component.text(this.getAlias()) : TranslatableCaption.of("info.none").toComponent(plotPlayer);
        Location location = this.getCorners()[0];
        PlotSquared.platform().worldUtil().getBiome(Objects.requireNonNull(this.getWorldName()), location.getX(), location.getZ(), biomeType -> {
            PlotFlag<?, ?> plotFlag2;
            Object object;
            Object object2;
            Collection<PlotFlag<?, ?>> collection;
            int n2;
            Component component = PlayerManager.getPlayerList(this.getTrusted(), plotPlayer);
            Component component2 = PlayerManager.getPlayerList(this.getMembers(), plotPlayer);
            Component component3 = PlayerManager.getPlayerList(this.getDenied(), plotPlayer);
            ExpireManager expireManager = PlotSquared.platform().expireManager();
            Component component4 = Settings.Enabled_Components.PLOT_EXPIRY && expireManager != null ? (this.isOnline() ? TranslatableCaption.of("info.now").toComponent(plotPlayer) : ((n2 = (int)(PlotSquared.platform().expireManager().getAge(this, false) / 1000L)) != 0 ? Component.text(TimeUtil.secToTime(n2)) : TranslatableCaption.of("info.unknown").toComponent(plotPlayer))) : TranslatableCaption.of("info.never").toComponent(plotPlayer);
            Component component5 = TranslatableCaption.of("info.plot_no_description").toComponent(plotPlayer);
            String string = (String)this.getFlag((PlotFlag)((Object)DescriptionFlag.class));
            if (!string.isEmpty()) {
                component5 = Component.text(string);
            }
            if ((collection = this.getApplicableFlags(true)).isEmpty()) {
                object2 = TranslatableCaption.of("info.none").toComponent(plotPlayer);
            } else {
                TextComponent.Builder builder = Component.text();
                object = "";
                for (PlotFlag<?, ?> plotFlag2 : collection) {
                    String string2 = plotFlag2 instanceof DoubleFlag && !Settings.General.SCIENTIFIC ? FLAG_DECIMAL_FORMAT.format(plotFlag2.getValue()) : plotFlag2.toString();
                    Component component6 = MINI_MESSAGE.deserialize((String)object + CaptionUtility.format(plotPlayer, TranslatableCaption.of("info.plot_flag_list").getComponent(plotPlayer)), TagResolver.builder().tag("flag", Tag.inserting(Component.text(plotFlag2.getName()))).tag("value", Tag.inserting(Component.text(CaptionUtility.formatRaw(plotPlayer, string2.toString())))).build());
                    builder.append(component6);
                    object = ", ";
                }
                object2 = builder.build();
            }
            boolean bl2 = this.isAdded(plotPlayer.getUUID());
            object = this.getOwner() == null ? Component.text("unowned") : (this.getOwner().equals(DBFunc.SERVER) ? Component.text(MINI_MESSAGE.stripTags(TranslatableCaption.of("info.server").getComponent(plotPlayer))) : PlayerManager.getPlayerList(this.getOwners(), plotPlayer));
            TagResolver.Builder builder = TagResolver.builder();
            builder.tag("header", Tag.inserting(TranslatableCaption.of("info.plot_info_header").toComponent(plotPlayer)));
            builder.tag("footer", Tag.inserting(TranslatableCaption.of("info.plot_info_footer").toComponent(plotPlayer)));
            plotFlag2 = Component.text();
            if (this.getArea() != null) {
                plotFlag2.append(Component.text(this.getArea().getWorldName()));
                if (this.getArea().getId() != null) {
                    ((TextComponent.Builder)((TextComponent.Builder)plotFlag2.append(Component.text("("))).append((Component)Component.text(this.getArea().getId()))).append((Component)Component.text(")"));
                }
            } else {
                plotFlag2.append(TranslatableCaption.of("info.none").toComponent(plotPlayer));
            }
            builder.tag("area", Tag.inserting((ComponentLike)((Object)plotFlag2)));
            long l = Long.parseLong(String.valueOf(this.timestamp));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Settings.Timeformat.DATE_FORMAT);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(Settings.Timeformat.TIME_ZONE));
            String string3 = simpleDateFormat.format(l);
            builder.tag("id", Tag.inserting(Component.text(this.getId().toString())));
            builder.tag("alias", Tag.inserting(component));
            builder.tag("num", Tag.inserting(Component.text(n)));
            builder.tag("desc", Tag.inserting((ComponentLike)component5));
            builder.tag("biome", Tag.inserting(Component.text(biomeType.toString().toLowerCase())));
            builder.tag("owner", Tag.inserting((Component)object));
            builder.tag("members", Tag.inserting((ComponentLike)component2));
            builder.tag("player", Tag.inserting(Component.text(plotPlayer.getName())));
            builder.tag("trusted", Tag.inserting((ComponentLike)component));
            builder.tag("denied", Tag.inserting((ComponentLike)component3));
            builder.tag("seen", Tag.inserting((ComponentLike)component4));
            builder.tag("flags", Tag.inserting((ComponentLike)object2));
            builder.tag("creationdate", Tag.inserting(Component.text(string3)));
            builder.tag("build", Tag.inserting(Component.text(bl2)));
            builder.tag("size", Tag.inserting(Component.text(this.getConnectedPlots().size())));
            String string4 = caption.getComponent(plotPlayer);
            if (string4.contains("<rating>") || string4.contains("<likes>")) {
                TaskManager.runTaskAsync(() -> {
                    if (Settings.Ratings.USE_LIKES) {
                        builder.tag("rating", Tag.inserting(Component.text(String.format("%.0f%%", Like.getLikesPercentage(this) * 100.0))));
                        builder.tag("likes", Tag.inserting(Component.text(String.format("%.0f%%", Like.getLikesPercentage(this) * 100.0))));
                    } else {
                        int n = 10;
                        if (Settings.Ratings.CATEGORIES != null && !Settings.Ratings.CATEGORIES.isEmpty()) {
                            n = 8;
                        }
                        if (bl && Settings.Ratings.CATEGORIES != null && Settings.Ratings.CATEGORIES.size() > 1) {
                            double[] dArray = this.getAverageRatings();
                            StringBuilder stringBuilder = new StringBuilder();
                            String string = "";
                            for (int i = 0; i < dArray.length; ++i) {
                                stringBuilder.append(string).append(Settings.Ratings.CATEGORIES.get(i)).append('=').append(String.format("%.1f", dArray[i]));
                                string = ",";
                            }
                            builder.tag("rating", Tag.inserting(Component.text(stringBuilder.toString())));
                        } else {
                            double d = this.getAverageRating();
                            if (Double.isFinite(d)) {
                                builder.tag("rating", Tag.inserting(Component.text(String.format("%.1f", d) + "/" + n)));
                            } else {
                                builder.tag("rating", Tag.inserting(TranslatableCaption.of("info.none").toComponent(plotPlayer)));
                            }
                        }
                        builder.tag("likes", Tag.inserting(Component.text("N/A")));
                    }
                    completableFuture.complete(StaticCaption.of((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(caption.getComponent(plotPlayer), builder.build()))));
                });
                return;
            }
            completableFuture.complete(StaticCaption.of((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize(caption.getComponent(plotPlayer), builder.build()))));
        });
        return completableFuture;
    }

    public @NonNull double[] getAverageRatings() {
        Map<UUID, Integer> map = this.getSettings().getRatings() != null ? this.getSettings().getRatings() : (Settings.Enabled_Components.RATING_CACHE ? new HashMap<UUID, Integer>() : DBFunc.getRatings(this));
        int n = 1;
        if (!Settings.Ratings.CATEGORIES.isEmpty()) {
            n = Math.max(1, Settings.Ratings.CATEGORIES.size());
        }
        double[] dArray = new double[n];
        if (map == null || map.isEmpty()) {
            return dArray;
        }
        for (Map.Entry<UUID, Integer> entry : map.entrySet()) {
            int n2 = entry.getValue();
            if (Settings.Ratings.CATEGORIES.isEmpty()) {
                dArray[0] = dArray[0] + (double)n2;
                continue;
            }
            int n3 = 0;
            while (n3 < Settings.Ratings.CATEGORIES.size()) {
                int n4 = n3++;
                dArray[n4] = dArray[n4] + (double)(n2 % 10 - 1);
                n2 /= 10;
            }
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = n5++;
            dArray[n6] = dArray[n6] / (double)map.size();
        }
        return dArray;
    }

    public @NonNull FlagContainer getFlagContainer() {
        return this.flagContainer;
    }

    public @NonNull PlotCommentContainer getPlotCommentContainer() {
        return this.plotCommentContainer;
    }

    public @NonNull PlotModificationManager getPlotModificationManager() {
        return this.plotModificationManager;
    }

    static {
        FLAG_DECIMAL_FORMAT.setMaximumFractionDigits(340);
    }
}

