/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.util.RegionUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PlotCluster {
    public PlotArea area;
    public PlotSettings settings;
    public UUID owner;
    public HashSet<UUID> helpers = new HashSet();
    public HashSet<UUID> invited = new HashSet();
    public int temp;
    private PlotId pos1;
    private PlotId pos2;
    private CuboidRegion region;

    public PlotCluster(PlotArea plotArea, PlotId plotId, PlotId plotId2, UUID uUID) {
        this.area = plotArea;
        this.pos1 = plotId;
        this.pos2 = plotId2;
        this.owner = uUID;
        this.settings = new PlotSettings();
        this.temp = -1;
        this.setRegion();
    }

    public PlotCluster(PlotArea plotArea, PlotId plotId, PlotId plotId2, UUID uUID, int n) {
        this.area = plotArea;
        this.pos1 = plotId;
        this.pos2 = plotId2;
        this.owner = uUID;
        this.settings = new PlotSettings();
        this.temp = n;
        this.setRegion();
    }

    public PlotId getP1() {
        return this.pos1;
    }

    public void setP1(PlotId plotId) {
        this.pos1 = plotId;
        this.setRegion();
    }

    public PlotId getP2() {
        return this.pos2;
    }

    public void setP2(PlotId plotId) {
        this.pos2 = plotId;
        this.setRegion();
    }

    private void setRegion() {
        this.region = RegionUtil.createRegion(this.pos1.getX(), this.pos2.getX(), 0, 0, this.pos1.getY(), this.pos2.getY());
    }

    @Deprecated
    public CuboidRegion getRegion() {
        return this.region;
    }

    public boolean isOwner(UUID uUID) {
        return uUID.equals(this.owner);
    }

    public boolean isAdded(UUID uUID) {
        return this.owner.equals(uUID) || this.invited.contains(uUID) || this.invited.contains(DBFunc.EVERYONE) || this.helpers.contains(uUID) || this.helpers.contains(DBFunc.EVERYONE);
    }

    public boolean hasHelperRights(UUID uUID) {
        return this.owner.equals(uUID) || this.helpers.contains(uUID) || this.helpers.contains(DBFunc.EVERYONE);
    }

    public String getName() {
        return this.settings.getAlias();
    }

    public int getArea() {
        return (1 + this.pos2.getX() - this.pos1.getX()) * (1 + this.pos2.getY() - this.pos1.getY());
    }

    public void setArea(PlotArea plotArea) {
        if (this.area != null) {
            this.area.removeCluster(this);
        }
        this.area = plotArea;
        plotArea.addCluster(this);
    }

    public int hashCode() {
        return this.pos1.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlotCluster plotCluster = (PlotCluster)object;
        return this.pos1.equals(plotCluster.pos1) && this.pos2.equals(plotCluster.pos2) && this.area.equals(plotCluster.area);
    }

    public String toString() {
        return this.area + ";" + this.pos1.toString() + ";" + this.pos2.toString();
    }

    public void getHome(@NonNull Consumer<Location> consumer) {
        BlockLoc blockLoc = this.settings.getPosition();
        Consumer<Location> consumer2 = location -> PlotSquared.platform().worldUtil().getHighestBlock(this.area.getWorldName(), location.getX(), location.getZ(), n -> {
            if (n <= this.area.getMinBuildHeight()) {
                n = 63;
            }
            if (n > location.getY()) {
                consumer.accept(location.withY(1 + n));
            } else {
                consumer.accept((Location)location);
            }
        });
        if (blockLoc.getY() == Integer.MIN_VALUE) {
            Plot plot = this.getCenterPlot();
            plot.getHome(location -> {
                Location location2 = location;
                if (location2.getY() <= this.area.getMinBuildHeight()) {
                    PlotManager plotManager = this.area.getPlotManager();
                    Location location3 = plotManager.getSignLoc(plot);
                    location2 = location2.withY(location3.getY());
                }
                consumer2.accept(location2);
            });
        } else {
            consumer2.accept(this.getClusterBottom().add(blockLoc.getX(), blockLoc.getY(), blockLoc.getZ()));
        }
    }

    public @NonNull PlotId getCenterPlotId() {
        PlotId plotId = this.getP1();
        PlotId plotId2 = this.getP2();
        return PlotId.of((plotId.getX() + plotId2.getX()) / 2, (plotId.getY() + plotId2.getY()) / 2);
    }

    public @Nullable Plot getCenterPlot() {
        return this.area.getPlotAbs(this.getCenterPlotId());
    }

    public Location getClusterBottom() {
        PlotManager plotManager = this.area.getPlotManager();
        return plotManager.getPlotBottomLocAbs(this.getP1());
    }

    public Location getClusterTop() {
        PlotManager plotManager = this.area.getPlotManager();
        return plotManager.getPlotTopLocAbs(this.getP2());
    }

    public boolean intersects(PlotId plotId, PlotId plotId2) {
        return plotId.getX() <= this.pos2.getX() && plotId2.getX() >= this.pos1.getX() && plotId.getY() <= this.pos2.getY() && plotId2.getY() >= this.pos1.getY();
    }

    public boolean contains(PlotId plotId) {
        return this.pos1.getX() <= plotId.getX() && this.pos1.getY() <= plotId.getY() && this.pos2.getX() >= plotId.getX() && this.pos2.getY() >= plotId.getY();
    }
}

