/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.LocaleHolder;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotComponentSetEvent;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.generator.SquarePlotWorld;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.BlockBucket;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlotModificationManager {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotModificationManager.class.getSimpleName()));
    private final Plot plot;
    private final ProgressSubscriberFactory subscriberFactory;

    @Inject
    PlotModificationManager(@NonNull Plot plot) {
        this.plot = plot;
        this.subscriberFactory = PlotSquared.platform().injector().getInstance(ProgressSubscriberFactory.class);
    }

    public CompletableFuture<Boolean> copy(final @NonNull Plot plot, final @Nullable PlotPlayer<?> plotPlayer) {
        Plot plot2;
        final CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        PlotId plotId = PlotId.of(plot.getId().getX() - this.plot.getId().getX(), plot.getId().getY() - this.plot.getId().getY());
        Location location = plot.getBottomAbs();
        Location location2 = this.plot.getBottomAbs();
        final int n = location.getX() - location2.getX();
        final int n2 = location.getZ() - location2.getZ();
        if (!this.plot.hasOwner()) {
            TaskManager.runTaskLater(() -> completableFuture.complete(false), TaskTime.ticks(1L));
            return completableFuture;
        }
        Set<Plot> set = this.plot.getConnectedPlots();
        for (Plot object2 : set) {
            plot2 = object2.getRelative(plot.getArea(), plotId.getX(), plotId.getY());
            if (!plot2.hasOwner()) continue;
            TaskManager.runTaskLater(() -> completableFuture.complete(false), TaskTime.ticks(1L));
            return completableFuture;
        }
        plot.updateWorldBorder();
        for (Plot plot3 : set) {
            plot2 = plot3.getRelative(plot.getArea(), plotId.getX(), plotId.getY());
            plot2.getPlotModificationManager().create(plot3.getOwner(), false);
            if (!plot3.getFlagContainer().getFlagMap().isEmpty()) {
                Iterator<UUID> iterator = plot2.getFlags();
                plot2.getFlagContainer().clearLocal();
                plot2.getFlagContainer().addAll(plot3.getFlagContainer().getFlagMap().values());
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    PlotFlag plotFlag = (PlotFlag)iterator2.next();
                    Object t = plot2.getFlagContainer().queryLocal(plotFlag.getClass());
                    if (plot2.getFlagContainer().queryLocal(plotFlag.getClass()) == null) {
                        DBFunc.removeFlag(plot2, plotFlag);
                        continue;
                    }
                    DBFunc.setFlag(plot2, t);
                }
            }
            if (plot3.isMerged()) {
                plot2.setMerged(plot3.getMerged());
            }
            if (plot3.members != null && !plot3.members.isEmpty()) {
                plot2.members = plot3.members;
                for (UUID uUID : plot3.members) {
                    DBFunc.setMember(plot2, uUID);
                }
            }
            if (plot3.trusted != null && !plot3.trusted.isEmpty()) {
                plot2.trusted = plot3.trusted;
                for (UUID uUID : plot3.trusted) {
                    DBFunc.setTrusted(plot2, uUID);
                }
            }
            if (plot3.denied == null || plot3.denied.isEmpty()) continue;
            plot2.denied = plot3.denied;
            for (UUID uUID : plot3.denied) {
                DBFunc.setDenied(plot2, uUID);
            }
        }
        final ArrayDeque<CuboidRegion> arrayDeque = new ArrayDeque<CuboidRegion>(this.plot.getRegions());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (arrayDeque.isEmpty()) {
                    QueueCoordinator queueCoordinator = PlotModificationManager.this.plot.getArea().getQueue();
                    for (Plot plot2 : PlotModificationManager.this.plot.getConnectedPlots()) {
                        plot.getManager().claimPlot(plot2, queueCoordinator);
                    }
                    if (queueCoordinator.size() > 0) {
                        queueCoordinator.enqueue();
                    }
                    plot.getPlotModificationManager().setSign();
                    completableFuture.complete(true);
                    return;
                }
                CuboidRegion cuboidRegion = (CuboidRegion)arrayDeque.poll();
                Location[] locationArray = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), cuboidRegion);
                Location location = locationArray[0];
                Location location2 = locationArray[1];
                Location location3 = location.add(n, 0, n2).withWorld(plot.getWorldName());
                PlotSquared.platform().regionManager().copyRegion(location, location2, location3, plotPlayer, this);
            }
        };
        runnable.run();
        return completableFuture;
    }

    public void clear(@Nullable Runnable runnable) {
        this.clear(false, false, null, runnable);
    }

    public boolean clear(boolean bl, final boolean bl2, final @Nullable PlotPlayer<?> plotPlayer, final @Nullable Runnable runnable) {
        if (bl && this.plot.getRunning() != 0) {
            return false;
        }
        final Set<CuboidRegion> set = this.plot.getRegions();
        final Set<Plot> set2 = this.plot.getConnectedPlots();
        final ArrayDeque<Plot> arrayDeque = new ArrayDeque<Plot>(set2);
        if (bl2) {
            this.removeSign();
        }
        final PlotManager plotManager = this.plot.getArea().getPlotManager();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (arrayDeque.isEmpty()) {
                    Runnable runnable2 = () -> {
                        for (CuboidRegion cuboidRegion : set) {
                            Location[] locationArray = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), cuboidRegion);
                            PlotSquared.platform().regionManager().clearAllEntities(locationArray[0], locationArray[1]);
                        }
                        TaskManager.runTask(runnable);
                    };
                    QueueCoordinator queueCoordinator = PlotModificationManager.this.plot.getArea().getQueue();
                    for (Plot plot : set2) {
                        if (bl2 || !plot.hasOwner()) {
                            plotManager.unClaimPlot(plot, null, queueCoordinator);
                            continue;
                        }
                        plotManager.claimPlot(plot, queueCoordinator);
                        PlotArea plotArea = PlotModificationManager.this.plot.getArea();
                        if (!(plotArea instanceof ClassicPlotWorld)) continue;
                        ClassicPlotWorld classicPlotWorld = (ClassicPlotWorld)plotArea;
                        plotManager.setComponent(plot.getId(), "wall", classicPlotWorld.WALL_FILLING.toPattern(), plotPlayer, queueCoordinator);
                    }
                    if (queueCoordinator.size() > 0) {
                        queueCoordinator.setCompleteTask(runnable2);
                        queueCoordinator.enqueue();
                        return;
                    }
                    runnable2.run();
                    return;
                }
                Plot plot = (Plot)arrayDeque.poll();
                plot.clearCache();
                if (PlotModificationManager.this.plot.getArea().getTerrain() != PlotAreaTerrainType.NONE) {
                    try {
                        PlotSquared.platform().regionManager().regenerateRegion(plot.getBottomAbs(), plot.getTopAbs(), false, this);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        unsupportedOperationException.printStackTrace();
                        return;
                    }
                    return;
                }
                plotManager.clearPlot(plot, this, plotPlayer, null);
            }
        };
        PlotUnlinkEvent plotUnlinkEvent = PlotSquared.get().getEventDispatcher().callUnlink(this.plot.getArea(), this.plot, true, !bl2, bl2 ? PlotUnlinkEvent.REASON.DELETE : PlotUnlinkEvent.REASON.CLEAR);
        if (plotUnlinkEvent.getEventResult() != Result.DENY) {
            if (this.unlinkPlot(plotUnlinkEvent.isCreateRoad(), plotUnlinkEvent.isCreateSign(), runnable2)) {
                PlotSquared.get().getEventDispatcher().callPostUnlink(this.plot, plotUnlinkEvent.getReason());
            }
        } else {
            runnable2.run();
        }
        return true;
    }

    public void setBiome(final @Nullable BiomeType biomeType, final @NonNull Runnable runnable) {
        final ArrayDeque<CuboidRegion> arrayDeque = new ArrayDeque<CuboidRegion>(this.plot.getRegions());
        final int n = this.plot.getArea() instanceof SquarePlotWorld ? (((SquarePlotWorld)this.plot.getArea()).ROAD_WIDTH > 0 ? 1 : 0) : 0;
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (arrayDeque.isEmpty()) {
                    TaskManager.runTask(runnable);
                    return;
                }
                CuboidRegion cuboidRegion = (CuboidRegion)arrayDeque.poll();
                PlotSquared.platform().regionManager().setBiome(cuboidRegion, n, biomeType, PlotModificationManager.this.plot.getArea(), this);
            }
        };
        runnable2.run();
    }

    public boolean unlinkPlot(boolean bl, boolean bl2) {
        return this.unlinkPlot(bl, bl2, null);
    }

    public boolean unlinkPlot(boolean bl, boolean bl2, Runnable runnable) {
        if (!this.plot.isMerged()) {
            if (runnable != null) {
                runnable.run();
            }
            return false;
        }
        Set<Plot> set = this.plot.getConnectedPlots();
        ArrayList<PlotId> arrayList = new ArrayList<PlotId>(set.size());
        for (Plot object2 : set) {
            object2.setHome(null);
            object2.clearCache();
            arrayList.add(object2.getId());
        }
        this.plot.clearRatings();
        QueueCoordinator queueCoordinator = this.plot.getArea().getQueue();
        if (bl2) {
            this.removeSign();
        }
        PlotManager plotManager = this.plot.getArea().getPlotManager();
        if (bl) {
            plotManager.startPlotUnlink(arrayList, queueCoordinator);
        }
        if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL && bl) {
            for (Plot plot : set) {
                if (plot.isMerged(Direction.EAST)) {
                    plotManager.createRoadEast(plot, queueCoordinator);
                    if (plot.isMerged(Direction.SOUTH)) {
                        plotManager.createRoadSouth(plot, queueCoordinator);
                        if (plot.isMerged(Direction.SOUTHEAST)) {
                            plotManager.createRoadSouthEast(plot, queueCoordinator);
                        }
                    }
                }
                if (!plot.isMerged(Direction.SOUTH)) continue;
                plotManager.createRoadSouth(plot, queueCoordinator);
            }
        }
        for (Plot plot : set) {
            boolean[] blArray = new boolean[]{false, false, false, false};
            plot.setMerged(blArray);
        }
        if (bl2) {
            queueCoordinator.setCompleteTask(() -> TaskManager.runTaskAsync(() -> {
                List<CompletableFuture> list = set.stream().map(plot -> PlotSquared.platform().playerManager().getUsernameCaption(plot.getOwnerAbs()).thenAccept(caption -> plot.getPlotModificationManager().setSign(caption.getComponent(LocaleHolder.console())))).toList();
                CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new)).whenComplete((void_, throwable) -> {
                    if (runnable != null) {
                        TaskManager.runTask(runnable);
                    }
                });
            }));
        } else if (runnable != null) {
            queueCoordinator.setCompleteTask(runnable);
        }
        if (bl) {
            plotManager.finishPlotUnlink(arrayList, queueCoordinator);
        }
        queueCoordinator.enqueue();
        return true;
    }

    public void setSign(@NonNull String string) {
        if (!this.plot.isLoaded()) {
            return;
        }
        PlotManager plotManager = this.plot.getArea().getPlotManager();
        if (this.plot.getArea().allowSigns()) {
            Location location = plotManager.getSignLoc(this.plot);
            String string2 = this.plot.getId().toString();
            Caption[] captionArray = new Caption[]{TranslatableCaption.of("signs.owner_sign_line_1"), TranslatableCaption.of("signs.owner_sign_line_2"), TranslatableCaption.of("signs.owner_sign_line_3"), TranslatableCaption.of("signs.owner_sign_line_4")};
            PlotSquared.platform().worldUtil().setSign(location, captionArray, TagResolver.builder().tag("id", Tag.inserting(Component.text(string2))).tag("owner", Tag.inserting(Component.text(string))).build());
        }
    }

    public void refreshChunks() {
        HashSet<BlockVector2> hashSet = new HashSet<BlockVector2>();
        for (CuboidRegion cuboidRegion : this.plot.getRegions()) {
            for (int i = cuboidRegion.getMinimumPoint().getX() >> 4; i <= cuboidRegion.getMaximumPoint().getX() >> 4; ++i) {
                for (int j = cuboidRegion.getMinimumPoint().getZ() >> 4; j <= cuboidRegion.getMaximumPoint().getZ() >> 4; ++j) {
                    if (!hashSet.add(BlockVector2.at((int)i, (int)j))) continue;
                    PlotSquared.platform().worldUtil().refreshChunk(i, j, this.plot.getWorldName());
                }
            }
        }
    }

    public void removeSign() {
        PlotManager plotManager = this.plot.getArea().getPlotManager();
        if (!this.plot.getArea().allowSigns()) {
            return;
        }
        Location location = plotManager.getSignLoc(this.plot);
        QueueCoordinator queueCoordinator = PlotSquared.platform().globalBlockQueue().getNewQueue(PlotSquared.platform().worldUtil().getWeWorld(this.plot.getWorldName()));
        queueCoordinator.setBlock(location.getX(), location.getY(), location.getZ(), BlockTypes.AIR.getDefaultState());
        queueCoordinator.enqueue();
    }

    public void setSign() {
        if (!this.plot.hasOwner()) {
            this.setSign("unknown");
            return;
        }
        PlotSquared.get().getImpromptuUUIDPipeline().getSingle(this.plot.getOwnerAbs(), (string, throwable) -> this.setSign((String)string));
    }

    public boolean create() {
        return this.create(this.plot.getOwnerAbs(), true);
    }

    public boolean create(@NonNull UUID uUID, boolean bl) {
        Integer n;
        this.plot.setOwnerAbs(uUID);
        Plot plot = this.plot.getArea().getOwnedPlotAbs(this.plot.getId());
        if (plot != null) {
            throw new IllegalStateException("Plot already exists!");
        }
        if (bl && (n = (Integer)this.plot.getArea().getMeta("worldBorder")) != null) {
            this.plot.updateWorldBorder();
        }
        this.plot.clearCache();
        this.plot.getTrusted().clear();
        this.plot.getMembers().clear();
        this.plot.getDenied().clear();
        this.plot.settings = new PlotSettings();
        if (this.plot.getArea().addPlot(this.plot)) {
            DBFunc.createPlotAndSettings(this.plot, () -> {
                PlotArea plotArea = this.plot.getArea();
                if (bl && plotArea.isAutoMerge()) {
                    PlotPlayer<?> plotPlayer = PlotSquared.platform().playerManager().getPlayerIfExists(uUID);
                    PlotMergeEvent plotMergeEvent = PlotSquared.get().getEventDispatcher().callMerge(this.plot, Direction.ALL, Integer.MAX_VALUE, plotPlayer);
                    if (plotMergeEvent.getEventResult() == Result.DENY) {
                        if (plotPlayer != null) {
                            plotPlayer.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Auto merge on claim"))));
                        }
                        return;
                    }
                    if (this.plot.getPlotModificationManager().autoMerge(plotMergeEvent.getDir(), plotMergeEvent.getMax(), uUID, plotPlayer, true)) {
                        PlotSquared.get().getEventDispatcher().callPostMerge(plotPlayer, this.plot);
                    }
                }
            });
            return true;
        }
        LOGGER.info("Failed to add plot {} to plot area {}", (Object)this.plot.getId().toCommaSeparatedString(), (Object)this.plot.getArea().toString());
        return false;
    }

    public boolean autoMerge(@NonNull Direction direction, int n, @NonNull UUID uUID, @Nullable PlotPlayer<?> plotPlayer, boolean bl) {
        Plot plot;
        if (!this.plot.hasOwner()) {
            return false;
        }
        Set<Plot> set = this.plot.getConnectedPlots();
        HashSet hashSet = set.stream().map(Plot::getId).collect(Collectors.toCollection(HashSet::new));
        ArrayDeque<Plot> arrayDeque = new ArrayDeque<Plot>(set);
        boolean bl2 = false;
        HashSet<Plot> hashSet2 = new HashSet<Plot>();
        QueueCoordinator queueCoordinator = this.plot.getArea().getQueue();
        while ((plot = arrayDeque.poll()) != null && n >= 0) {
            ArrayList<PlotId> arrayList;
            Set<Plot> set2;
            Plot plot2;
            if (hashSet2.contains(plot)) continue;
            hashSet2.add(plot);
            if ((direction == Direction.ALL || direction == Direction.NORTH) && !plot.isMerged(Direction.NORTH) && (plot2 = plot.getRelative(Direction.NORTH)) != null && plot2.isOwner(uUID) && (plot2.getBasePlot(false).equals(plot.getBasePlot(false)) || (set2 = plot2.getConnectedPlots()).size() <= n && arrayDeque.addAll(set2) && (n -= set2.size()) != -1)) {
                plot.mergePlot(plot2, bl, queueCoordinator);
                hashSet.add(plot.getId());
                hashSet.add(plot2.getId());
                bl2 = true;
                if (bl) {
                    arrayList = new ArrayList<PlotId>();
                    arrayList.add(plot.getId());
                    arrayList.add(plot2.getId());
                    this.plot.getManager().finishPlotMerge(arrayList, queueCoordinator);
                }
            }
            if (n >= 0 && (direction == Direction.ALL || direction == Direction.EAST) && !plot.isMerged(Direction.EAST) && (plot2 = plot.getRelative(Direction.EAST)) != null && plot2.isOwner(uUID) && (plot2.getBasePlot(false).equals(plot.getBasePlot(false)) || (set2 = plot2.getConnectedPlots()).size() <= n && arrayDeque.addAll(set2) && (n -= set2.size()) != -1)) {
                plot.mergePlot(plot2, bl, queueCoordinator);
                hashSet.add(plot.getId());
                hashSet.add(plot2.getId());
                bl2 = true;
                if (bl) {
                    arrayList = new ArrayList();
                    arrayList.add(plot.getId());
                    arrayList.add(plot2.getId());
                    this.plot.getManager().finishPlotMerge(arrayList, queueCoordinator);
                }
            }
            if (n >= 0 && (direction == Direction.ALL || direction == Direction.SOUTH) && !plot.isMerged(Direction.SOUTH) && (plot2 = plot.getRelative(Direction.SOUTH)) != null && plot2.isOwner(uUID) && (plot2.getBasePlot(false).equals(plot.getBasePlot(false)) || (set2 = plot2.getConnectedPlots()).size() <= n && arrayDeque.addAll(set2) && (n -= set2.size()) != -1)) {
                plot.mergePlot(plot2, bl, queueCoordinator);
                hashSet.add(plot.getId());
                hashSet.add(plot2.getId());
                bl2 = true;
                if (bl) {
                    arrayList = new ArrayList();
                    arrayList.add(plot.getId());
                    arrayList.add(plot2.getId());
                    this.plot.getManager().finishPlotMerge(arrayList, queueCoordinator);
                }
            }
            if (n < 0 || direction != Direction.ALL && direction != Direction.WEST || plot.isMerged(Direction.WEST) || (plot2 = plot.getRelative(Direction.WEST)) == null || !plot2.isOwner(uUID) || !plot2.getBasePlot(false).equals(plot.getBasePlot(false)) && ((set2 = plot2.getConnectedPlots()).size() > n || !arrayDeque.addAll(set2) || (n -= set2.size()) == -1)) continue;
            plot.mergePlot(plot2, bl, queueCoordinator);
            hashSet.add(plot.getId());
            hashSet.add(plot2.getId());
            bl2 = true;
            if (!bl) continue;
            arrayList = new ArrayList();
            arrayList.add(plot.getId());
            arrayList.add(plot2.getId());
            this.plot.getManager().finishPlotMerge(arrayList, queueCoordinator);
        }
        if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
            queueCoordinator.addProgressSubscriber(this.subscriberFactory.createWithActor(plotPlayer));
        }
        if (queueCoordinator.size() > 0) {
            queueCoordinator.enqueue();
        }
        hashSet2.forEach(Plot::clearCache);
        return bl2;
    }

    public @NonNull CompletableFuture<Boolean> move(final @NonNull Plot plot, final @Nullable PlotPlayer<?> plotPlayer, final @NonNull Runnable runnable, boolean bl3) {
        Object object;
        final PlotId plotId = PlotId.of(plot.getId().getX() - this.plot.getId().getX(), plot.getId().getY() - this.plot.getId().getY());
        Location location = plot.getBottomAbs();
        Location location2 = this.plot.getBottomAbs();
        final int n = location.getX() - location2.getX();
        final int n2 = location.getZ() - location2.getZ();
        if (!this.plot.hasOwner()) {
            TaskManager.runTaskLater(runnable, TaskTime.ticks(1L));
            return CompletableFuture.completedFuture(false);
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Set<Plot> set = this.plot.getConnectedPlots();
        for (Plot object22 : set) {
            object = object22.getRelative(plot.getArea(), plotId.getX(), plotId.getY());
            if (((Plot)object).hasOwner()) {
                if (!bl3) {
                    TaskManager.runTaskLater(runnable, TaskTime.ticks(1L));
                    return CompletableFuture.completedFuture(false);
                }
                atomicBoolean.set(true);
                continue;
            }
            object22.getPlotModificationManager().removeSign();
        }
        plot.updateWorldBorder();
        final ArrayDeque<CuboidRegion> arrayDeque = new ArrayDeque<CuboidRegion>(this.plot.getRegions());
        final PlotArea plotArea = this.plot.getArea();
        object = set.iterator();
        CompletionStage<Boolean> completionStage = null;
        if (object.hasNext()) {
            while (object.hasNext()) {
                Plot plot2 = (Plot)object.next();
                Plot plot3 = plot2.getRelative(plot.getArea(), plotId.getX(), plotId.getY());
                CompletableFuture<Boolean> completableFuture = plot2.swapData(plot3);
                if (completionStage == null) {
                    completionStage = completableFuture;
                    continue;
                }
                completionStage = completionStage.thenCombine(completableFuture, (bl, bl2) -> bl);
            }
        } else {
            completionStage = CompletableFuture.completedFuture(true);
        }
        return completionStage.thenApply(bl -> {
            if (!bl.booleanValue()) {
                return false;
            }
            if (atomicBoolean.get()) {
                new Runnable(){

                    @Override
                    public void run() {
                        if (arrayDeque.isEmpty()) {
                            plot.getPlotModificationManager().setSign();
                            PlotModificationManager.this.setSign();
                            TaskManager.runTask(runnable);
                        } else {
                            CuboidRegion cuboidRegion = (CuboidRegion)arrayDeque.poll();
                            Location[] locationArray = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), cuboidRegion);
                            Location location = locationArray[0];
                            Location location2 = locationArray[1];
                            Location location3 = location.add(n, 0, n2).withWorld(plot.getWorldName());
                            PlotSquared.platform().regionManager().swap(location, location2, location3, plotPlayer, this);
                        }
                    }
                }.run();
            } else {
                new Runnable(){

                    @Override
                    public void run() {
                        if (arrayDeque.isEmpty()) {
                            Plot plot3 = plot.getRelative(0, 0);
                            Plot plot2 = plotArea.getPlotAbs(PlotId.of(plot3.getId().getX() - plotId.getX(), plot3.getId().getY() - plotId.getY()));
                            Runnable runnable2 = () -> {
                                QueueCoordinator queueCoordinator = PlotModificationManager.this.plot.getArea().getQueue();
                                for (Plot plot2 : plot3.getConnectedPlots()) {
                                    PlotModificationManager.this.plot.getManager().claimPlot(plot2, queueCoordinator);
                                }
                                if (queueCoordinator.size() > 0) {
                                    queueCoordinator.enqueue();
                                }
                                plot3.getPlotModificationManager().setSign();
                                TaskManager.runTask(runnable);
                            };
                            if (plot2 != null) {
                                plot2.getPlotModificationManager().clear(false, true, plotPlayer, runnable2);
                            } else {
                                runnable2.run();
                            }
                            return;
                        }
                        5 var1_2 = this;
                        CuboidRegion cuboidRegion = (CuboidRegion)arrayDeque.poll();
                        Location[] locationArray = Plot.getCorners(PlotModificationManager.this.plot.getWorldName(), cuboidRegion);
                        Location location = locationArray[0];
                        Location location2 = locationArray[1];
                        Location location3 = location.add(n, 0, n2).withWorld(plot.getWorldName());
                        PlotSquared.platform().regionManager().copyRegion(location, location2, location3, plotPlayer, var1_2);
                    }
                }.run();
            }
            return true;
        });
    }

    public boolean unlink() {
        return this.unlinkPlot(true, true);
    }

    public @NonNull CompletableFuture<Boolean> swap(@NonNull Plot plot, @Nullable PlotPlayer<?> plotPlayer, @NonNull Runnable runnable) {
        return this.move(plot, plotPlayer, runnable, true);
    }

    public @NonNull CompletableFuture<Boolean> move(@NonNull Plot plot, @Nullable PlotPlayer<?> plotPlayer, @NonNull Runnable runnable) {
        return this.move(plot, plotPlayer, runnable, false);
    }

    public boolean setComponent(@NonNull String string, @NonNull Pattern pattern, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        PlotComponentSetEvent plotComponentSetEvent = PlotSquared.get().getEventDispatcher().callComponentSet(this.plot, string, pattern);
        return this.plot.getManager().setComponent(this.plot.getId(), plotComponentSetEvent.getComponent(), plotComponentSetEvent.getPattern(), plotPlayer, queueCoordinator);
    }

    public boolean deletePlot(@Nullable PlotPlayer<?> plotPlayer, Runnable runnable) {
        if (!this.plot.hasOwner()) {
            return false;
        }
        Set<Plot> set = this.plot.getConnectedPlots();
        this.clear(false, true, plotPlayer, () -> {
            for (Plot plot : set) {
                plot.unclaim();
            }
            TaskManager.runTask(runnable);
        });
        return true;
    }

    @Deprecated
    public boolean setComponent(String string, String string2, @Nullable PlotPlayer<?> plotPlayer, @Nullable QueueCoordinator queueCoordinator) {
        BlockBucket blockBucket = ConfigurationUtil.BLOCK_BUCKET.parseString(string2);
        if (blockBucket != null && blockBucket.isEmpty()) {
            return false;
        }
        return this.setComponent(string, blockBucket.toPattern(), plotPlayer, queueCoordinator);
    }

    public void removeRoadSouth(@Nullable QueueCoordinator queueCoordinator) {
        if (this.plot.getArea().getType() != PlotAreaType.NORMAL && this.plot.getArea().getTerrain() == PlotAreaTerrainType.ROAD) {
            Plot plot = this.plot.getRelative(Direction.SOUTH);
            Location location = plot.getBottomAbs();
            Location location2 = this.plot.getTopAbs();
            Location location3 = Location.at(this.plot.getWorldName(), location.getX(), this.plot.getArea().getMinGenHeight(), location2.getZ());
            Location location4 = Location.at(this.plot.getWorldName(), location2.getX(), this.plot.getArea().getMaxGenHeight(), location.getZ());
            PlotSquared.platform().regionManager().regenerateRegion(location3, location4, true, null);
        } else if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL) {
            this.plot.getManager().removeRoadSouth(this.plot, queueCoordinator);
        }
    }

    public void removeRoadEast(@Nullable QueueCoordinator queueCoordinator) {
        if (this.plot.getArea().getType() != PlotAreaType.NORMAL && this.plot.getArea().getTerrain() == PlotAreaTerrainType.ROAD) {
            Plot plot = this.plot.getRelative(Direction.EAST);
            Location location = plot.getBottomAbs();
            Location location2 = this.plot.getTopAbs();
            Location location3 = Location.at(this.plot.getWorldName(), location2.getX(), this.plot.getArea().getMinGenHeight(), location.getZ());
            Location location4 = Location.at(this.plot.getWorldName(), location.getX(), this.plot.getArea().getMaxGenHeight(), location2.getZ());
            PlotSquared.platform().regionManager().regenerateRegion(location3, location4, true, null);
        } else if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL) {
            this.plot.getArea().getPlotManager().removeRoadEast(this.plot, queueCoordinator);
        }
    }

    public void removeRoadSouthEast(@Nullable QueueCoordinator queueCoordinator) {
        if (this.plot.getArea().getType() != PlotAreaType.NORMAL && this.plot.getArea().getTerrain() == PlotAreaTerrainType.ROAD) {
            Plot plot = this.plot.getRelative(1, 1);
            Location location = this.plot.getTopAbs().add(1, 0, 1);
            Location location2 = plot.getBottomAbs().subtract(1, 0, 1);
            PlotSquared.platform().regionManager().regenerateRegion(location, location2, true, null);
        } else if (this.plot.getArea().getTerrain() != PlotAreaTerrainType.ALL) {
            this.plot.getArea().getPlotManager().removeRoadSouthEast(this.plot, queueCoordinator);
        }
    }
}

