/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.configuration.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;

public class Rating {
    private static final String LIKE_INTERNAL = "__LIKES__";
    private final HashMap<String, Integer> ratingMap = new HashMap();
    private final int initial;
    private boolean changed;

    public Rating(int n) {
        if (Settings.Ratings.USE_LIKES) {
            this.initial = n == 10 ? 10 : 1;
            this.ratingMap.put(LIKE_INTERNAL, this.initial == 10 ? 10 : 1);
        } else {
            this.initial = n;
            if (Settings.Ratings.CATEGORIES != null && Settings.Ratings.CATEGORIES.size() > 1) {
                if (n < 10) {
                    for (String string : Settings.Ratings.CATEGORIES) {
                        this.ratingMap.put(string, n);
                    }
                    this.changed = true;
                    return;
                }
                for (String string : Settings.Ratings.CATEGORIES) {
                    this.ratingMap.put(string, n % 10 - 1);
                    n /= 10;
                }
            } else {
                this.ratingMap.put(null, n);
            }
        }
    }

    public List<String> getCategories() {
        if (this.ratingMap.size() == 1) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(this.ratingMap.keySet());
    }

    public double getAverageRating() {
        if (Settings.Ratings.USE_LIKES) {
            return this.getLike() ? 10.0 : 1.0;
        }
        double d = this.ratingMap.values().stream().mapToDouble(n -> n.intValue()).sum();
        return d / (double)this.ratingMap.size();
    }

    public boolean getLike() {
        Integer n = this.getRating(LIKE_INTERNAL);
        return n != null && n == 10;
    }

    public Integer getRating(String string) {
        return this.ratingMap.get(string);
    }

    public boolean setRating(String string, int n) {
        this.changed = true;
        if (!this.ratingMap.containsKey(string)) {
            return false;
        }
        return this.ratingMap.put(string, n) != null;
    }

    public int getAggregate() {
        if (!this.changed) {
            return this.initial;
        }
        if (Settings.Ratings.USE_LIKES) {
            return this.ratingMap.get(LIKE_INTERNAL);
        }
        if (Settings.Ratings.CATEGORIES != null && Settings.Ratings.CATEGORIES.size() > 1) {
            return IntStream.range(0, Settings.Ratings.CATEGORIES.size()).map(n -> (int)((double)(n + 1) * Math.pow(10.0, this.ratingMap.get(Settings.Ratings.CATEGORIES.get(n)).intValue()))).sum();
        }
        return this.ratingMap.get(null);
    }
}

