/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.comment;

import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.task.RunnableVal;
import java.util.List;

public abstract class CommentInbox {
    public abstract String toString();

    public boolean canRead(Plot plot, PlotPlayer<?> plotPlayer) {
        if (plotPlayer.hasPermission("plots.inbox.read." + this, true)) {
            return plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission("plots.inbox.read." + this + ".other", true);
        }
        return false;
    }

    public boolean canWrite(Plot plot, PlotPlayer<?> plotPlayer) {
        if (plot == null) {
            return plotPlayer.hasPermission("plots.inbox.write." + this, true);
        }
        return plotPlayer.hasPermission("plots.inbox.write." + this, true) && (plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission("plots.inbox.write." + this + ".other", true));
    }

    public boolean canModify(Plot plot, PlotPlayer<?> plotPlayer) {
        if (plotPlayer.hasPermission("plots.inbox.modify." + this, true)) {
            return plot.isOwner(plotPlayer.getUUID()) || plotPlayer.hasPermission("plots.inbox.modify." + this + ".other", true);
        }
        return false;
    }

    public abstract boolean getComments(Plot var1, RunnableVal<List<PlotComment>> var2);

    public abstract boolean addComment(Plot var1, PlotComment var2);

    public void removeComment(Plot plot, PlotComment plotComment) {
        DBFunc.removeComment(plot, plotComment);
    }

    public void clearInbox(Plot plot) {
        DBFunc.clearInbox(plot, this.toString());
    }
}

