/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.comment;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.StaticCaption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.comment.CommentInbox;
import com.plotsquared.core.plot.comment.InboxOwner;
import com.plotsquared.core.plot.comment.InboxPublic;
import com.plotsquared.core.plot.comment.InboxReport;
import com.plotsquared.core.plot.comment.PlotComment;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.plotsquared.google.TypeLiteral;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CommentManager {
    public static final HashMap<String, CommentInbox> inboxes = new HashMap();

    public static void sendTitle(final PlotPlayer<?> plotPlayer, Plot plot) {
        if (!Settings.Enabled_Components.COMMENT_NOTIFIER || !plot.isOwner(plotPlayer.getUUID())) {
            return;
        }
        TaskManager.runTaskLaterAsync(() -> {
            Collection<CommentInbox> collection = inboxes.values();
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            final AtomicInteger atomicInteger2 = new AtomicInteger(collection.size());
            for (final CommentInbox commentInbox : inboxes.values()) {
                commentInbox.getComments(plot, new RunnableVal<List<PlotComment>>(){

                    @Override
                    public void run(List<PlotComment> list) {
                        int n;
                        if (list != null) {
                            int n2 = 0;
                            for (PlotComment plotComment : list) {
                                if (plotComment.timestamp() <= CommentManager.getTimestamp(plotPlayer, commentInbox.toString())) continue;
                                ++n2;
                            }
                            n = atomicInteger.addAndGet(n2);
                        } else {
                            n = atomicInteger.get();
                        }
                        if (atomicInteger2.decrementAndGet() == 0 && n > 0) {
                            plotPlayer.sendTitle((Caption)StaticCaption.of(""), (Caption)TranslatableCaption.of("comment.inbox_notification"), TagResolver.builder().tag("amount", Tag.inserting(Component.text(n))).tag("command", Tag.inserting(Component.text("/plot inbox"))).build());
                        }
                    }
                });
            }
        }, TaskTime.seconds(1L));
    }

    public static long getTimestamp(PlotPlayer<?> plotPlayer, String string) {
        MetaDataKey<Long> metaDataKey = MetaDataKey.of(String.format("inbox:%s", string), new TypeLiteral<Long>(){});
        try (MetaDataAccess<Long> metaDataAccess = plotPlayer.accessTemporaryMetaData(metaDataKey);){
            long l = metaDataAccess.get().orElse(plotPlayer.getLastPlayed());
            return l;
        }
    }

    public static void addInbox(CommentInbox commentInbox) {
        inboxes.put(commentInbox.toString().toLowerCase(), commentInbox);
    }

    public static void registerDefaultInboxes() {
        CommentManager.addInbox(new InboxReport());
        CommentManager.addInbox(new InboxPublic());
        CommentManager.addInbox(new InboxOwner());
    }
}

