/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.plotsquared.core.annotations.informative.NotPublic;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FlagContainer {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + FlagContainer.class.getSimpleName()));
    private final Map<String, String> unknownFlags = new HashMap<String, String>();
    private final Map<Class<?>, PlotFlag<?, ?>> flagMap = new HashMap();
    private final PlotFlagUpdateHandler plotFlagUpdateHandler;
    private final Collection<PlotFlagUpdateHandler> updateSubscribers = new HashSet<PlotFlagUpdateHandler>();
    private final PlotFlagUpdateHandler unknownsRef;
    private FlagContainer parentContainer;

    public FlagContainer(@Nullable FlagContainer flagContainer, @Nullable PlotFlagUpdateHandler plotFlagUpdateHandler) {
        this.parentContainer = flagContainer;
        this.plotFlagUpdateHandler = plotFlagUpdateHandler;
        if (!(this instanceof GlobalFlagContainer)) {
            this.unknownsRef = this::handleUnknowns;
            GlobalFlagContainer.getInstance().subscribe(this.unknownsRef);
        } else {
            this.unknownsRef = null;
        }
    }

    public FlagContainer(@Nullable FlagContainer flagContainer) {
        this(flagContainer, null);
    }

    public static <V, T extends PlotFlag<V, ?>> T castUnsafe(PlotFlag<?, ?> plotFlag) {
        return (T)plotFlag;
    }

    public @Nullable FlagContainer getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(FlagContainer flagContainer) {
        this.parentContainer = flagContainer;
    }

    protected Map<Class<?>, PlotFlag<?, ?>> getInternalPlotFlagMap() {
        return this.flagMap;
    }

    public Map<Class<?>, PlotFlag<?, ?>> getFlagMap() {
        return ImmutableMap.builder().putAll(this.flagMap).build();
    }

    public <V, T extends PlotFlag<V, ?>> void addFlag(T t) {
        try {
            Preconditions.checkState((t.getName().length() <= 64 ? 1 : 0) != 0, (Object)("flag name may not be more than 64 characters. Check: " + t.getName()));
            PlotFlag<?, ?> plotFlag = this.flagMap.put(t.getClass(), t);
            PlotFlagUpdateType plotFlagUpdateType = plotFlag != null ? PlotFlagUpdateType.FLAG_UPDATED : PlotFlagUpdateType.FLAG_ADDED;
            if (this.plotFlagUpdateHandler != null) {
                this.plotFlagUpdateHandler.handle(t, plotFlagUpdateType);
            }
            this.updateSubscribers.forEach(plotFlagUpdateHandler -> plotFlagUpdateHandler.handle(t, plotFlagUpdateType));
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.info("Flag {} (class '{}') could not be added to the container because the flag name exceeded the allowed limit of 64 characters. Please tell the developer of the flag to fix this.", (Object)t.getName(), (Object)t.getClass().getName());
            illegalStateException.printStackTrace();
        }
    }

    public <V, T extends PlotFlag<V, ?>> V removeFlag(T t) {
        PlotFlag<?, ?> plotFlag = this.flagMap.remove(t.getClass());
        if (this.plotFlagUpdateHandler != null) {
            this.plotFlagUpdateHandler.handle(t, PlotFlagUpdateType.FLAG_REMOVED);
        }
        this.updateSubscribers.forEach(plotFlagUpdateHandler -> plotFlagUpdateHandler.handle(t, PlotFlagUpdateType.FLAG_REMOVED));
        if (plotFlag == null) {
            return null;
        }
        return (V)plotFlag;
    }

    public void addAll(Collection<PlotFlag<?, ?>> collection) {
        for (PlotFlag<?, ?> plotFlag : collection) {
            this.addFlag(plotFlag);
        }
    }

    public void addAll(FlagContainer flagContainer) {
        this.addAll(flagContainer.flagMap.values());
    }

    public void clearLocal() {
        this.flagMap.clear();
    }

    public Collection<PlotFlag<?, ?>> getRecognizedPlotFlags() {
        return this.getHighestClassContainer().getFlagMap().values();
    }

    public final FlagContainer getHighestClassContainer() {
        if (this.getParentContainer() != null) {
            return this.getParentContainer();
        }
        return this;
    }

    public PlotFlag<?, ?> getFlagErased(Class<?> clazz) {
        PlotFlag<?, ?> plotFlag = this.flagMap.get(clazz);
        if (plotFlag != null) {
            return plotFlag;
        }
        if (this.getParentContainer() != null) {
            return this.getParentContainer().getFlagErased(clazz);
        }
        return null;
    }

    public <V, T extends PlotFlag<V, ?>> T getFlag(Class<? extends T> clazz) {
        PlotFlag<?, ?> plotFlag = this.flagMap.get(clazz);
        if (plotFlag != null) {
            return FlagContainer.castUnsafe(plotFlag);
        }
        if (this.getParentContainer() != null) {
            return this.getParentContainer().getFlag(clazz);
        }
        return null;
    }

    public <V, T extends PlotFlag<V, ?>> @Nullable T queryLocal(Class<?> clazz) {
        PlotFlag<?, ?> plotFlag = this.flagMap.get(clazz);
        if (plotFlag == null) {
            return null;
        }
        return FlagContainer.castUnsafe(plotFlag);
    }

    public void subscribe(@NonNull PlotFlagUpdateHandler plotFlagUpdateHandler) {
        this.updateSubscribers.add(plotFlagUpdateHandler);
    }

    private void handleUnknowns(PlotFlag<?, ?> plotFlag, PlotFlagUpdateType plotFlagUpdateType) {
        String string;
        if (plotFlagUpdateType != PlotFlagUpdateType.FLAG_REMOVED && this.unknownFlags.containsKey(plotFlag.getName()) && (string = this.unknownFlags.remove(plotFlag.getName())) != null) {
            string = CaptionUtility.stripClickEvents(plotFlag, string);
            try {
                this.addFlag((PlotFlag)plotFlag.parse(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addUnknownFlag(String string, String string2) {
        this.unknownFlags.put(string.toLowerCase(Locale.ENGLISH), string2);
    }

    @NotPublic
    public Runnable createCleanupHook() {
        return () -> GlobalFlagContainer.getInstance().unsubscribe(this.unknownsRef);
    }

    void unsubscribe(@Nullable PlotFlagUpdateHandler plotFlagUpdateHandler) {
        if (plotFlagUpdateHandler != null) {
            this.updateSubscribers.remove(plotFlagUpdateHandler);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FlagContainer flagContainer = (FlagContainer)object;
        return this.flagMap.equals(flagContainer.flagMap);
    }

    public int hashCode() {
        return this.flagMap.hashCode();
    }

    @FunctionalInterface
    public static interface PlotFlagUpdateHandler {
        public void handle(PlotFlag<?, ?> var1, PlotFlagUpdateType var2);
    }

    public static enum PlotFlagUpdateType {
        FLAG_ADDED,
        FLAG_REMOVED,
        FLAG_UPDATED;

    }
}

