/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag;

import com.google.common.base.Preconditions;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.caption.Caption;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class PlotFlag<T, F extends PlotFlag<T, F>> {
    private final T value;
    private final Caption flagCategory;
    private final Caption flagDescription;
    private final String flagName;

    protected PlotFlag(@NonNull T t, @NonNull Caption caption, @NonNull Caption caption2) {
        this.value = Preconditions.checkNotNull(t, (Object)"flag value may not be null");
        this.flagCategory = (Caption)Preconditions.checkNotNull((Object)caption, (Object)"flag category may not be null");
        this.flagDescription = (Caption)Preconditions.checkNotNull((Object)caption2, (Object)"flag description may not be null");
        this.flagName = PlotFlag.getFlagName(this.getClass());
    }

    public static <T, F extends PlotFlag<T, F>> String getFlagName(Class<F> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = clazz.getSimpleName().replace("Flag", "").toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append(Character.toLowerCase(cArray[i]));
                continue;
            }
            if (Character.isUpperCase(cArray[i])) {
                stringBuilder.append('-').append(Character.toLowerCase(cArray[i]));
                continue;
            }
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    public static <T, F extends PlotFlag<T, F>> Component getFlagNameComponent(Class<F> clazz) {
        return Component.text(PlotFlag.getFlagName(clazz));
    }

    public final @NonNull T getValue() {
        return this.value;
    }

    public abstract F parse(@NonNull String var1);

    public abstract F merge(@NonNull T var1);

    public abstract String toString();

    public final String getName() {
        return this.flagName;
    }

    public Caption getFlagDescription() {
        return this.flagDescription;
    }

    public Caption getFlagCategory() {
        return this.flagCategory;
    }

    public boolean isValuedPermission() {
        return true;
    }

    public abstract String getExample();

    protected abstract F flagOf(@NonNull T var1);

    public final F createFlagInstance(@NonNull T t) {
        return this.flagOf(Preconditions.checkNotNull(t));
    }

    public Collection<String> getTabCompletions() {
        return Collections.emptyList();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlotFlag plotFlag = (PlotFlag)object;
        return this.value.equals(plotFlag.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

