/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DenyTeleportFlag
extends PlotFlag<DeniedGroup, DenyTeleportFlag> {
    public static final DenyTeleportFlag DENY_TELEPORT_FLAG_NONE = new DenyTeleportFlag(DeniedGroup.NONE);

    protected DenyTeleportFlag(@NonNull DeniedGroup deniedGroup) {
        super(deniedGroup, TranslatableCaption.of("flags.flag_category_enum"), TranslatableCaption.of("flags.flag_description_deny_teleport"));
    }

    public static boolean allowsTeleport(PlotPlayer<?> plotPlayer, Plot plot) {
        boolean bl;
        DeniedGroup deniedGroup = (DeniedGroup)((Object)plot.getFlag(DenyTeleportFlag.class));
        if (deniedGroup == DeniedGroup.NONE) {
            return true;
        }
        switch (deniedGroup) {
            case TRUSTED: {
                bl = !plot.getTrusted().contains(plotPlayer.getUUID());
                break;
            }
            case MEMBERS: {
                bl = !plot.getMembers().contains(plotPlayer.getUUID());
                break;
            }
            case NONMEMBERS: {
                bl = plot.isAdded(plotPlayer.getUUID());
                break;
            }
            case NONTRUSTED: {
                bl = plot.getTrusted().contains(plotPlayer.getUUID()) || plot.isOwner(plotPlayer.getUUID());
                break;
            }
            case NONOWNERS: {
                bl = plot.isOwner(plotPlayer.getUUID());
                break;
            }
            default: {
                return true;
            }
        }
        return bl || plotPlayer.hasPermission("plots.admin.entry.denied");
    }

    @Override
    public DenyTeleportFlag parse(@NonNull String string) {
        DeniedGroup deniedGroup = DeniedGroup.fromString(string);
        if (deniedGroup == null) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_enum"), TagResolver.resolver("list", Tag.inserting(Component.text("members, nonmembers, trusted, nontrusted, nonowners"))));
        }
        return this.flagOf(deniedGroup);
    }

    @Override
    public DenyTeleportFlag merge(@NonNull DeniedGroup deniedGroup) {
        if (((DeniedGroup)((Object)this.getValue())).ordinal() < deniedGroup.ordinal()) {
            return this.flagOf(deniedGroup);
        }
        return this;
    }

    @Override
    public String toString() {
        return ((DeniedGroup)((Object)this.getValue())).name();
    }

    @Override
    public String getExample() {
        return "trusted";
    }

    @Override
    protected DenyTeleportFlag flagOf(@NonNull DeniedGroup deniedGroup) {
        return new DenyTeleportFlag(deniedGroup);
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("none", "members", "trusted", "nonmembers", "nontrusted", "nonowners");
    }

    public static enum DeniedGroup {
        NONE,
        MEMBERS,
        TRUSTED,
        NONMEMBERS,
        NONTRUSTED,
        NONOWNERS;


        public static @Nullable DeniedGroup fromString(@NonNull String string) {
            for (DeniedGroup deniedGroup : DeniedGroup.values()) {
                if (!deniedGroup.name().equalsIgnoreCase(string)) continue;
                return deniedGroup;
            }
            return null;
        }
    }
}

