/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LiquidFlowFlag
extends PlotFlag<FlowStatus, LiquidFlowFlag> {
    public static final LiquidFlowFlag LIQUID_FLOW_ENABLED = new LiquidFlowFlag(FlowStatus.ENABLED);
    public static final LiquidFlowFlag LIQUID_FLOW_DISABLED = new LiquidFlowFlag(FlowStatus.DISABLED);
    public static final LiquidFlowFlag LIQUID_FLOW_DEFAULT = new LiquidFlowFlag(FlowStatus.DEFAULT);

    private LiquidFlowFlag(FlowStatus flowStatus) {
        super(flowStatus, TranslatableCaption.of("flags.flag_category_boolean"), TranslatableCaption.of("flags.flag_description_liquid_flow"));
    }

    @Override
    public LiquidFlowFlag parse(@NonNull String string) {
        return switch (string.toLowerCase()) {
            case "true", "enabled", "allow" -> LIQUID_FLOW_ENABLED;
            case "false", "disabled", "disallow" -> LIQUID_FLOW_DISABLED;
            default -> LIQUID_FLOW_DEFAULT;
        };
    }

    @Override
    public LiquidFlowFlag merge(@NonNull FlowStatus flowStatus) {
        if (flowStatus == FlowStatus.ENABLED || this.getValue() == FlowStatus.ENABLED) {
            return LIQUID_FLOW_ENABLED;
        }
        return this.flagOf(flowStatus);
    }

    @Override
    public String toString() {
        return ((FlowStatus)((Object)this.getValue())).name().toLowerCase();
    }

    @Override
    public String getExample() {
        return "true";
    }

    @Override
    protected LiquidFlowFlag flagOf(@NonNull FlowStatus flowStatus) {
        return switch (flowStatus) {
            case FlowStatus.ENABLED -> LIQUID_FLOW_ENABLED;
            case FlowStatus.DISABLED -> LIQUID_FLOW_DISABLED;
            default -> LIQUID_FLOW_DEFAULT;
        };
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("true", "false", "default");
    }

    public static enum FlowStatus {
        ENABLED,
        DISABLED,
        DEFAULT;

    }
}

