/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.PlotTitle;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.StringMan;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlotTitleFlag
extends PlotFlag<PlotTitle, PlotTitleFlag> {
    public static final PlotTitleFlag TITLE_FLAG_DEFAULT = new PlotTitleFlag(PlotTitle.CONFIGURED);

    protected PlotTitleFlag(PlotTitle plotTitle) {
        super(plotTitle, TranslatableCaption.of("flags.flag_category_string"), TranslatableCaption.of("flags.flag_description_title"));
    }

    @Override
    public PlotTitleFlag parse(@NonNull String string) {
        if (string.equals("CONFIGURED")) {
            return TITLE_FLAG_DEFAULT;
        }
        if (!string.contains("\"")) {
            return new PlotTitleFlag(new PlotTitle(string, ""));
        }
        List<String> list = StringMan.splitMessage(string);
        if (list.isEmpty() || list.size() > 2) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_title"), new TagResolver[0]);
        }
        PlotTitle plotTitle = list.size() == 1 ? new PlotTitle(list.get(0), "") : new PlotTitle(list.get(0), list.get(1));
        return new PlotTitleFlag(plotTitle);
    }

    @Override
    public PlotTitleFlag merge(@NonNull PlotTitle plotTitle) {
        if (((PlotTitle)this.getValue()).title().isEmpty() && ((PlotTitle)this.getValue()).subtitle().isEmpty()) {
            return new PlotTitleFlag(plotTitle);
        }
        if (((PlotTitle)this.getValue()).subtitle().isEmpty()) {
            return new PlotTitleFlag(new PlotTitle(((PlotTitle)this.getValue()).title(), plotTitle.subtitle()));
        }
        if (((PlotTitle)this.getValue()).title().isEmpty()) {
            return new PlotTitleFlag(new PlotTitle(plotTitle.title(), ((PlotTitle)this.getValue()).subtitle()));
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.getValue() == PlotTitle.CONFIGURED) {
            return "CONFIGURED";
        }
        return "\"" + ((PlotTitle)this.getValue()).title() + "\" \"" + ((PlotTitle)this.getValue()).subtitle() + "\"";
    }

    @Override
    public boolean isValuedPermission() {
        return false;
    }

    @Override
    public String getExample() {
        return "\"A Title\" \"The subtitle\"";
    }

    @Override
    protected PlotTitleFlag flagOf(@NonNull PlotTitle plotTitle) {
        return new PlotTitleFlag(plotTitle);
    }
}

