/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class NumberFlag<N extends Number, F extends PlotFlag<N, F>>
extends PlotFlag<N, F> {
    protected final N minimum;
    protected final N maximum;

    protected NumberFlag(@NonNull N n, N n2, N n3, @NonNull Caption caption, @NonNull Caption caption2) {
        super(n, caption, caption2);
        if (((Comparable)n3).compareTo(n2) < 0) {
            throw new IllegalArgumentException("Maximum may not be less than minimum:" + n3 + " < " + n2);
        }
        this.minimum = n2;
        this.maximum = n3;
    }

    @Override
    public F parse(@NonNull String string) {
        N n = this.parseNumber(string);
        if (((Comparable)n).compareTo(this.minimum) < 0 || ((Comparable)n).compareTo(this.maximum) > 0) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_integer"), new TagResolver[0]);
        }
        return this.flagOf(n);
    }

    protected abstract @NonNull N parseNumber(String var1);
}

