/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class TimedFlag<T, F extends PlotFlag<Timed<T>, F>>
extends PlotFlag<Timed<T>, F> {
    private final T defaultValue;

    protected TimedFlag(@NonNull Timed<T> timed, T t, @NonNull Caption caption) {
        super(timed, TranslatableCaption.of("flags.flag_category_intervals"), caption);
        this.defaultValue = t;
    }

    @Override
    public F parse(@NonNull String string) {
        int n;
        String[] stringArray = string.split(" ", 2);
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_integer"), new TagResolver[0]);
        }
        if (n < 1) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_integer"), new TagResolver[0]);
        }
        if (stringArray.length == 1) {
            return this.flagOf(new Timed<T>(n, this.defaultValue));
        }
        T t = this.parseValue(stringArray[1]);
        return this.flagOf(new Timed<T>(n, t));
    }

    @Override
    public F merge(@NonNull Timed<T> timed) {
        return this.flagOf(new Timed(((Timed)this.getValue()).interval + timed.interval, this.mergeValue(timed.value)));
    }

    protected abstract T parseValue(String var1);

    protected abstract T mergeValue(T var1);

    @Override
    public String toString() {
        return ((Timed)this.getValue()).toString();
    }

    public record Timed<T>(int interval, T value) {
        @Override
        public String toString() {
            return String.format("%d %s", this.interval, this.value);
        }
    }
}

