/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotWorld;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.ScatteredPlotWorld;
import com.plotsquared.core.plot.world.StandardPlotWorld;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.google.Singleton;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class DefaultPlotAreaManager
implements PlotAreaManager {
    final PlotArea[] noPlotAreas = new PlotArea[0];
    private final Map<String, PlotWorld> plotWorlds = new ConcurrentHashMap<String, PlotWorld>();

    @Override
    public @NonNull PlotArea[] getAllPlotAreas() {
        HashSet<PlotArea> hashSet = new HashSet<PlotArea>();
        for (PlotWorld plotWorld : this.plotWorlds.values()) {
            hashSet.addAll(plotWorld.getAreas());
        }
        return hashSet.toArray(new PlotArea[0]);
    }

    @Override
    public @Nullable PlotArea getApplicablePlotArea(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        PlotWorld plotWorld = this.plotWorlds.get(location.getWorldName());
        if (plotWorld == null) {
            return null;
        }
        return plotWorld.getArea(location);
    }

    @Override
    public void addPlotArea(@NonNull PlotArea plotArea) {
        PlotWorld plotWorld = this.plotWorlds.get(plotArea.getWorldName());
        if (plotWorld != null) {
            if (plotWorld instanceof StandardPlotWorld && plotWorld.getAreas().isEmpty()) {
                this.plotWorlds.remove(plotArea.getWorldName());
            } else {
                plotWorld.addArea(plotArea);
                return;
            }
        }
        if (plotArea.getType() != PlotAreaType.PARTIAL) {
            plotWorld = new StandardPlotWorld(plotArea.getWorldName(), plotArea);
        } else {
            plotWorld = new ScatteredPlotWorld(plotArea.getWorldName());
            plotWorld.addArea(plotArea);
        }
        this.plotWorlds.put(plotArea.getWorldName(), plotWorld);
    }

    @Override
    public void removePlotArea(@NonNull PlotArea plotArea) {
        PlotWorld plotWorld = this.plotWorlds.get(plotArea.getWorldName());
        if (plotWorld == null) {
            return;
        }
        if (plotWorld instanceof StandardPlotWorld) {
            this.plotWorlds.remove(plotWorld.getWorld());
        } else {
            plotWorld.removeArea(plotArea);
            if (plotWorld.getAreas().isEmpty()) {
                this.plotWorlds.remove(plotWorld.getWorld());
            }
        }
    }

    @Override
    public PlotArea getPlotArea(@NonNull String string, @Nullable String string2) {
        PlotWorld plotWorld = this.plotWorlds.get(string);
        if (plotWorld == null) {
            return null;
        }
        ArrayList<PlotArea> arrayList = new ArrayList<PlotArea>(plotWorld.getAreas());
        if (arrayList.size() == 1) {
            return (PlotArea)arrayList.get(0);
        }
        if (string2 == null) {
            return null;
        }
        for (PlotArea plotArea : arrayList) {
            if (!StringMan.isEqual(string2, plotArea.getId())) continue;
            return plotArea;
        }
        return null;
    }

    @Override
    public @Nullable PlotArea getPlotArea(@NonNull Location location) {
        return this.getApplicablePlotArea(location);
    }

    @Override
    public @NonNull PlotArea[] getPlotAreas(@NonNull String string, @Nullable CuboidRegion cuboidRegion) {
        PlotWorld plotWorld = this.plotWorlds.get(string);
        if (plotWorld == null) {
            return this.noPlotAreas;
        }
        if (cuboidRegion == null) {
            return plotWorld.getAreas().toArray(new PlotArea[0]);
        }
        return plotWorld.getAreasInRegion(cuboidRegion).toArray(new PlotArea[0]);
    }

    @Override
    public boolean addWorld(@NonNull String string) {
        PlotWorld plotWorld = this.plotWorlds.get(string);
        if (plotWorld != null) {
            return false;
        }
        plotWorld = new StandardPlotWorld(string, null);
        this.plotWorlds.put(string, plotWorld);
        return true;
    }

    @Override
    public void removeWorld(@NonNull String string) {
        this.plotWorlds.remove(string);
    }

    @Override
    public @NonNull String[] getAllWorlds() {
        return this.plotWorlds.keySet().toArray(new String[0]);
    }
}

