/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotWorld;
import com.plotsquared.core.util.PlotAreaConverter;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.prtree.PRTree;
import com.plotsquared.prtree.SimpleMBR;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ScatteredPlotWorld
extends PlotWorld {
    private static final PlotAreaConverter MBR_CONVERTER = new PlotAreaConverter();
    private static final int BRANCH_FACTOR = 30;
    private final List<PlotArea> areas = new LinkedList<PlotArea>();
    private final Object treeLock = new Object();
    private PRTree<PlotArea> areaTree;

    public ScatteredPlotWorld(@NonNull String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable PlotArea getArea(@NonNull Location location) {
        if (this.areas.isEmpty()) {
            return null;
        }
        Object object = this.treeLock;
        synchronized (object) {
            for (PlotArea plotArea : this.areaTree.find(location.toMBR())) {
                if (!plotArea.contains(location)) continue;
                return plotArea;
            }
        }
        return null;
    }

    @Override
    public @NonNull Collection<PlotArea> getAreas() {
        return Collections.unmodifiableCollection(this.areas);
    }

    @Override
    public void addArea(@NonNull PlotArea plotArea) {
        this.areas.add(plotArea);
        this.buildTree();
    }

    @Override
    public void removeArea(@NonNull PlotArea plotArea) {
        this.areas.remove(plotArea);
        this.buildTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Collection<PlotArea> getAreasInRegion(@NonNull CuboidRegion cuboidRegion) {
        if (this.areas.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = this.treeLock;
        synchronized (object) {
            LinkedList<PlotArea> linkedList = new LinkedList<PlotArea>();
            BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
            BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
            SimpleMBR simpleMBR = new SimpleMBR(blockVector3.getX(), blockVector32.getX(), blockVector3.getY(), blockVector32.getY(), blockVector3.getZ(), blockVector32.getZ());
            for (PlotArea plotArea : this.areaTree.find(simpleMBR)) {
                if (!RegionUtil.intersects(plotArea.getRegion(), cuboidRegion)) continue;
                linkedList.add(plotArea);
            }
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTree() {
        Object object = this.treeLock;
        synchronized (object) {
            this.areaTree = new PRTree<PlotArea>(MBR_CONVERTER, 30);
            this.areaTree.load(this.areas);
        }
    }
}

