/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.collection.ArrayUtil;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.DefaultPlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class SinglePlotAreaManager
extends DefaultPlotAreaManager {
    private final SinglePlotArea[] array;
    private SinglePlotArea area;
    private PlotArea[] all;

    @Inject
    public SinglePlotAreaManager(@NonNull EventDispatcher eventDispatcher, @NonNull PlotListener plotListener, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @NonNull GlobalBlockQueue globalBlockQueue) {
        this.area = new SinglePlotArea(this, eventDispatcher, plotListener, yamlConfiguration, globalBlockQueue);
        this.array = new SinglePlotArea[]{this.area};
        this.all = new PlotArea[]{this.area};
        SetupUtils.generators.put("PlotSquared:single", new SingleWorldGenerator(this).specify("CheckingPlotSquaredGenerator"));
    }

    public SinglePlotArea getArea() {
        return this.area;
    }

    public void setArea(@NonNull SinglePlotArea singlePlotArea) {
        this.area = singlePlotArea;
        this.array[0] = singlePlotArea;
        this.all = ArrayUtil.concatAll(super.getAllPlotAreas(), new PlotArea[][]{this.array});
    }

    public boolean isWorld(@NonNull String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length == 1 && cArray[0] == '*') {
            return true;
        }
        int n = 0;
        block6: for (char c : cArray) {
            switch (n) {
                case 0: {
                    n = 1;
                    if (c == '-') continue block6;
                }
                case 1: {
                    if (c > '/' && c < ':') continue block6;
                    if (c == '_') {
                        n = 2;
                        continue block6;
                    }
                    return false;
                }
                case 2: {
                    n = 3;
                    if (c == '-') continue block6;
                }
                case 3: {
                    if (c > '/' && c < ':') continue block6;
                    return false;
                }
            }
        }
        return n == 3;
    }

    @Override
    public @Nullable PlotArea getApplicablePlotArea(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        String string = location.getWorldName();
        return this.isWorld(string) || string.equals("*") || super.getAllPlotAreas().length == 0 ? this.area : super.getApplicablePlotArea(location);
    }

    @Override
    public @Nullable PlotArea getPlotArea(@NonNull String string, @NonNull String string2) {
        PlotArea plotArea = super.getPlotArea(string, string2);
        if (plotArea != null) {
            return plotArea;
        }
        return this.isWorld(string) || string.equals("*") ? this.area : super.getPlotArea(string, string2);
    }

    @Override
    public @Nullable PlotArea getPlotArea(@NonNull Location location) {
        PlotArea plotArea = super.getPlotArea(location);
        if (plotArea != null) {
            return plotArea;
        }
        return this.isWorld(location.getWorldName()) || location.getWorldName().equals("*") ? this.area : null;
    }

    @Override
    public @NonNull PlotArea[] getPlotAreas(@NonNull String string, @NonNull CuboidRegion cuboidRegion) {
        PlotArea[] plotAreaArray = super.getPlotAreas(string, cuboidRegion);
        if (plotAreaArray != null && plotAreaArray.length != 0) {
            return plotAreaArray;
        }
        return this.isWorld(string) || string.equals("*") ? this.array : (this.all.length == 0 ? this.noPlotAreas : plotAreaArray);
    }

    @Override
    public @NonNull PlotArea[] getAllPlotAreas() {
        return this.all;
    }

    @Override
    public @NonNull String[] getAllWorlds() {
        return super.getAllWorlds();
    }

    @Override
    public void addPlotArea(@NonNull PlotArea plotArea) {
        if (plotArea == this.area) {
            return;
        }
        super.addPlotArea(plotArea);
        this.all = ArrayUtil.concatAll(super.getAllPlotAreas(), new PlotArea[][]{this.array});
    }

    @Override
    public void removePlotArea(@NonNull PlotArea plotArea) {
        if (plotArea == this.area) {
            throw new UnsupportedOperationException("Cannot remove base area!");
        }
        super.removePlotArea(plotArea);
    }

    @Override
    public boolean addWorld(@NonNull String string) {
        return super.addWorld(string);
    }

    @Override
    public void removeWorld(@NonNull String string) {
        super.removeWorld(string);
    }
}

