/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.LightingMode;
import com.plotsquared.core.queue.LocalChunk;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.core.util.PatternUtil;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BasicQueueCoordinator
extends QueueCoordinator {
    private final World world;
    private final ConcurrentHashMap<BlockVector2, LocalChunk> blockChunks = new ConcurrentHashMap();
    private final List<BlockVector2> readRegion = new ArrayList<BlockVector2>();
    private final List<ProgressSubscriber> progressSubscribers = new ArrayList<ProgressSubscriber>();
    private LocalChunk lastWrappedChunk;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;
    private boolean settingBiomes = false;
    private boolean disableBiomes = false;
    private boolean settingTiles = false;
    private boolean regen = false;
    private int[] regenStart;
    private int[] regenEnd;
    private CuboidRegion regenRegion = null;
    private Consumer<BlockVector2> consumer = null;
    private boolean unloadAfter = true;
    private Runnable whenDone = null;
    private SideEffectSet sideEffectSet = null;
    private @Nullable LightingMode lightingMode = LightingMode.valueOf(Settings.QUEUE.LIGHTING_MODE);

    public BasicQueueCoordinator(@NonNull World world) {
        super(world);
        this.world = world;
    }

    @Override
    public abstract BlockState getBlock(int var1, int var2, int var3);

    @Override
    public final @NonNull World getWorld() {
        return this.world;
    }

    @Override
    public final int size() {
        return this.blockChunks.size() + this.readRegion.size();
    }

    @Override
    public final void setModified(long l) {
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        return this.setBlock(n, n2, n3, PatternUtil.apply(pattern, n, n2, n3));
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        if (n2 > this.world.getMaxY() || n2 < this.world.getMinY()) {
            return false;
        }
        LocalChunk localChunk = this.getChunk(n >> 4, n3 >> 4);
        localChunk.setBlock(n & 0xF, n2, n3 & 0xF, baseBlock);
        return true;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BlockState blockState) {
        return this.setBlock(n, n2, n3, blockState.toBaseBlock());
    }

    @Override
    public boolean setBiome(int n, int n2, @NonNull BiomeType biomeType) {
        if (this.disableBiomes) {
            return false;
        }
        LocalChunk localChunk = this.getChunk(n >> 4, n2 >> 4);
        for (int i = this.world.getMinY(); i <= this.world.getMaxY(); ++i) {
            localChunk.setBiome(n & 0xF, i, n2 & 0xF, biomeType);
        }
        this.settingBiomes = true;
        return true;
    }

    @Override
    public final boolean setBiome(int n, int n2, int n3, @NonNull BiomeType biomeType) {
        if (this.disableBiomes) {
            return false;
        }
        LocalChunk localChunk = this.getChunk(n >> 4, n3 >> 4);
        localChunk.setBiome(n & 0xF, n2, n3 & 0xF, biomeType);
        this.settingBiomes = true;
        return true;
    }

    @Override
    public boolean isSettingBiomes() {
        return this.settingBiomes;
    }

    @Override
    public void setBiomesEnabled(boolean bl) {
        this.settingBiomes = bl;
        this.disableBiomes = true;
    }

    @Override
    public boolean setTile(int n, int n2, int n3, @NonNull CompoundTag compoundTag) {
        LocalChunk localChunk = this.getChunk(n >> 4, n3 >> 4);
        localChunk.setTile(n, n2, n3, compoundTag);
        this.settingTiles = true;
        return true;
    }

    @Override
    public boolean isSettingTiles() {
        return this.settingTiles;
    }

    @Override
    public boolean setEntity(@NonNull Entity entity) {
        if (entity.getState() == null || entity.getState().getType() == EntityTypes.PLAYER) {
            return false;
        }
        com.sk89q.worldedit.util.Location location = entity.getLocation();
        LocalChunk localChunk = this.getChunk(location.getBlockX() >> 4, location.getBlockZ() >> 4);
        localChunk.setEntity(location, entity.getState());
        return true;
    }

    @Override
    public @NonNull List<BlockVector2> getReadChunks() {
        return this.readRegion;
    }

    @Override
    public void addReadChunk(@NonNull BlockVector2 blockVector2) {
        this.readRegion.add(blockVector2);
    }

    @Override
    public void addReadChunks(@NonNull Set<BlockVector2> set) {
        this.readRegion.addAll(set);
    }

    @Override
    public CuboidRegion getRegenRegion() {
        return this.regenRegion != null ? this.regenRegion.clone() : null;
    }

    @Override
    public void setRegenRegion(@NonNull CuboidRegion cuboidRegion) {
        this.regenRegion = cuboidRegion;
    }

    @Override
    public void regenChunk(int n, int n2) {
        this.regen = true;
        if (this.regenStart == null) {
            this.regenStart = new int[]{n, n2};
            this.regenEnd = new int[]{n, n2};
            return;
        }
        if (n < this.regenStart[0]) {
            this.regenStart[0] = n;
        }
        if (n2 < this.regenStart[1]) {
            this.regenStart[1] = n2;
        }
        if (n > this.regenEnd[0]) {
            this.regenEnd[0] = n;
        }
        if (n2 > this.regenEnd[1]) {
            this.regenEnd[1] = n2;
        }
    }

    @Override
    public boolean isUnloadAfter() {
        return this.unloadAfter;
    }

    @Override
    public void setUnloadAfter(boolean bl) {
        this.unloadAfter = bl;
    }

    public int[] getRegenStart() {
        return this.regenStart;
    }

    public int[] getRegenEnd() {
        return this.regenEnd;
    }

    public boolean isRegen() {
        return this.regen;
    }

    public @NonNull ConcurrentHashMap<BlockVector2, LocalChunk> getBlockChunks() {
        return this.blockChunks;
    }

    public final void setChunk(@NonNull LocalChunk localChunk) {
        this.blockChunks.put(BlockVector2.at((int)localChunk.getX(), (int)localChunk.getZ()), localChunk);
    }

    @Override
    public final @Nullable Consumer<BlockVector2> getChunkConsumer() {
        return this.consumer;
    }

    @Override
    public final void setChunkConsumer(@NonNull Consumer<BlockVector2> consumer) {
        this.consumer = consumer;
    }

    public final List<ProgressSubscriber> getProgressSubscribers() {
        return this.progressSubscribers;
    }

    @Override
    public final void addProgressSubscriber(@NonNull ProgressSubscriber progressSubscriber) {
        this.progressSubscribers.add(progressSubscriber);
    }

    @Override
    public final @NonNull LightingMode getLightingMode() {
        if (this.lightingMode == null) {
            return LightingMode.valueOf(Settings.QUEUE.LIGHTING_MODE);
        }
        return this.lightingMode;
    }

    @Override
    public final void setLightingMode(@Nullable LightingMode lightingMode) {
        this.lightingMode = lightingMode;
    }

    @Override
    public Runnable getCompleteTask() {
        return this.whenDone;
    }

    @Override
    public void setCompleteTask(Runnable runnable) {
        this.whenDone = runnable;
    }

    @Override
    public SideEffectSet getSideEffectSet() {
        return this.sideEffectSet;
    }

    @Override
    public void setSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public void setBiomeCuboid(@NonNull Location location, @NonNull Location location2, @NonNull BiomeType biomeType) {
        if (this.disableBiomes) {
            return;
        }
        super.setBiomeCuboid(location, location2, biomeType);
    }

    private @NonNull LocalChunk getChunk(int n, int n2) {
        if (n != this.lastX || n2 != this.lastZ) {
            this.lastX = n;
            this.lastZ = n2;
            BlockVector2 blockVector2 = BlockVector2.at((int)n, (int)n2);
            this.lastWrappedChunk = this.blockChunks.get(blockVector2);
            if (this.lastWrappedChunk == null) {
                this.lastWrappedChunk = new LocalChunk(this, n, n2);
                LocalChunk localChunk = this.blockChunks.put(blockVector2, this.lastWrappedChunk);
                if (localChunk == null) {
                    return this.lastWrappedChunk;
                }
                this.lastWrappedChunk = localChunk;
            }
        }
        return this.lastWrappedChunk;
    }
}

