/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.google.common.base.Preconditions;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.inject.factory.ChunkCoordinatorFactory;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.ChunkCoordinator;
import com.plotsquared.core.queue.subscriber.ProgressSubscriber;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChunkCoordinatorBuilder {
    private final List<BlockVector2> requestedChunks = new LinkedList<BlockVector2>();
    private final List<ProgressSubscriber> progressSubscribers = new ArrayList<ProgressSubscriber>();
    private final ChunkCoordinatorFactory chunkCoordinatorFactory;
    private Consumer<Throwable> throwableConsumer = Throwable::printStackTrace;
    private World world;
    private Consumer<BlockVector2> chunkConsumer;
    private Runnable whenDone = () -> {};
    private long maxIterationTime = Settings.QUEUE.MAX_ITERATION_TIME;
    private int initialBatchSize = Settings.QUEUE.INITIAL_BATCH_SIZE;
    private boolean unloadAfter = true;
    private boolean forceSync = false;

    @Inject
    public ChunkCoordinatorBuilder(@NonNull ChunkCoordinatorFactory chunkCoordinatorFactory) {
        this.chunkCoordinatorFactory = chunkCoordinatorFactory;
    }

    public @NonNull ChunkCoordinatorBuilder inWorld(@NonNull World world) {
        this.world = (World)Preconditions.checkNotNull((Object)world, (Object)"World may not be null");
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withChunk(@NonNull BlockVector2 blockVector2) {
        this.requestedChunks.add((BlockVector2)Preconditions.checkNotNull((Object)blockVector2, (Object)"Chunk location may not be null"));
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withChunks(@NonNull Collection<BlockVector2> collection) {
        collection.forEach(this::withChunk);
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withRegion(@NonNull Location location, @NonNull Location location2) {
        int n = location.getX();
        int n2 = location.getZ();
        int n3 = location2.getX();
        int n4 = location2.getZ();
        int n5 = n >> 4;
        int n6 = n2 >> 4;
        int n7 = n3 >> 4;
        int n8 = n4 >> 4;
        ArrayList<BlockVector2> arrayList = new ArrayList<BlockVector2>();
        for (int i = n5; i <= n7; ++i) {
            for (int j = n6; j <= n8; ++j) {
                arrayList.add(BlockVector2.at((int)i, (int)j));
            }
        }
        arrayList.forEach(this::withChunk);
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withConsumer(@NonNull Consumer<BlockVector2> consumer) {
        this.chunkConsumer = (Consumer)Preconditions.checkNotNull(consumer, (Object)"Chunk consumer may not be null");
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withFinalAction(@Nullable Runnable runnable) {
        if (runnable == null) {
            return this;
        }
        this.whenDone = runnable;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withMaxIterationTime(long l) {
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (Object)"Max iteration time must be positive");
        this.maxIterationTime = l;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withInitialBatchSize(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"Initial batch size must be positive");
        this.initialBatchSize = n;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withThrowableConsumer(@NonNull Consumer<Throwable> consumer) {
        this.throwableConsumer = (Consumer)Preconditions.checkNotNull(consumer, (Object)"Throwable consumer may not be null");
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder unloadAfter(boolean bl) {
        this.unloadAfter = bl;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder forceSync(boolean bl) {
        this.forceSync = bl;
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withProgressSubscriber(ProgressSubscriber progressSubscriber) {
        this.progressSubscribers.add(progressSubscriber);
        return this;
    }

    public @NonNull ChunkCoordinatorBuilder withProgressSubscribers(Collection<ProgressSubscriber> collection) {
        this.progressSubscribers.addAll(collection);
        return this;
    }

    public @NonNull ChunkCoordinator build() {
        Preconditions.checkNotNull((Object)this.world, (Object)"No world was supplied");
        Preconditions.checkNotNull(this.chunkConsumer, (Object)"No chunk consumer was supplied");
        Preconditions.checkNotNull((Object)this.whenDone, (Object)"No final action was supplied");
        Preconditions.checkNotNull(this.throwableConsumer, (Object)"No throwable consumer was supplied");
        return this.chunkCoordinatorFactory.create(this.maxIterationTime, this.initialBatchSize, this.chunkConsumer, this.world, this.requestedChunks, this.whenDone, this.throwableConsumer, this.unloadAfter, this.progressSubscribers, this.forceSync);
    }
}

