/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ZeroedDelegateScopedQueueCoordinator
extends DelegateQueueCoordinator {
    private final Location min;
    private final Location max;
    private final int minX;
    private final int minZ;
    private final int maxX;
    private final int maxZ;
    private final int dx;
    private final int dz;

    public ZeroedDelegateScopedQueueCoordinator(@Nullable QueueCoordinator queueCoordinator, @NonNull Location location, @NonNull Location location2) {
        super(queueCoordinator);
        this.min = location;
        this.max = location2;
        this.minX = location.getX();
        this.minZ = location.getZ();
        this.maxX = location2.getX();
        this.maxZ = location2.getZ();
        this.dx = this.maxX - this.minX;
        this.dz = this.maxZ - this.minZ;
    }

    @Override
    public boolean setBiome(int n, int n2, @NonNull BiomeType biomeType) {
        return n >= 0 && n <= this.dx && n2 >= 0 && n2 <= this.dz && super.setBiome(n + this.minX, n2 + this.minZ, biomeType);
    }

    @Override
    public boolean setBiome(int n, int n2, int n3, @NonNull BiomeType biomeType) {
        return n >= 0 && n <= this.dx && n3 >= 0 && n3 <= this.dz && super.setBiome(n + this.minX, n2, n3 + this.minZ, biomeType);
    }

    public void fillBiome(BiomeType biomeType) {
        for (int i = this.min.getY(); i <= this.max.getY(); ++i) {
            for (int j = 0; j <= this.dx; ++j) {
                for (int k = 0; k < this.dz; ++k) {
                    this.setBiome(j, i, k, biomeType);
                }
            }
        }
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        return n >= 0 && n <= this.dx && n3 >= 0 && n3 <= this.dz && super.setBlock(n + this.minX, n2, n3 + this.minZ, baseBlock);
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BlockState blockState) {
        return n >= 0 && n <= this.dx && n3 >= 0 && n3 <= this.dz && super.setBlock(n + this.minX, n2, n3 + this.minZ, blockState);
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        return n >= 0 && n <= this.dx && n3 >= 0 && n3 <= this.dz && super.setBlock(n + this.minX, n2, n3 + this.minZ, pattern);
    }

    @Override
    public boolean setTile(int n, int n2, int n3, @NonNull CompoundTag compoundTag) {
        return n >= 0 && n <= this.dx && n3 >= 0 && n3 <= this.dz && super.setTile(n + this.minX, n2, n3 + this.minZ, compoundTag);
    }

    public @NonNull Location getMin() {
        return this.min;
    }

    public @NonNull Location getMax() {
        return this.max;
    }
}

