/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.services;

import com.plotsquared.core.services.ExecutionOrder;
import com.plotsquared.core.services.annotations.Order;
import com.plotsquared.core.services.types.Service;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class AnnotatedMethodService<Context, Result>
implements Service<Context, Result> {
    private final ExecutionOrder executionOrder;
    private final MethodHandle methodHandle;
    private final Method method;
    private final Object instance;

    AnnotatedMethodService(@NonNull Object object, @NonNull Method method) {
        ExecutionOrder executionOrder = ExecutionOrder.SOON;
        try {
            Order order = method.getAnnotation(Order.class);
            if (order != null) {
                executionOrder = order.value();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.instance = object;
        this.executionOrder = executionOrder;
        method.setAccessible(true);
        this.methodHandle = MethodHandles.lookup().unreflect(method);
        this.method = method;
    }

    @Override
    public @Nullable Result handle(@NonNull Context Context2) {
        try {
            return (Result)this.methodHandle.invoke(this.instance, Context2);
        }
        catch (Throwable throwable) {
            new IllegalStateException(String.format("Failed to call method service implementation '%s' in class '%s'", this.method.getName(), this.instance.getClass().getCanonicalName()), throwable).printStackTrace();
            return null;
        }
    }

    @Override
    public @NonNull ExecutionOrder order() {
        return this.executionOrder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AnnotatedMethodService annotatedMethodService = (AnnotatedMethodService)object;
        return Objects.equals(this.methodHandle, annotatedMethodService.methodHandle);
    }

    public int hashCode() {
        return Objects.hash(this.methodHandle);
    }
}

