/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ChunkedRequestContext<@NonNull Context, @NonNull Result> {
    private final Object lock = new Object();
    private final List<@NonNull Context> requests;
    private final Map<@NonNull Context, @NonNull Result> results;

    protected ChunkedRequestContext(@NonNull Collection<Context> collection) {
        this.requests = new ArrayList<Context>(collection);
        this.results = new HashMap<Context, Result>(collection.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final @NonNull Map<@NonNull Context, @NonNull Result> getAvailableResults() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final @NonNull List<@NonNull Context> getRemaining() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeResult(@NonNull Context Context2, @NonNull Result Result2) {
        Object object = this.lock;
        synchronized (object) {
            this.results.put(Context2, Result2);
            this.requests.remove(Context2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.requests.isEmpty();
        }
    }
}

