/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.services;

import com.plotsquared.core.geantyref.TypeToken;
import com.plotsquared.core.services.AnnotatedMethodServiceFactory;
import com.plotsquared.core.services.ServicePipelineBuilder;
import com.plotsquared.core.services.ServicePump;
import com.plotsquared.core.services.ServiceRepository;
import com.plotsquared.core.services.types.Service;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ServicePipeline {
    private final Object lock = new Object();
    private final Map<Type, ServiceRepository<?, ?>> repositories = new HashMap();
    private final Executor executor;

    ServicePipeline(@NonNull Executor executor) {
        this.executor = executor;
    }

    public static @NonNull ServicePipelineBuilder builder() {
        return new ServicePipelineBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Context, Result> @NonNull ServicePipeline registerServiceType(@NonNull TypeToken<? extends Service<@NonNull Context, @NonNull Result>> typeToken, @NonNull Service<@NonNull Context, @NonNull Result> service) {
        Object object = this.lock;
        synchronized (object) {
            if (this.repositories.containsKey(typeToken.getType())) {
                throw new IllegalArgumentException(String.format("Service of type '%s' has already been registered", typeToken.getType().getTypeName()));
            }
            ServiceRepository serviceRepository = new ServiceRepository(typeToken);
            serviceRepository.registerImplementation(service, Collections.emptyList());
            this.repositories.put(typeToken.getType(), serviceRepository);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> @NonNull ServicePipeline registerMethods(@NonNull T t) {
        Object object = this.lock;
        synchronized (object) {
            Map<Service<?, ?>, TypeToken<Service<?, ?>>> map = AnnotatedMethodServiceFactory.INSTANCE.lookupServices(t);
            for (Map.Entry<Service<?, ?>, TypeToken<Service<?, ?>>> entry : map.entrySet()) {
                TypeToken<Service<?, ?>> typeToken = entry.getValue();
                ServiceRepository<?, ?> serviceRepository = this.repositories.get(typeToken.getType());
                if (serviceRepository == null) {
                    throw new IllegalArgumentException(String.format("No service registered for type '%s'", typeToken.getType().getTypeName()));
                }
                serviceRepository.registerImplementation(entry.getKey(), Collections.emptyList());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Context, Result> ServicePipeline registerServiceImplementation(@NonNull TypeToken<? extends Service<Context, Result>> typeToken, @NonNull Service<Context, Result> service, @NonNull Collection<Predicate<Context>> collection) {
        Object object = this.lock;
        synchronized (object) {
            ServiceRepository<Context, Result> serviceRepository = this.getRepository(typeToken);
            serviceRepository.registerImplementation(service, collection);
        }
        return this;
    }

    public <Context, Result> ServicePipeline registerServiceImplementation(@NonNull Class<? extends Service<Context, Result>> clazz, @NonNull Service<Context, Result> service, @NonNull Collection<Predicate<Context>> collection) {
        return this.registerServiceImplementation(TypeToken.get(clazz), service, collection);
    }

    public <Context> @NonNull ServicePump<Context> pump(@NonNull Context Context2) {
        return new ServicePump<Context>(this, Context2);
    }

    <Context, Result> @NonNull ServiceRepository<Context, Result> getRepository(@NonNull TypeToken<? extends Service<Context, Result>> typeToken) {
        ServiceRepository<?, ?> serviceRepository = this.repositories.get(typeToken.getType());
        if (serviceRepository == null) {
            throw new IllegalArgumentException(String.format("No service registered for type '%s'", typeToken.getType().getTypeName()));
        }
        return serviceRepository;
    }

    public @NonNull Collection<Type> getRecognizedTypes() {
        return Collections.unmodifiableCollection(this.repositories.keySet());
    }

    public <Context, Result, S extends Service<Context, Result>> @NonNull Collection<TypeToken<? extends S>> getImplementations(@NonNull TypeToken<S> typeToken) {
        ServiceRepository<Context, Result> serviceRepository = this.getRepository(typeToken);
        LinkedList linkedList = new LinkedList();
        LinkedList<ServiceRepository.ServiceWrapper<Service<Context, Result>>> linkedList2 = serviceRepository.getQueue();
        linkedList2.sort(null);
        Collections.reverse(linkedList2);
        for (ServiceRepository.ServiceWrapper serviceWrapper : linkedList2) {
            linkedList.add(TypeToken.get(serviceWrapper.getImplementation().getClass()));
        }
        return Collections.unmodifiableList(linkedList);
    }

    @NonNull Executor getExecutor() {
        return this.executor;
    }
}

