/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.setup;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.setup.SetupStep;
import com.plotsquared.core.util.TabCompletions;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SettingsNodeStep
implements SetupStep {
    private final ConfigurationNode configurationNode;
    private final int id;
    private final SetupStep next;

    public SettingsNodeStep(ConfigurationNode configurationNode, int n, SettingsNodesWrapper settingsNodesWrapper) {
        this.configurationNode = configurationNode;
        this.id = n;
        this.next = settingsNodesWrapper.settingsNodes().length > n + 1 ? new SettingsNodeStep(settingsNodesWrapper.settingsNodes()[n + 1], n + 1, settingsNodesWrapper) : settingsNodesWrapper.afterwards();
    }

    @Override
    public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
        if (this.configurationNode.isValid(string)) {
            this.configurationNode.setValue(string);
        }
        return this.next;
    }

    @Override
    public @NonNull Collection<String> getSuggestions() {
        return this.configurationNode.getSuggestions();
    }

    @Override
    public @Nullable String getDefaultValue() {
        return String.valueOf(this.configurationNode.getDefaultValue());
    }

    @Override
    public void announce(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_step"), TagResolver.builder().tag("step", Tag.inserting(Component.text(this.getId() + 1))).tag("description", Tag.inserting(this.configurationNode.getDescription().toComponent(plotPlayer))).tag("type", Tag.inserting(Component.text(this.configurationNode.getType().getType()))).tag("value", Tag.inserting(Component.text(this.configurationNode.getDefaultValue().toString()))).build());
    }

    @Override
    public Collection<Command> createSuggestions(PlotPlayer<?> plotPlayer, String string) {
        switch (this.configurationNode.getType().getType()) {
            case "BLOCK_BUCKET": {
                return TabCompletions.completePatterns(string);
            }
            case "INTEGER": {
                if (this.getDefaultValue() != null && this.getDefaultValue().startsWith(string)) {
                    return Collections.singletonList(new Command(null, false, this.getDefaultValue(), "", RequiredType.NONE, null){});
                }
            }
            case "BOOLEAN": {
                return TabCompletions.completeBoolean(string);
            }
        }
        return Collections.emptyList();
    }

    public ConfigurationNode getConfigurationNode() {
        return this.configurationNode;
    }

    public int getId() {
        return this.id;
    }
}

