/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.util.MathMan;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlockUtil {
    private static final ParserContext PARSER_CONTEXT = new ParserContext();
    private static final InputParser<BaseBlock> PARSER;

    private BlockUtil() {
    }

    public static @Nullable BlockState get(int n) {
        return LegacyMapper.getInstance().getBlockFromLegacy(n);
    }

    public static @Nullable BlockState get(int n, int n2) {
        return LegacyMapper.getInstance().getBlockFromLegacy(n, n2);
    }

    public static @Nullable BlockState get(@NonNull String string) {
        BaseBlock baseBlock;
        if (string.length() == 1 && string.charAt(0) == '*') {
            return FuzzyBlockState.builder().type(BlockTypes.AIR).build();
        }
        String string2 = string.toLowerCase();
        BlockType blockType = BlockTypes.get((String)string2);
        if (blockType != null) {
            return blockType.getDefaultState();
        }
        if (Character.isDigit(string2.charAt(0)) && MathMan.isInteger((baseBlock = string2.split(":"))[0])) {
            if (((BaseBlock)baseBlock).length == 2) {
                if (MathMan.isInteger((String)baseBlock[1])) {
                    return BlockUtil.get(Integer.parseInt((String)baseBlock[0]), Integer.parseInt((String)baseBlock[1]));
                }
            } else {
                return BlockUtil.get(Integer.parseInt((String)baseBlock[0]));
            }
        }
        try {
            baseBlock = (BaseBlock)PARSER.parseFromInput(string2, PARSER_CONTEXT);
            return baseBlock.toImmutableState();
        }
        catch (InputParseException inputParseException) {
            return null;
        }
    }

    static {
        PARSER_CONTEXT.setRestricted(false);
        PARSER_CONTEXT.setPreferringWildcard(false);
        PARSER_CONTEXT.setTryLegacy(true);
        PARSER = (InputParser)WorldEdit.getInstance().getBlockFactory().getParsers().get(0);
    }
}

