/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EntityUtil {
    private EntityUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static int capNumeral(@NonNull String string) {
        return switch (string) {
            case "mob-cap" -> 3;
            case "hostile-cap" -> 2;
            case "animal-cap" -> 1;
            case "vehicle-cap" -> 4;
            case "misc-cap" -> 5;
            default -> 0;
        };
    }

    public static boolean checkEntity(Plot plot, PlotFlag<Integer, ?> ... plotFlagArray) {
        int n;
        if (Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot)) {
            return true;
        }
        int[] nArray = null;
        for (PlotFlag<Integer, ?> plotFlag : plotFlagArray) {
            n = EntityUtil.capNumeral(plotFlag.getName());
            int n2 = (Integer)plot.getFlag(plotFlag);
            if (n2 == Integer.MAX_VALUE) continue;
            if (n2 == 0) {
                return true;
            }
            if (nArray == null) {
                nArray = plot.countEntities();
            }
            if (nArray[n] < n2) continue;
            plot.setMeta("EntityCount", nArray);
            plot.setMeta("EntityCountTime", System.currentTimeMillis());
            plot.debug("Prevented spawning of mob because it would exceed " + plotFlag.getName());
            return true;
        }
        if (nArray != null) {
            for (PlotFlag<Integer, ?> plotFlag : plotFlagArray) {
                int n3 = n = EntityUtil.capNumeral(plotFlag.getName());
                nArray[n3] = nArray[n3] + 1;
            }
            plot.setMeta("EntityCount", nArray);
            plot.setMeta("EntityCountTime", System.currentTimeMillis());
        }
        return false;
    }
}

