/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.common.eventbus.EventBus;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.informative.DoNotUse;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlayerAutoPlotEvent;
import com.plotsquared.core.events.PlayerAutoPlotsChosenEvent;
import com.plotsquared.core.events.PlayerClaimPlotEvent;
import com.plotsquared.core.events.PlayerEnterPlotEvent;
import com.plotsquared.core.events.PlayerLeavePlotEvent;
import com.plotsquared.core.events.PlayerPlotDeniedEvent;
import com.plotsquared.core.events.PlayerPlotHelperEvent;
import com.plotsquared.core.events.PlayerPlotTrustedEvent;
import com.plotsquared.core.events.PlayerTeleportToPlotEvent;
import com.plotsquared.core.events.PlotAutoMergeEvent;
import com.plotsquared.core.events.PlotChangeOwnerEvent;
import com.plotsquared.core.events.PlotClaimedNotifyEvent;
import com.plotsquared.core.events.PlotClearEvent;
import com.plotsquared.core.events.PlotComponentSetEvent;
import com.plotsquared.core.events.PlotDeleteEvent;
import com.plotsquared.core.events.PlotDoneEvent;
import com.plotsquared.core.events.PlotEvent;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotFlagRemoveEvent;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.PlotRateEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.RemoveRoadEntityEvent;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.events.post.PostPlayerAutoPlotEvent;
import com.plotsquared.core.events.post.PostPlotChangeOwnerEvent;
import com.plotsquared.core.events.post.PostPlotDeleteEvent;
import com.plotsquared.core.events.post.PostPlotMergeEvent;
import com.plotsquared.core.events.post.PostPlotUnlinkEvent;
import com.plotsquared.core.listener.PlayerBlockEventType;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.Rating;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DeviceInteractFlag;
import com.plotsquared.core.plot.flag.implementations.MiscPlaceFlag;
import com.plotsquared.core.plot.flag.implementations.MobPlaceFlag;
import com.plotsquared.core.plot.flag.implementations.PlaceFlag;
import com.plotsquared.core.plot.flag.implementations.UseFlag;
import com.plotsquared.core.plot.flag.implementations.VehiclePlaceFlag;
import com.plotsquared.core.plot.flag.types.BlockTypeWrapper;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.util.task.TaskManager;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@DoNotUse
public class EventDispatcher {
    private final EventBus eventBus = new EventBus("PlotSquaredEvents");
    private final List<Object> listeners = new ArrayList<Object>();
    private final WorldEdit worldEdit;

    public EventDispatcher(@Nullable WorldEdit worldEdit) {
        this.worldEdit = worldEdit;
    }

    public void registerListener(Object object) {
        this.eventBus.register(object);
        this.listeners.add(object);
    }

    public void unregisterListener(Object object) {
        this.eventBus.unregister(object);
        this.listeners.remove(object);
    }

    public void unregisterAll() {
        for (Object object : this.listeners) {
            this.eventBus.unregister(object);
        }
    }

    public void callGenericEvent(@NonNull Object object) {
        this.eventBus.post(object);
    }

    public void callEvent(@NonNull PlotEvent plotEvent) {
        this.eventBus.post((Object)plotEvent);
    }

    public PlayerClaimPlotEvent callClaim(PlotPlayer<?> plotPlayer, Plot plot, String string) {
        PlayerClaimPlotEvent playerClaimPlotEvent = new PlayerClaimPlotEvent(plotPlayer, plot, string);
        this.callEvent(playerClaimPlotEvent);
        return playerClaimPlotEvent;
    }

    public PlayerAutoPlotEvent callAuto(PlotPlayer<?> plotPlayer, PlotArea plotArea, String string, int n, int n2) {
        PlayerAutoPlotEvent playerAutoPlotEvent = new PlayerAutoPlotEvent(plotPlayer, plotArea, string, n, n2);
        this.callEvent(playerAutoPlotEvent);
        return playerAutoPlotEvent;
    }

    public PostPlayerAutoPlotEvent callPostAuto(PlotPlayer<?> plotPlayer, Plot plot) {
        PostPlayerAutoPlotEvent postPlayerAutoPlotEvent = new PostPlayerAutoPlotEvent(plotPlayer, plot);
        this.callEvent(postPlayerAutoPlotEvent);
        return postPlayerAutoPlotEvent;
    }

    public PlayerAutoPlotsChosenEvent callAutoPlotsChosen(PlotPlayer<?> plotPlayer, List<Plot> list) {
        PlayerAutoPlotsChosenEvent playerAutoPlotsChosenEvent = new PlayerAutoPlotsChosenEvent(plotPlayer, list);
        this.callEvent(playerAutoPlotsChosenEvent);
        return playerAutoPlotsChosenEvent;
    }

    public PlotClaimedNotifyEvent callPlotClaimedNotify(Plot plot, boolean bl) {
        PlotClaimedNotifyEvent plotClaimedNotifyEvent = new PlotClaimedNotifyEvent(plot, bl);
        this.callEvent(plotClaimedNotifyEvent);
        return plotClaimedNotifyEvent;
    }

    public PlayerTeleportToPlotEvent callTeleport(PlotPlayer<?> plotPlayer, Location location, Plot plot, TeleportCause teleportCause) {
        PlayerTeleportToPlotEvent playerTeleportToPlotEvent = new PlayerTeleportToPlotEvent(plotPlayer, location, plot, teleportCause);
        this.callEvent(playerTeleportToPlotEvent);
        return playerTeleportToPlotEvent;
    }

    public PlotComponentSetEvent callComponentSet(Plot plot, String string, Pattern pattern) {
        PlotComponentSetEvent plotComponentSetEvent = new PlotComponentSetEvent(plot, string, pattern);
        this.callEvent(plotComponentSetEvent);
        return plotComponentSetEvent;
    }

    public PlotClearEvent callClear(Plot plot) {
        PlotClearEvent plotClearEvent = new PlotClearEvent(plot);
        this.callEvent(plotClearEvent);
        return plotClearEvent;
    }

    public PlotDeleteEvent callDelete(Plot plot) {
        PlotDeleteEvent plotDeleteEvent = new PlotDeleteEvent(plot);
        this.callEvent(plotDeleteEvent);
        return plotDeleteEvent;
    }

    public PostPlotDeleteEvent callPostDelete(Plot plot) {
        PostPlotDeleteEvent postPlotDeleteEvent = new PostPlotDeleteEvent(plot);
        this.callEvent(postPlotDeleteEvent);
        return postPlotDeleteEvent;
    }

    public PlotFlagAddEvent callFlagAdd(PlotFlag<?, ?> plotFlag, Plot plot) {
        PlotFlagAddEvent plotFlagAddEvent = new PlotFlagAddEvent(plotFlag, plot);
        this.callEvent(plotFlagAddEvent);
        return plotFlagAddEvent;
    }

    public PlotFlagRemoveEvent callFlagRemove(PlotFlag<?, ?> plotFlag, Plot plot) {
        PlotFlagRemoveEvent plotFlagRemoveEvent = new PlotFlagRemoveEvent(plotFlag, plot);
        this.callEvent(plotFlagRemoveEvent);
        return plotFlagRemoveEvent;
    }

    public PlotMergeEvent callMerge(Plot plot, Direction direction, int n, PlotPlayer<?> plotPlayer) {
        PlotMergeEvent plotMergeEvent = new PlotMergeEvent(plot.getWorldName(), plot, direction, n, plotPlayer);
        this.callEvent(plotMergeEvent);
        return plotMergeEvent;
    }

    public PostPlotMergeEvent callPostMerge(PlotPlayer<?> plotPlayer, Plot plot) {
        PostPlotMergeEvent postPlotMergeEvent = new PostPlotMergeEvent(plotPlayer, plot);
        this.callEvent(postPlotMergeEvent);
        return postPlotMergeEvent;
    }

    public PlotAutoMergeEvent callAutoMerge(Plot plot, List<PlotId> list) {
        PlotAutoMergeEvent plotAutoMergeEvent = new PlotAutoMergeEvent(plot.getWorldName(), plot, list);
        this.callEvent(plotAutoMergeEvent);
        return plotAutoMergeEvent;
    }

    public PlotUnlinkEvent callUnlink(PlotArea plotArea, Plot plot, boolean bl, boolean bl2, PlotUnlinkEvent.REASON rEASON) {
        PlotUnlinkEvent plotUnlinkEvent = new PlotUnlinkEvent(plotArea, plot, bl, bl2, rEASON);
        this.callEvent(plotUnlinkEvent);
        return plotUnlinkEvent;
    }

    public PostPlotUnlinkEvent callPostUnlink(Plot plot, PlotUnlinkEvent.REASON rEASON) {
        PostPlotUnlinkEvent postPlotUnlinkEvent = new PostPlotUnlinkEvent(plot, rEASON);
        this.callEvent(postPlotUnlinkEvent);
        return postPlotUnlinkEvent;
    }

    public PlayerEnterPlotEvent callEntry(PlotPlayer<?> plotPlayer, Plot plot) {
        PlayerEnterPlotEvent playerEnterPlotEvent = new PlayerEnterPlotEvent(plotPlayer, plot);
        this.callEvent(playerEnterPlotEvent);
        return playerEnterPlotEvent;
    }

    public PlayerLeavePlotEvent callLeave(PlotPlayer<?> plotPlayer, Plot plot) {
        PlayerLeavePlotEvent playerLeavePlotEvent = new PlayerLeavePlotEvent(plotPlayer, plot);
        this.callEvent(playerLeavePlotEvent);
        return playerLeavePlotEvent;
    }

    public PlayerPlotDeniedEvent callDenied(PlotPlayer<?> plotPlayer, Plot plot, UUID uUID, boolean bl) {
        PlayerPlotDeniedEvent playerPlotDeniedEvent = new PlayerPlotDeniedEvent(plotPlayer, plot, uUID, bl);
        this.callEvent(playerPlotDeniedEvent);
        return playerPlotDeniedEvent;
    }

    public PlayerPlotTrustedEvent callTrusted(PlotPlayer<?> plotPlayer, Plot plot, UUID uUID, boolean bl) {
        PlayerPlotTrustedEvent playerPlotTrustedEvent = new PlayerPlotTrustedEvent(plotPlayer, plot, uUID, bl);
        this.callEvent(playerPlotTrustedEvent);
        return playerPlotTrustedEvent;
    }

    public PlayerPlotHelperEvent callMember(PlotPlayer<?> plotPlayer, Plot plot, UUID uUID, boolean bl) {
        PlayerPlotHelperEvent playerPlotHelperEvent = new PlayerPlotHelperEvent(plotPlayer, plot, uUID, bl);
        this.callEvent(playerPlotHelperEvent);
        return playerPlotHelperEvent;
    }

    public PlotChangeOwnerEvent callOwnerChange(PlotPlayer<?> plotPlayer, Plot plot, UUID uUID, UUID uUID2, boolean bl) {
        PlotChangeOwnerEvent plotChangeOwnerEvent = new PlotChangeOwnerEvent(plotPlayer, plot, uUID, uUID2, bl);
        this.callEvent(plotChangeOwnerEvent);
        return plotChangeOwnerEvent;
    }

    public PostPlotChangeOwnerEvent callPostOwnerChange(PlotPlayer<?> plotPlayer, Plot plot, @Nullable UUID uUID) {
        PostPlotChangeOwnerEvent postPlotChangeOwnerEvent = new PostPlotChangeOwnerEvent(plotPlayer, plot, uUID);
        this.callEvent(postPlotChangeOwnerEvent);
        return postPlotChangeOwnerEvent;
    }

    public PlotRateEvent callRating(PlotPlayer<?> plotPlayer, Plot plot, Rating rating) {
        PlotRateEvent plotRateEvent = new PlotRateEvent(plotPlayer, rating, plot);
        this.eventBus.post((Object)plotRateEvent);
        return plotRateEvent;
    }

    public PlotDoneEvent callDone(Plot plot) {
        PlotDoneEvent plotDoneEvent = new PlotDoneEvent(plot);
        this.callEvent(plotDoneEvent);
        return plotDoneEvent;
    }

    public RemoveRoadEntityEvent callRemoveRoadEntity(Entity entity) {
        RemoveRoadEntityEvent removeRoadEntityEvent = new RemoveRoadEntityEvent(entity);
        this.eventBus.post((Object)removeRoadEntityEvent);
        return removeRoadEntityEvent;
    }

    public void doJoinTask(PlotPlayer<?> plotPlayer) {
        if (plotPlayer == null) {
            return;
        }
        if (PlotSquared.platform().expireManager() != null) {
            PlotSquared.platform().expireManager().handleJoin(plotPlayer);
        }
        if (this.worldEdit != null && plotPlayer.getAttribute("worldedit")) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("worldedit.worldedit_bypassed"), new TagResolver[0]);
        }
        Plot plot = plotPlayer.getCurrentPlot();
        if (Settings.Teleport.ON_LOGIN && plot != null && !(plot.getArea() instanceof SinglePlotArea)) {
            TaskManager.runTask(() -> plot.teleportPlayer(plotPlayer, TeleportCause.LOGIN, bl -> {}));
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_road"), new TagResolver[0]);
        }
    }

    public void doRespawnTask(PlotPlayer<?> plotPlayer) {
        Plot plot = plotPlayer.getCurrentPlot();
        if (Settings.Teleport.ON_DEATH && plot != null) {
            TaskManager.runTask(() -> plot.teleportPlayer(plotPlayer, TeleportCause.DEATH, bl -> {}));
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("teleport.teleported_to_road"), new TagResolver[0]);
        }
    }

    public boolean checkPlayerBlockEvent(PlotPlayer<?> plotPlayer, @NonNull PlayerBlockEventType playerBlockEventType, Location location, BlockType blockType, boolean bl) {
        PlotArea plotArea = location.getPlotArea();
        assert (plotArea != null);
        if (!plotArea.buildRangeContainsY(location.getY()) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("height.height_limit"), TagResolver.builder().tag("minheight", Tag.inserting(Component.text(plotArea.getMinBuildHeight()))).tag("maxheight", Tag.inserting(Component.text(plotArea.getMaxBuildHeight()))).build());
            return false;
        }
        Plot plot = plotArea.getPlot(location);
        if (plot != null && plot.isAdded(plotPlayer.getUUID())) {
            return true;
        }
        switch (playerBlockEventType) {
            case TELEPORT_OBJECT: {
                return false;
            }
            case READ: {
                return true;
            }
            case INTERACT_BLOCK: {
                if (plot == null) {
                    List list = (List)plotArea.getRoadFlag(UseFlag.class);
                    for (BlockTypeWrapper blockTypeWrapper : list) {
                        if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                        return true;
                    }
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), bl);
                }
                if (!plot.hasOwner()) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), bl);
                }
                List list = (List)plot.getFlag(UseFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : list) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                if (plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false)) {
                    return true;
                }
                if (bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.flag_tutorial_usage"), TagResolver.resolver("flag", Tag.inserting(PlaceFlag.getFlagNameComponent(UseFlag.class))));
                }
                return false;
            }
            case TRIGGER_PHYSICAL: {
                if (plot == null) {
                    List list = (List)plotArea.getRoadFlag(UseFlag.class);
                    for (BlockTypeWrapper blockTypeWrapper : list) {
                        if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                        return true;
                    }
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), false);
                }
                if (!plot.hasOwner()) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), false);
                }
                if (((Boolean)plot.getFlag(DeviceInteractFlag.class)).booleanValue()) {
                    return true;
                }
                List list = (List)plot.getFlag(UseFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : list) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false);
            }
            case SPAWN_MOB: {
                if (plot == null) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), bl);
                }
                if (!plot.hasOwner()) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), bl);
                }
                if (((Boolean)plot.getFlag(MobPlaceFlag.class)).booleanValue()) {
                    return true;
                }
                List list = (List)plot.getFlag(PlaceFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : list) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                if (plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false)) {
                    return true;
                }
                if (bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.flag_tutorial_usage"), TagResolver.resolver("flag", Tag.inserting(PlotFlag.getFlagNameComponent(MobPlaceFlag.class).append(Component.text("/")).append(PlotFlag.getFlagNameComponent(PlaceFlag.class)))));
                }
                return false;
            }
            case PLACE_MISC: {
                if (plot == null) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), bl);
                }
                if (!plot.hasOwner()) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), bl);
                }
                if (((Boolean)plot.getFlag(MiscPlaceFlag.class)).booleanValue()) {
                    return true;
                }
                List list = (List)plot.getFlag(PlaceFlag.class);
                for (BlockTypeWrapper blockTypeWrapper : list) {
                    if (!blockTypeWrapper.accepts(BlockTypes.AIR) && !blockTypeWrapper.accepts(blockType)) continue;
                    return true;
                }
                if (plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_OTHER.toString(), false)) {
                    return true;
                }
                if (bl) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("commandconfig.flag_tutorial_usage"), TagResolver.resolver("flag", Tag.inserting(PlotFlag.getFlagNameComponent(MiscPlaceFlag.class).append(Component.text("/")).append(PlotFlag.getFlagNameComponent(PlaceFlag.class)))));
                }
                return false;
            }
            case PLACE_VEHICLE: {
                if (plot == null) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_ROAD.toString(), bl);
                }
                if (!plot.hasOwner()) {
                    return plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_INTERACT_UNOWNED.toString(), bl);
                }
                return (Boolean)plot.getFlag(VehiclePlaceFlag.class);
            }
        }
        return true;
    }
}

