/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.common.base.Preconditions;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PatternUtil {
    public static BaseBlock apply(@NonNull Pattern pattern, int n, int n2, int n3) {
        Preconditions.checkNotNull((Object)pattern, (Object)"Pattern may not be null");
        if (pattern instanceof BlockPattern || pattern instanceof BlockState || pattern instanceof BlockType || pattern instanceof BaseBlock) {
            return pattern.applyBlock(BlockVector3.ZERO);
        }
        return pattern.applyBlock(BlockVector3.at((int)n, (int)n2, (int)n3));
    }

    public static Pattern parse(PlotPlayer<?> plotPlayer, String string) {
        return PatternUtil.parse(plotPlayer, string, true);
    }

    public static List<String> getSuggestions(String string) {
        try {
            return WorldEdit.getInstance().getPatternFactory().getSuggestions(string);
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    public static Pattern parse(PlotPlayer<?> plotPlayer, String string, boolean bl) {
        ParserContext parserContext = new ParserContext();
        if (plotPlayer != null) {
            Actor actor = plotPlayer.toActor();
            parserContext.setActor(actor);
            if (actor instanceof Player) {
                parserContext.setWorld(((Player)actor).getWorld());
            }
            parserContext.setSession(WorldEdit.getInstance().getSessionManager().get((SessionOwner)actor));
            parserContext.setRestricted(true);
        } else {
            parserContext.setRestricted(false);
        }
        parserContext.setPreferringWildcard(false);
        parserContext.setTryLegacy(bl);
        try {
            return (Pattern)WorldEdit.getInstance().getPatternFactory().parseFromInput(string, parserContext);
        }
        catch (InputParseException inputParseException) {
            throw new Command.CommandException(TranslatableCaption.of("invalid.not_valid_block"), TagResolver.resolver("value", Tag.inserting(Component.text(inputParseException.getMessage()))));
        }
    }

    public static boolean isAir(Pattern pattern) {
        if (pattern instanceof BlockPattern) {
            return ((BlockPattern)pattern).getBlock().getBlockType().getMaterial().isAir();
        }
        if (pattern instanceof BlockState) {
            return ((BlockState)pattern).getBlockType().getMaterial().isAir();
        }
        if (pattern instanceof BlockType) {
            return ((BlockType)pattern).getMaterial().isAir();
        }
        if (pattern instanceof BaseBlock) {
            return ((BaseBlock)pattern).getBlockType().getMaterial().isAir();
        }
        return false;
    }
}

