/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static String preClassB = "org.bukkit.craftbukkit";
    private static String preClassM = "net.minecraft.server";

    public ReflectionUtils(String string) {
        if (string != null) {
            preClassB = preClassB + "." + string;
            preClassM = preClassM + "." + string;
        }
    }

    public static Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static <T> Class<? extends T> getClass(String string, Class<T> clazz) {
        try {
            return Class.forName(string).asSubclass(clazz);
        }
        catch (ClassCastException | ClassNotFoundException exception) {
            return null;
        }
    }

    public static RefClass getRefClass(String string) {
        string = string.replace("{cb}", preClassB).replace("{nms}", preClassM).replace("{nm}", "net.minecraft");
        return ReflectionUtils.getRefClass(Class.forName(string));
    }

    public static RefClass getRefClass(Class<?> clazz) {
        return new RefClass(clazz);
    }

    public static class RefClass {
        private final Class<?> clazz;

        private RefClass(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getRealClass() {
            return this.clazz;
        }

        public RefMethod getMethod(String string, Object ... objectArray) {
            Class[] classArray = new Class[objectArray.length];
            int n = 0;
            for (Object object : objectArray) {
                classArray[n++] = object instanceof Class ? (Class)object : (object instanceof RefClass ? ((RefClass)object).getRealClass() : object.getClass());
            }
            try {
                return new RefMethod(this.clazz.getMethod(string, classArray));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return new RefMethod(this.clazz.getDeclaredMethod(string, classArray));
            }
        }

        public RefField getField(String string) {
            try {
                return new RefField(this.clazz.getField(string));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return new RefField(this.clazz.getDeclaredField(string));
            }
        }
    }

    public static class RefField {
        private final Field field;

        private RefField(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        public Field getRealField() {
            return this.field;
        }

        public RefExecutor of(Object object) {
            return new RefExecutor(object);
        }

        public class RefExecutor {
            final Object e;

            public RefExecutor(Object object) {
                this.e = object;
            }

            public void set(Object object) {
                try {
                    RefField.this.field.set(this.e, object);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }

            public Object get() {
                try {
                    return RefField.this.field.get(this.e);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public static class RefConstructor {
        private final Constructor<?> constructor;

        private RefConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
            constructor.setAccessible(true);
        }

        public Object create(Object ... objectArray) {
            return this.constructor.newInstance(objectArray);
        }
    }

    public static class RefMethod {
        private final Method method;

        private RefMethod(Method method) {
            this.method = method;
            method.setAccessible(true);
        }

        public Method getRealMethod() {
            return this.method;
        }

        public RefExecutor of(Object object) {
            return new RefExecutor(object);
        }

        public class RefExecutor {
            final Object e;

            public RefExecutor(Object object) {
                this.e = object;
            }

            public Object call(Object ... objectArray) {
                try {
                    return RefMethod.this.method.invoke(this.e, objectArray);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }
}

