/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PatternUtil;
import com.plotsquared.core.uuid.UUIDMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TabCompletions {
    private static final Cache<String, List<String>> cachedCompletionValues = CacheBuilder.newBuilder().expireAfterWrite((long)Settings.Tab_Completions.CACHE_EXPIRATION, TimeUnit.SECONDS).build();
    private static final Command booleanTrueCompletion = new Command(null, false, "true", "", RequiredType.NONE, null){};
    private static final Command booleanFalseCompletion = new Command(null, false, "false", "", RequiredType.NONE, null){};

    private TabCompletions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static @NonNull List<Command> completePlayers(@NonNull PlotPlayer<?> plotPlayer, @NonNull String string, @NonNull List<String> list) {
        return TabCompletions.completePlayers("players", plotPlayer, string, list, uUID -> true);
    }

    public static @NonNull List<Command> completeAddedPlayers(@NonNull PlotPlayer<?> plotPlayer, @NonNull Plot plot, @NonNull String string, @NonNull List<String> list) {
        return TabCompletions.completePlayers("added" + plot, plotPlayer, string, list, uUID -> plot.getMembers().contains(uUID) || plot.getTrusted().contains(uUID) || plot.getDenied().contains(uUID));
    }

    public static @NonNull List<Command> completePlayersInPlot(@NonNull Plot plot, @NonNull String string, @NonNull List<String> list) {
        ArrayList<String> arrayList = (ArrayList<String>)cachedCompletionValues.getIfPresent((Object)("inPlot" + plot));
        if (arrayList == null) {
            List<PlotPlayer<?>> list2 = plot.getPlayersInPlot();
            arrayList = new ArrayList<String>(list2.size());
            for (PlotPlayer<?> plotPlayer : list2) {
                arrayList.add(plotPlayer.getName());
            }
            cachedCompletionValues.put((Object)("inPlot" + plot), arrayList);
        }
        return TabCompletions.filterCached((Collection<String>)arrayList, string, list);
    }

    public static @NonNull List<Command> completePatterns(@NonNull String string3) {
        return PatternUtil.getSuggestions(string3.trim()).stream().map(string -> string.toLowerCase(Locale.ENGLISH).replace("minecraft:", "")).filter(string2 -> string2.startsWith(string3.toLowerCase(Locale.ENGLISH))).map(string -> new Command(null, false, (String)string, "", RequiredType.NONE, null){}).collect(Collectors.toList());
    }

    public static @NonNull List<Command> completeBoolean(@NonNull String string) {
        if (string.isEmpty()) {
            return Arrays.asList(booleanTrueCompletion, booleanFalseCompletion);
        }
        if ("true".startsWith(string)) {
            return Collections.singletonList(booleanTrueCompletion);
        }
        if ("false".startsWith(string)) {
            return Collections.singletonList(booleanFalseCompletion);
        }
        return Collections.emptyList();
    }

    public static @NonNull List<Command> completeNumbers(@NonNull String string, int n, int n2) {
        int n3;
        if (string.isEmpty() || string.length() > n2 || !MathMan.isInteger(string)) {
            return Collections.emptyList();
        }
        try {
            n3 = Integer.parseInt(string) * 10;
        }
        catch (NumberFormatException numberFormatException) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = n3; i <= n2 && n3 - i + n > 0; ++i) {
            arrayList.add(String.valueOf(i));
        }
        return TabCompletions.asCompletions(arrayList.toArray(new String[0]));
    }

    public static @NonNull List<Command> completeAreas(@NonNull String string) {
        ArrayList<4> arrayList = new ArrayList<4>();
        for (PlotArea plotArea : PlotSquared.get().getPlotAreaManager().getAllPlotAreas()) {
            Object object = plotArea.getWorldName();
            if (plotArea.getId() != null) {
                object = (String)object + ";" + plotArea.getId();
            }
            if (!((String)object).toLowerCase().startsWith(string.toLowerCase())) continue;
            arrayList.add(new Command(null, false, (String)object, "", RequiredType.NONE, null){});
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static @NonNull List<Command> asCompletions(String ... stringArray) {
        ArrayList<5> arrayList = new ArrayList<5>();
        for (String string : stringArray) {
            arrayList.add(new Command(null, false, string, "", RequiredType.NONE, null){});
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static List<Command> completePlayers(@NonNull String string, @NonNull PlotPlayer<?> plotPlayer, @NonNull String string2, @NonNull List<String> list, @NonNull Predicate<UUID> predicate) {
        ArrayList<String> arrayList;
        if (Settings.Enabled_Components.EXTENDED_USERNAME_COMPLETION) {
            arrayList = (ArrayList<String>)cachedCompletionValues.getIfPresent((Object)string);
            if (arrayList == null) {
                Collection<UUIDMapping> collection = PlotSquared.get().getImpromptuUUIDPipeline().getAllImmediately();
                arrayList = new ArrayList(collection.size());
                for (UUIDMapping uUIDMapping : collection) {
                    if (!predicate.test(uUIDMapping.uuid())) continue;
                    arrayList.add(uUIDMapping.username());
                }
                cachedCompletionValues.put((Object)string, arrayList);
            }
        } else {
            Collection<PlotPlayer<?>> collection = PlotSquared.platform().playerManager().getPlayers();
            arrayList = new ArrayList<String>(collection.size());
            for (PlotPlayer<?> plotPlayer2 : collection) {
                if (!predicate.test(plotPlayer2.getUUID()) || plotPlayer != null && !plotPlayer.canSee(plotPlayer2)) continue;
                arrayList.add(plotPlayer2.getName());
            }
        }
        return TabCompletions.filterCached(arrayList, string2, list);
    }

    private static List<Command> filterCached(Collection<String> collection, String string3, List<String> list) {
        String string4 = string3.toLowerCase(Locale.ENGLISH);
        return collection.stream().filter(string2 -> string2.toLowerCase(Locale.ENGLISH).startsWith(string4)).filter(string -> !list.contains(string)).map(string -> new Command(null, false, (String)string, "", RequiredType.NONE, CommandCategory.INFO){}).limit(200L).collect(Collectors.toList());
    }
}

