/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.util.MathMan;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static @NonNull String secToTime(@NonNegative long l) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (l >= 33868800L) {
            n = (int)(l / 33868800L);
            l -= (long)n * 33868800L;
            stringBuilder.append(n).append("y ");
        }
        if (l >= 604800L) {
            n = (int)(l / 604800L);
            l -= (long)n * 604800L;
            stringBuilder.append(n).append("w ");
        }
        if (l >= 86400L) {
            n = (int)(l / 86400L);
            l -= (long)n * 86400L;
            stringBuilder.append(n).append("d ");
        }
        if (l >= 3600L) {
            n = (int)(l / 3600L);
            l -= (long)n * 3600L;
            stringBuilder.append(n).append("h ");
        }
        if (l >= 60L) {
            n = (int)(l / 60L);
            l -= (long)n * 60L;
            stringBuilder.append(n).append("m ");
        }
        if (stringBuilder.length() == 0 || l > 0L) {
            stringBuilder.append(l).append("s ");
        }
        return stringBuilder.toString().trim();
    }

    public static @NonNegative long timeToSec(@NonNull String string) {
        if (MathMan.isInteger(string)) {
            return Long.parseLong(string);
        }
        if ((string = string.toLowerCase().trim().toLowerCase()).equalsIgnoreCase("false")) {
            return 0L;
        }
        String[] stringArray = string.split(" ");
        long l = 0L;
        for (String string2 : stringArray) {
            String string3;
            int n = Integer.parseInt(string2.replaceAll("[^\\d]", ""));
            switch (string3 = string2.replaceAll("[^a-z]", "")) {
                case "week": 
                case "weeks": 
                case "wks": 
                case "w": {
                    l += (long)(604800 * n);
                }
                case "days": 
                case "day": 
                case "d": {
                    l += (long)(86400 * n);
                }
                case "hour": 
                case "hr": 
                case "hrs": 
                case "hours": 
                case "h": {
                    l += (long)(3600 * n);
                }
                case "minutes": 
                case "minute": 
                case "mins": 
                case "min": 
                case "m": {
                    l += (long)(60 * n);
                }
                case "seconds": 
                case "second": 
                case "secs": 
                case "sec": 
                case "s": {
                    l += (long)n;
                }
            }
        }
        return l;
    }
}

