/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.plot.flag.implementations.NoWorldeditFlag;
import com.plotsquared.core.util.RegionUtil;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class WEManager {
    private static final BlockVector3 MIN = BlockVector3.at((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
    private static final BlockVector3 MAX = BlockVector3.at((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);

    public static boolean maskContains(Set<CuboidRegion> set, int n, int n2, int n3) {
        for (CuboidRegion cuboidRegion : set) {
            if (!RegionUtil.contains(cuboidRegion, n, n2, n3)) continue;
            return true;
        }
        return false;
    }

    public static boolean maskContains(Set<CuboidRegion> set, int n, int n2) {
        for (CuboidRegion cuboidRegion : set) {
            if (!RegionUtil.contains(cuboidRegion, n, n2)) continue;
            return true;
        }
        return false;
    }

    public static HashSet<CuboidRegion> getMask(PlotPlayer<?> plotPlayer) {
        HashSet<CuboidRegion> hashSet = new HashSet<CuboidRegion>();
        UUID uUID = plotPlayer.getUUID();
        Location location = plotPlayer.getLocation();
        String string = location.getWorldName();
        if (!PlotSquared.get().getPlotAreaManager().hasPlotArea(string)) {
            hashSet.add(new CuboidRegion(MIN, MAX));
            return hashSet;
        }
        PlotArea plotArea = plotPlayer.getApplicablePlotArea();
        if (plotArea == null) {
            return hashSet;
        }
        boolean bl = plotPlayer.hasPermission("plots.worldedit.member");
        Plot plot = plotPlayer.getCurrentPlot();
        try (MetaDataAccess<Plot> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_WORLD_EDIT_REGION_PLOT);){
            if (plot == null) {
                plot = metaDataAccess.get().orElse(null);
            }
            if (!(plot == null || Settings.Done.RESTRICT_BUILDING && DoneFlag.isDone(plot) || !(bl && plot.isAdded(uUID) || !bl && plot.isOwner(uUID)) && !plot.getTrusted().contains(uUID) || ((Boolean)plot.getFlag(NoWorldeditFlag.class)).booleanValue())) {
                for (CuboidRegion cuboidRegion : plot.getRegions()) {
                    BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint().withY(plotArea.getMinBuildHeight());
                    BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint().withY(plotArea.getMaxBuildHeight() - 1);
                    CuboidRegion cuboidRegion2 = new CuboidRegion(blockVector3, blockVector32);
                    hashSet.add(cuboidRegion2);
                }
                metaDataAccess.set(plot);
            }
        }
        return hashSet;
    }
}

