/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.task.RunnableVal;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.entity.EntityType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class WorldUtil {
    public static void setBiome(String string, CuboidRegion cuboidRegion, BiomeType biomeType) {
        PlotSquared.platform().worldUtil().setBiomes(string, cuboidRegion, biomeType);
    }

    public abstract boolean isWorld(@NonNull String var1);

    @Deprecated
    public abstract @NonNull String[] getSignSynchronous(@NonNull Location var1);

    public abstract @NonNull Location getSpawn(@NonNull String var1);

    public abstract void setSpawn(@NonNull Location var1);

    public abstract void saveWorld(@NonNull String var1);

    public abstract  @NonNull StringComparison.ComparisonResult getClosestBlock(@NonNull String var1);

    public abstract void setSign(@NonNull Location var1, @NonNull Caption[] var2, TagResolver ... var3);

    public abstract void getBiome(@NonNull String var1, int var2, int var3, @NonNull Consumer<BiomeType> var4);

    @Deprecated
    public abstract @NonNull BiomeType getBiomeSynchronous(@NonNull String var1, int var2, int var3);

    public abstract void getBlock(@NonNull Location var1, @NonNull Consumer<BlockState> var2);

    @Deprecated
    public abstract @NonNull BlockState getBlockSynchronous(@NonNull Location var1);

    public abstract void getHighestBlock(@NonNull String var1, int var2, int var3, @NonNull IntConsumer var4);

    @Deprecated
    public abstract @NonNegative int getHighestBlockSynchronous(@NonNull String var1, int var2, int var3);

    public void setBiomes(@NonNull String string, @NonNull CuboidRegion cuboidRegion, @NonNull BiomeType biomeType) {
        World world = this.getWeWorld(string);
        cuboidRegion.forEach(blockVector3 -> world.setBiome(blockVector3, biomeType));
    }

    public abstract @NonNull World getWeWorld(@NonNull String var1);

    public abstract void refreshChunk(int var1, int var2, String var3);

    @Deprecated(forRemoval=true, since="6.11.0")
    public void upload(final @NonNull Plot plot, @Nullable UUID uUID, @Nullable String string, @NonNull RunnableVal<URL> runnableVal) {
        plot.getHome(location -> SchematicHandler.upload(uUID, string, "zip", new RunnableVal<OutputStream>(){

            @Override
            public void run(OutputStream outputStream) {
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
                    Object object;
                    NBTInputStream nBTInputStream;
                    Object object3;
                    File file = WorldUtil.this.getDat(plot.getWorldName());
                    Location location3 = WorldUtil.this.getSpawn(plot.getWorldName());
                    if (file != null) {
                        object3 = new ZipEntry("world" + File.separator + file.getName());
                        zipOutputStream.putNextEntry((ZipEntry)object3);
                        nBTInputStream = new NBTInputStream((InputStream)new GZIPInputStream(new FileInputStream(file)));
                        try {
                            Map map = ((CompoundTag)nBTInputStream.readNamedTag().getTag()).getValue();
                            HashMap<String, Object> object4 = new HashMap<String, Object>();
                            for (Map.Entry entry : map.entrySet()) {
                                if (!((String)entry.getKey()).equals("Data")) {
                                    object4.put((String)entry.getKey(), (Tag)entry.getValue());
                                    continue;
                                }
                                HashMap<String, IntTag> hashMap = new HashMap<String, IntTag>(((CompoundTag)entry.getValue()).getValue());
                                hashMap.put("SpawnX", new IntTag(location.getX()));
                                hashMap.put("SpawnY", new IntTag(location.getY()));
                                hashMap.put("SpawnZ", new IntTag(location.getZ()));
                                object4.put("Data", new CompoundTag(hashMap));
                            }
                            object = new ByteArrayOutputStream();
                            try {
                                try (NBTOutputStream nBTOutputStream = new NBTOutputStream((OutputStream)new GZIPOutputStream((OutputStream)object, true));){
                                    nBTOutputStream.writeNamedTag("Schematic????", (Tag)new CompoundTag(object4));
                                }
                                zipOutputStream.write(((ByteArrayOutputStream)object).toByteArray());
                            }
                            finally {
                                ((ByteArrayOutputStream)object).close();
                            }
                        }
                        finally {
                            nBTInputStream.close();
                        }
                    }
                    WorldUtil.this.setSpawn(location3);
                    object3 = new byte[1024];
                    nBTInputStream = new HashSet();
                    for (Plot plot2 : plot.getConnectedPlots()) {
                        object = plot2.getBottomAbs();
                        Location location2 = plot2.getTopAbs();
                        int n = ((Location)object).getX() >> 9;
                        int n2 = ((Location)object).getZ() >> 9;
                        int n3 = location2.getX() >> 9;
                        int n4 = location2.getZ() >> 9;
                        Set<BlockVector2> set = WorldUtil.this.getChunkChunks(((Location)object).getWorldName());
                        for (BlockVector2 blockVector2 : set) {
                            File file2;
                            if (blockVector2.getX() < n || blockVector2.getX() > n3 || blockVector2.getZ() < n2 || blockVector2.getZ() > n4 || nBTInputStream.contains(blockVector2) || (file2 = WorldUtil.this.getMcr(plot.getWorldName(), blockVector2.getX(), blockVector2.getZ())) == null) continue;
                            String string = file2.getName();
                            ZipEntry zipEntry = new ZipEntry("world" + File.separator + "region" + File.separator + string);
                            zipOutputStream.putNextEntry(zipEntry);
                            nBTInputStream.add(blockVector2);
                            try (FileInputStream fileInputStream = new FileInputStream(file2);){
                                int n5;
                                while ((n5 = fileInputStream.read((byte[])object3)) > 0) {
                                    zipOutputStream.write((byte[])object3, 0, n5);
                                }
                            }
                            zipOutputStream.closeEntry();
                        }
                    }
                    zipOutputStream.closeEntry();
                    zipOutputStream.flush();
                    zipOutputStream.finish();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, runnableVal));
    }

    final @Nullable File getDat(@NonNull String string) {
        File file = new File(PlotSquared.platform().worldContainer() + File.separator + string + File.separator + "level.dat");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private @Nullable File getMcr(@NonNull String string, int n, int n2) {
        File file = new File(PlotSquared.platform().worldContainer(), string + File.separator + "region" + File.separator + "r." + n + "." + n2 + ".mca");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public Set<BlockVector2> getChunkChunks(String string) {
        File file = new File(PlotSquared.platform().worldContainer(), string + File.separator + "region");
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new RuntimeException("Could not find worlds folder: " + file + " ? (no read access?)");
        }
        HashSet<BlockVector2> hashSet = new HashSet<BlockVector2>();
        for (File file2 : fileArray) {
            String string2 = file2.getName();
            if (!string2.endsWith("mca")) continue;
            String[] stringArray = string2.split("\\.");
            try {
                int n = Integer.parseInt(stringArray[1]);
                int n2 = Integer.parseInt(stringArray[2]);
                BlockVector2 blockVector2 = BlockVector2.at((int)n, (int)n2);
                hashSet.add(blockVector2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    public abstract boolean isBlockSame(@NonNull BlockState var1, @NonNull BlockState var2);

    public abstract @NonNegative double getHealth(@NonNull PlotPlayer<?> var1);

    public abstract void setHealth(@NonNull PlotPlayer<?> var1, @NonNegative double var2);

    public abstract @NonNegative int getFoodLevel(@NonNull PlotPlayer<?> var1);

    public abstract void setFoodLevel(@NonNull PlotPlayer<?> var1, @NonNegative int var2);

    public abstract @NonNull Set<EntityType> getTypesInCategory(@NonNull String var1);

    public abstract @NonNull Collection<BlockType> getTileEntityTypes();

    public abstract @NonNegative int getTileEntityCount(@NonNull String var1, @NonNull BlockVector2 var2);
}

