/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.helpmenu;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.command.Argument;
import com.plotsquared.core.command.Command;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.ComponentLike;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.StringMan;

public class HelpObject
implements ComponentLike {
    static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final Component rendered;

    public HelpObject(Command command, String string, PlotPlayer<?> plotPlayer) {
        this.rendered = MINI_MESSAGE.deserialize(TranslatableCaption.of("help.help_item").getComponent(plotPlayer), TagResolver.builder().tag("usage", Tag.inserting(Component.text(command.getUsage().replace("{label}", string)))).tag("alias", Tag.inserting(Component.text(command.getAliases().isEmpty() ? "" : StringMan.join(command.getAliases(), " | ")))).tag("desc", Tag.inserting(command.getDescription().toComponent(plotPlayer))).tag("arguments", Tag.inserting(Component.text(this.buildArgumentList(command.getRequiredArguments())))).tag("label", Tag.inserting(Component.text(string))).build());
    }

    private String buildArgumentList(Argument<?>[] argumentArray) {
        if (argumentArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Argument<?> argument : argumentArray) {
            stringBuilder.append("[").append(argument.getName()).append(" (").append(argument.getExample()).append(")],");
        }
        return argumentArray.length > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : "";
    }

    @Override
    @NotNull
    public Component asComponent() {
        return this.rendered;
    }
}

