/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.placeholders;

import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.util.placeholders.PlotSpecificPlaceholder;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlotFlagPlaceholder
extends PlotSpecificPlaceholder {
    private final PlotFlag<?, ?> flag;
    private final boolean local;

    public PlotFlagPlaceholder(@NonNull PlotFlag<?, ?> plotFlag, boolean bl) {
        super(String.format("currentplot_%sflag_%s", bl ? "local" : "", plotFlag.getName()));
        this.flag = plotFlag;
        this.local = bl;
    }

    @Override
    public @NonNull String getValue(@NonNull PlotPlayer<?> plotPlayer, @NonNull Plot plot) {
        return this.getFlagValue(plot, this.flag.getName(), !this.local);
    }

    private @NonNull String getFlagValue(@NonNull Plot plot, @NonNull String string, boolean bl) {
        if (string.isEmpty()) {
            return "";
        }
        PlotFlag<?, ?> plotFlag = GlobalFlagContainer.getInstance().getFlagFromString(string);
        if (plotFlag == null) {
            return "";
        }
        if (bl) {
            return plot.getFlag(plotFlag).toString();
        }
        Object t = plot.getFlagContainer().queryLocal(plotFlag.getClass());
        return t != null ? ((PlotFlag)t).getValue().toString() : "";
    }
}

