/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.task;

import com.google.common.base.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TaskTime {
    private final long time;
    private final TaskUnit unit;

    private TaskTime(@NonNegative long l, @NonNull TaskUnit taskUnit) {
        this.time = l;
        this.unit = taskUnit;
    }

    public static @NonNull TaskTime seconds(@NonNegative long l) {
        return new TaskTime(l * 1000L, TaskUnit.MILLISECONDS);
    }

    public static @NonNull TaskTime ticks(@NonNegative long l) {
        return new TaskTime(l, TaskUnit.TICKS);
    }

    public static @NonNull TaskTime ms(@NonNegative long l) {
        return new TaskTime(l, TaskUnit.MILLISECONDS);
    }

    public @NonNegative long getTime() {
        return this.time;
    }

    public @NonNull TaskUnit getUnit() {
        return this.unit;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TaskTime taskTime = (TaskTime)object;
        return this.getTime() == taskTime.getTime() && this.getUnit() == taskTime.getUnit();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTime(), this.getUnit()});
    }

    public static enum TaskUnit {
        TICKS,
        MILLISECONDS;

    }

    public static interface TimeConverter {
        public @NonNegative long msToTicks(@NonNegative long var1);

        public @NonNegative long ticksToMs(@NonNegative long var1);

        default public @NonNegative long toTicks(@NonNull TaskTime taskTime) {
            if (taskTime.getUnit() == TaskUnit.TICKS) {
                return taskTime.getTime();
            }
            return this.msToTicks(taskTime.getTime());
        }

        default public @NonNegative long toMs(@NonNull TaskTime taskTime) {
            if (taskTime.getUnit() == TaskUnit.MILLISECONDS) {
                return taskTime.getTime();
            }
            return this.ticksToMs(taskTime.getTime());
        }
    }
}

