/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.plotsquared.google.Provider;
import com.plotsquared.google.internal.MoreTypes;
import com.plotsquared.google.util.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;

public class TypeLiteral<T> {
    final Class<? super T> rawType;
    final Type type;
    final int hashCode;

    protected TypeLiteral() {
        this.type = TypeLiteral.getSuperclassTypeParameter(this.getClass());
        this.rawType = MoreTypes.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    TypeLiteral(Type type) {
        this.type = MoreTypes.canonicalize((Type)Preconditions.checkNotNull((Object)type, (Object)"type"));
        this.rawType = MoreTypes.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    static Type getSuperclassTypeParameter(Class<?> clazz) {
        Type type = clazz.getGenericSuperclass();
        if (type instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return MoreTypes.canonicalize(parameterizedType.getActualTypeArguments()[0]);
    }

    static TypeLiteral<?> fromSuperclassTypeParameter(Class<?> clazz) {
        return new TypeLiteral(TypeLiteral.getSuperclassTypeParameter(clazz));
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    final TypeLiteral<Provider<T>> providerType() {
        return TypeLiteral.get(Types.providerOf(this.getType()));
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        return object instanceof TypeLiteral && MoreTypes.equals(this.type, ((TypeLiteral)object).type);
    }

    public final String toString() {
        return MoreTypes.typeToString(this.type);
    }

    public static TypeLiteral<?> get(Type type) {
        return new TypeLiteral(type);
    }

    public static <T> TypeLiteral<T> get(Class<T> clazz) {
        return new TypeLiteral<T>(clazz);
    }

    private List<TypeLiteral<?>> resolveAll(Type[] typeArray) {
        Object[] objectArray = new TypeLiteral[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            objectArray[i] = this.resolve(typeArray[i]);
        }
        return ImmutableList.copyOf((Object[])objectArray);
    }

    TypeLiteral<?> resolve(Type type) {
        return TypeLiteral.get(this.resolveType(type));
    }

    Type resolveType(Type type) {
        Type type2;
        while (type instanceof TypeVariable) {
            type2 = (TypeVariable)type;
            if ((type = MoreTypes.resolveTypeVariable(this.type, this.rawType, type2)) != type2) continue;
            return type;
        }
        if (type instanceof GenericArrayType) {
            Type type3;
            type2 = (GenericArrayType)type;
            Type type4 = type2.getGenericComponentType();
            return type4 == (type3 = this.resolveType(type4)) ? type2 : Types.arrayOf(type3);
        }
        if (type instanceof ParameterizedType) {
            type2 = (ParameterizedType)type;
            Type type5 = type2.getOwnerType();
            Type type6 = this.resolveType(type5);
            boolean bl = type6 != type5;
            Type[] typeArray = type2.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type7 = this.resolveType(typeArray[i]);
                if (type7 == typeArray[i]) continue;
                if (!bl) {
                    typeArray = (Type[])typeArray.clone();
                    bl = true;
                }
                typeArray[i] = type7;
            }
            return bl ? Types.newParameterizedTypeWithOwner(type6, type2.getRawType(), typeArray) : type2;
        }
        if (type instanceof WildcardType) {
            Type type8;
            type2 = (WildcardType)type;
            Type[] typeArray = type2.getLowerBounds();
            Type[] typeArray2 = type2.getUpperBounds();
            if (typeArray.length == 1) {
                Type type9 = this.resolveType(typeArray[0]);
                if (type9 != typeArray[0]) {
                    return Types.supertypeOf(type9);
                }
            } else if (typeArray2.length == 1 && (type8 = this.resolveType(typeArray2[0])) != typeArray2[0]) {
                return Types.subtypeOf(type8);
            }
            return type2;
        }
        return type;
    }

    public TypeLiteral<?> getSupertype(Class<?> clazz) {
        Preconditions.checkArgument((boolean)clazz.isAssignableFrom(this.rawType), (String)"%s is not a supertype of %s", clazz, (Object)this.type);
        return this.resolve(MoreTypes.getGenericSupertype(this.type, this.rawType, clazz));
    }

    public TypeLiteral<?> getFieldType(Field field) {
        Preconditions.checkArgument((boolean)field.getDeclaringClass().isAssignableFrom(this.rawType), (String)"%s is not defined by a supertype of %s", (Object)field, (Object)this.type);
        return this.resolve(field.getGenericType());
    }

    public List<TypeLiteral<?>> getParameterTypes(Member member) {
        Type[] typeArray;
        if (member instanceof Method) {
            Method method = (Method)member;
            Preconditions.checkArgument((boolean)method.getDeclaringClass().isAssignableFrom(this.rawType), (String)"%s is not defined by a supertype of %s", (Object)method, (Object)this.type);
            typeArray = method.getGenericParameterTypes();
        } else if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            Preconditions.checkArgument((boolean)constructor.getDeclaringClass().isAssignableFrom(this.rawType), (String)"%s does not construct a supertype of %s", (Object)constructor, (Object)this.type);
            typeArray = constructor.getGenericParameterTypes();
        } else {
            throw new IllegalArgumentException("Not a method or a constructor: " + member);
        }
        return this.resolveAll(typeArray);
    }

    public List<TypeLiteral<?>> getExceptionTypes(Member member) {
        Type[] typeArray;
        if (member instanceof Method) {
            Method method = (Method)member;
            Preconditions.checkArgument((boolean)method.getDeclaringClass().isAssignableFrom(this.rawType), (String)"%s is not defined by a supertype of %s", (Object)method, (Object)this.type);
            typeArray = method.getGenericExceptionTypes();
        } else if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            Preconditions.checkArgument((boolean)constructor.getDeclaringClass().isAssignableFrom(this.rawType), (String)"%s does not construct a supertype of %s", (Object)constructor, (Object)this.type);
            typeArray = constructor.getGenericExceptionTypes();
        } else {
            throw new IllegalArgumentException("Not a method or a constructor: " + member);
        }
        return this.resolveAll(typeArray);
    }

    public TypeLiteral<?> getReturnType(Method method) {
        Preconditions.checkArgument((boolean)method.getDeclaringClass().isAssignableFrom(this.rawType), (String)"%s is not defined by a supertype of %s", (Object)method, (Object)this.type);
        return this.resolve(method.getGenericReturnType());
    }
}

