/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.assistedinject;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.plotsquared.google.AbstractModule;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Binding;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.ProvisionException;
import com.plotsquared.google.Scopes;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.assistedinject.Assisted;
import com.plotsquared.google.assistedinject.AssistedInject;
import com.plotsquared.google.assistedinject.AssistedInjectBinding;
import com.plotsquared.google.assistedinject.AssistedInjectTargetVisitor;
import com.plotsquared.google.assistedinject.AssistedMethod;
import com.plotsquared.google.assistedinject.BindingCollector;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.UniqueAnnotations;
import com.plotsquared.google.internal.util.Classes;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.HasDependencies;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.Message;
import com.plotsquared.google.spi.ProviderInstanceBinding;
import com.plotsquared.google.spi.ProviderWithExtensionVisitor;
import com.plotsquared.google.spi.Toolable;
import com.plotsquared.google.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryProvider2<F>
implements InvocationHandler,
ProviderWithExtensionVisitor<F>,
HasDependencies,
AssistedInjectBinding<F> {
    static final Annotation RETURN_ANNOTATION = UniqueAnnotations.create();
    static final Logger logger = Logger.getLogger(AssistedInject.class.getName());
    private static boolean allowPrivateLookupFallback = true;
    private static boolean allowMethodHandleWorkaround = true;
    static final Assisted DEFAULT_ANNOTATION = new Assisted(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Assisted.class;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Assisted && ((Assisted)object).value().isEmpty();
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ "".hashCode();
        }

        @Override
        public String toString() {
            return "@" + Assisted.class.getName() + "(" + Annotations.memberValueString("value", "") + ")";
        }
    };
    private final ImmutableMap<Method, AssistData> assistDataByMethod;
    private final ImmutableMap<Method, MethodHandle> methodHandleByMethod;
    private Injector injector;
    private final F factory;
    private final Key<F> factoryKey;
    private final BindingCollector collector;

    FactoryProvider2(Key<F> key, BindingCollector bindingCollector, MethodHandles.Lookup lookup) {
        this.factoryKey = key;
        this.collector = bindingCollector;
        TypeLiteral<F> typeLiteral = key.getTypeLiteral();
        Errors errors = new Errors();
        Class clazz = typeLiteral.getRawType();
        try {
            Object object;
            Object object2;
            Object object3;
            if (!clazz.isInterface()) {
                throw errors.addMessage("%s must be an interface.", clazz).toException();
            }
            HashMultimap hashMultimap = HashMultimap.create();
            HashMultimap hashMultimap2 = HashMultimap.create();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Object object4 : clazz.getMethods()) {
                Object object5;
                Class<?> clazz2;
                Key<?> key2;
                TypeLiteral<Object> typeLiteral2;
                if (Modifier.isStatic(((Method)object4).getModifiers())) continue;
                if (FactoryProvider2.isDefault((Method)object4) && (((Method)object4).isBridge() || ((Method)object4).isSynthetic())) {
                    this.validateFactoryReturnType(errors, ((Method)object4).getReturnType(), clazz);
                    hashMultimap.put((Object)((Method)object4).getName(), object4);
                    continue;
                }
                hashMultimap2.put((Object)((Method)object4).getName(), object4);
                Object object6 = typeLiteral.getReturnType((Method)object4);
                try {
                    object3 = Annotations.getKey(object6, (Member)object4, ((AccessibleObject)object4).getAnnotations(), errors);
                }
                catch (ConfigurationException configurationException) {
                    if (this.isTypeNotSpecified((TypeLiteral<?>)object6, configurationException)) {
                        throw errors.keyNotFullySpecified(TypeLiteral.get(clazz)).toException();
                    }
                    throw configurationException;
                }
                this.validateFactoryReturnType(errors, ((Key)object3).getTypeLiteral().getRawType(), clazz);
                object2 = typeLiteral.getParameterTypes((Member)object4);
                object = ((Method)object4).getParameterAnnotations();
                int n = 0;
                ArrayList arrayList = Lists.newArrayList();
                Object object7 = object2.iterator();
                while (object7.hasNext()) {
                    typeLiteral2 = (TypeLiteral<?>)object7.next();
                    key2 = Annotations.getKey(typeLiteral2, (Member)object4, (Annotation[])object[n++], errors);
                    clazz2 = key2.getTypeLiteral().getRawType();
                    if (clazz2.equals(Provider.class) || clazz2.equals(jakarta.inject.Provider.class)) {
                        errors.addMessage("A Provider may not be a type in a factory method of an AssistedInject.\n  Offending instance is parameter [%s] with key [%s] on method [%s]", n, key2, object4);
                    }
                    arrayList.add(this.assistKey((Method)object4, key2, errors));
                }
                object7 = ImmutableList.copyOf((Collection)arrayList);
                typeLiteral2 = bindingCollector.getBindings().get(object3);
                if (typeLiteral2 == null) {
                    typeLiteral2 = ((Key)object3).getTypeLiteral();
                }
                if ((key2 = Annotations.findScopeAnnotation(errors, typeLiteral2.getRawType())) != null) {
                    errors.addMessage("Found scope annotation [%s] on implementation class [%s] of AssistedInject factory [%s].\nThis is not allowed, please remove the scope annotation.", key2, typeLiteral2.getRawType(), typeLiteral);
                }
                try {
                    clazz2 = this.findMatchingConstructorInjectionPoint((Method)object4, (Key<?>)object3, typeLiteral2, (List<Key<?>>)object7);
                }
                catch (ErrorsException errorsException) {
                    errors.merge(errorsException.getErrors());
                    continue;
                }
                Constructor constructor = (Constructor)((InjectionPoint)((Object)clazz2)).getMember();
                ImmutableList immutableList = Collections.emptyList();
                Set<Dependency<?>> set = this.getDependencies((InjectionPoint)((Object)clazz2), typeLiteral2);
                boolean bl = false;
                if (this.isValidForOptimizedAssistedInject(set, typeLiteral2.getRawType(), typeLiteral)) {
                    object5 = ImmutableList.builder();
                    for (int i = 0; i < object2.size(); ++i) {
                        object5.add((Object)new ThreadLocalProvider());
                    }
                    immutableList = object5.build();
                    bl = true;
                }
                object5 = new AssistData(constructor, (Key<?>)object3, (ImmutableList<Key<?>>)object7, typeLiteral2, (Method)object4, this.removeAssistedDeps(set), bl, (List<ThreadLocalProvider>)immutableList);
                builder.put(object4, object5);
            }
            this.factory = clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this));
            ImmutableMap immutableMap = builder.buildOrThrow();
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            int n = 0;
            for (Object object6 : hashMultimap.entries()) {
                block27: {
                    if (n == 0 && lookup == null && !Modifier.isPublic(this.factory.getClass().getModifiers())) {
                        n = 1;
                        logger.log(Level.WARNING, "AssistedInject factory {0} is non-public and has javac-generated default methods.  Please pass a `MethodHandles.lookup()` with FactoryModuleBuilder.withLookups when using this factory so that Guice can properly call the default methods. Guice will try to workaround this, but it does not always work (depending on the method signatures of the factory).", new Object[]{typeLiteral});
                    }
                    object3 = (Method)object6.getValue();
                    object2 = null;
                    try {
                        object2 = FactoryProvider2.superMethodHandle(SuperMethodSupport.METHOD_LOOKUP, (Method)object3, this.factory, lookup);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        if (!allowPrivateLookupFallback || SuperMethodSupport.METHOD_LOOKUP == SuperMethodLookup.PRIVATE_LOOKUP) break block27;
                        try {
                            object2 = FactoryProvider2.superMethodHandle(SuperMethodLookup.PRIVATE_LOOKUP, (Method)object3, this.factory, lookup);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException2) {
                            // empty catch block
                        }
                    }
                }
                object = () -> "Unable to use non-public factory " + clazz.getName() + ". Please call FactoryModuleBuilder.withLookups(MethodHandles.lookup()) (with a lookups that has access to the factory), or make the factory public.";
                if (object2 != null) {
                    builder2.put(object3, object2);
                    continue;
                }
                if (!allowMethodHandleWorkaround) {
                    errors.addMessage((String)object.get(), new Object[0]);
                    continue;
                }
                boolean bl = false;
                for (Object object7 : hashMultimap2.get((Object)((Method)object3).getName())) {
                    if (!immutableMap.containsKey(object7) || !this.isCompatible((Method)object3, (Method)object7)) continue;
                    if (bl) {
                        errors.addMessage((String)object.get(), new Object[0]);
                        break;
                    }
                    builder.put(object3, (Object)((AssistData)immutableMap.get(object7)));
                    bl = true;
                }
                if (bl) continue;
                throw new IllegalStateException("Can't find method compatible with: " + object3);
            }
            if (errors.hasErrors()) {
                throw errors.toException();
            }
            this.assistDataByMethod = builder.buildOrThrow();
            this.methodHandleByMethod = builder2.buildOrThrow();
        }
        catch (ErrorsException errorsException) {
            throw new ConfigurationException(errorsException.getErrors().getMessages());
        }
    }

    static boolean isDefault(Method method) {
        return (method.getModifiers() & 0x409) == 1;
    }

    private boolean isCompatible(Method method, Method method2) {
        Class<?>[] classArray;
        if (!method.getReturnType().isAssignableFrom(method2.getReturnType())) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i].isAssignableFrom(classArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public F get() {
        return this.factory;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        HashSet hashSet = new HashSet();
        for (AssistData assistData : this.assistDataByMethod.values()) {
            hashSet.addAll(assistData.dependencies);
        }
        return ImmutableSet.copyOf(hashSet);
    }

    @Override
    public Key<F> getKey() {
        return this.factoryKey;
    }

    @Override
    public Collection<AssistedMethod> getAssistedMethods() {
        return this.assistDataByMethod.values();
    }

    @Override
    public <T, V> V acceptExtensionVisitor(BindingTargetVisitor<T, V> bindingTargetVisitor, ProviderInstanceBinding<? extends T> providerInstanceBinding) {
        if (bindingTargetVisitor instanceof AssistedInjectTargetVisitor) {
            return ((AssistedInjectTargetVisitor)bindingTargetVisitor).visit(this);
        }
        return bindingTargetVisitor.visit(providerInstanceBinding);
    }

    private void validateFactoryReturnType(Errors errors, Class<?> clazz, Class<?> clazz2) {
        if (Modifier.isPublic(clazz2.getModifiers()) && !Modifier.isPublic(clazz.getModifiers())) {
            errors.addMessage("%s is public, but has a method that returns a non-public type: %s. Due to limitations with java.lang.reflect.Proxy, this is not allowed. Please either make the factory non-public or the return type public.", clazz2, clazz);
        }
    }

    private boolean isTypeNotSpecified(TypeLiteral<?> typeLiteral, ConfigurationException configurationException) {
        Collection<Message> collection = configurationException.getErrorMessages();
        if (collection.size() == 1) {
            Message message = (Message)Iterables.getOnlyElement(new Errors().keyNotFullySpecified(typeLiteral).getMessages());
            return message.getMessage().equals(((Message)Iterables.getOnlyElement(collection)).getMessage());
        }
        return false;
    }

    private <T> InjectionPoint findMatchingConstructorInjectionPoint(Method method, Key<?> key, TypeLiteral<T> typeLiteral, List<Key<?>> list) {
        Errors errors = new Errors(method);
        errors = key.getTypeLiteral().equals(typeLiteral) ? errors.withSource(typeLiteral) : errors.withSource(key).withSource(typeLiteral);
        Class<T> clazz = typeLiteral.getRawType();
        if (Modifier.isInterface(clazz.getModifiers())) {
            errors.addMessage("%s is an interface, not a concrete class.  Unable to create AssistedInject factory.", typeLiteral);
            throw errors.toException();
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            errors.addMessage("%s is abstract, not a concrete class.  Unable to create AssistedInject factory.", typeLiteral);
            throw errors.toException();
        }
        if (Classes.isInnerClass(clazz)) {
            errors.cannotInjectInnerClass(clazz);
            throw errors.toException();
        }
        Constructor<?> constructor = null;
        boolean bl = false;
        for (Constructor<?> constructor2 : clazz.getDeclaredConstructors()) {
            if (!constructor2.isAnnotationPresent(AssistedInject.class)) continue;
            bl = true;
            if (!this.constructorHasMatchingParams(typeLiteral, constructor2, list, errors)) continue;
            if (constructor != null) {
                errors.addMessage("%s has more than one constructor annotated with @AssistedInject that matches the parameters in method %s.  Unable to create AssistedInject factory.", typeLiteral, method);
                throw errors.toException();
            }
            constructor = constructor2;
        }
        if (!bl) {
            try {
                return InjectionPoint.forConstructorOf(typeLiteral);
            }
            catch (ConfigurationException configurationException) {
                errors.merge(configurationException.getErrorMessages());
                throw errors.toException();
            }
        }
        if (constructor != null) {
            InjectionPoint injectionPoint = InjectionPoint.forConstructor(constructor, typeLiteral);
            return injectionPoint;
        }
        errors.addMessage("%s has @AssistedInject constructors, but none of them match the parameters in method %s.  Unable to create AssistedInject factory.", typeLiteral, method);
        throw errors.toException();
    }

    private boolean constructorHasMatchingParams(TypeLiteral<?> typeLiteral, Constructor<?> constructor, List<Key<?>> list, Errors errors) {
        List<TypeLiteral<?>> list2 = typeLiteral.getParameterTypes(constructor);
        Annotation[][] annotationArray = constructor.getParameterAnnotations();
        int n = 0;
        ArrayList arrayList = Lists.newArrayList();
        for (TypeLiteral<?> object : list2) {
            Key<?> key = Annotations.getKey(object, constructor, annotationArray[n++], errors);
            arrayList.add(key);
        }
        for (Key key : list) {
            if (arrayList.remove(key)) continue;
            return false;
        }
        for (Key key : arrayList) {
            if (key.getAnnotationType() != Assisted.class) continue;
            return false;
        }
        return true;
    }

    private Set<Dependency<?>> getDependencies(InjectionPoint injectionPoint, TypeLiteral<?> typeLiteral) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(injectionPoint.getDependencies());
        if (!typeLiteral.getRawType().isInterface()) {
            for (InjectionPoint injectionPoint2 : InjectionPoint.forInstanceMethodsAndFields(typeLiteral)) {
                builder.addAll(injectionPoint2.getDependencies());
            }
        }
        return builder.build();
    }

    private Set<Dependency<?>> removeAssistedDeps(Set<Dependency<?>> set) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Dependency<?> dependency : set) {
            Class<Annotation> clazz = dependency.getKey().getAnnotationType();
            if (clazz != null && clazz.equals(Assisted.class)) continue;
            builder.add(dependency);
        }
        return builder.build();
    }

    private boolean isValidForOptimizedAssistedInject(Set<Dependency<?>> set, Class<?> clazz, TypeLiteral<?> typeLiteral) {
        Set set2 = null;
        for (Dependency<?> dependency : set) {
            if (!this.isInjectorOrAssistedProvider(dependency)) continue;
            if (set2 == null) {
                set2 = Sets.newHashSet();
            }
            set2.add(dependency);
        }
        if (set2 != null && !set2.isEmpty()) {
            logger.log(Level.WARNING, "AssistedInject factory {0} will be slow because {1} has assisted Provider dependencies or injects the Injector. Stop injecting @Assisted Provider<T> (instead use @Assisted T) or Injector to speed things up. (It will be a ~6500% speed bump!)  The exact offending deps are: {2}", new Object[]{typeLiteral, clazz, set2});
            return false;
        }
        return true;
    }

    private boolean isInjectorOrAssistedProvider(Dependency<?> dependency) {
        Class<Annotation> clazz = dependency.getKey().getAnnotationType();
        return clazz != null && clazz.equals(Assisted.class) ? dependency.getKey().getTypeLiteral().getRawType().equals(Provider.class) : dependency.getKey().getTypeLiteral().getRawType().equals(Injector.class);
    }

    private <T> Key<T> assistKey(Method method, Key<T> key, Errors errors) {
        if (key.getAnnotationType() == null) {
            return key.withAnnotation(DEFAULT_ANNOTATION);
        }
        if (key.getAnnotationType() == Assisted.class) {
            return key;
        }
        errors.withSource(method).addMessage("Only @Assisted is allowed for factory parameters, but found @%s", key.getAnnotationType());
        throw errors.toException();
    }

    @Inject
    @Toolable
    void initialize(Injector injector) {
        if (this.injector != null) {
            throw new ConfigurationException((Iterable<Message>)ImmutableList.of((Object)new Message(FactoryProvider2.class, "Factories.create() factories may only be used in one Injector!")));
        }
        this.injector = injector;
        for (Map.Entry entry : this.assistDataByMethod.entrySet()) {
            Object[] objectArray;
            Method method = (Method)entry.getKey();
            AssistData assistData = (AssistData)entry.getValue();
            if (!assistData.optimized) {
                objectArray = new Object[method.getParameterTypes().length];
                Arrays.fill(objectArray, "dummy object for validating Factories");
            } else {
                objectArray = null;
            }
            this.getBindingFromNewInjector(method, objectArray, assistData);
        }
    }

    public Binding<?> getBindingFromNewInjector(final Method method, final Object[] objectArray, final AssistData assistData) {
        Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"Factories.create() factories cannot be used until they're initialized by Guice.");
        Key<?> key = assistData.returnType;
        final Key<?> key2 = Key.get(key.getTypeLiteral(), RETURN_ANNOTATION);
        AbstractModule abstractModule = new AbstractModule(this){

            @Override
            protected void configure() {
                Object object;
                Binder binder = this.binder().withSource(method);
                int n = 0;
                if (!assistData.optimized) {
                    object = assistData.paramTypes.iterator();
                    while (object.hasNext()) {
                        Key key = (Key)object.next();
                        binder.bind(key).toProvider(Providers.of(objectArray[n++]));
                    }
                } else {
                    object = assistData.paramTypes.iterator();
                    while (object.hasNext()) {
                        Key key = (Key)object.next();
                        binder.bind(key).toProvider(assistData.providers.get(n++));
                    }
                }
                if ((object = assistData.constructor) != null) {
                    binder.bind(key2).toConstructor(object, assistData.implementationType).in(Scopes.NO_SCOPE);
                }
            }
        };
        Injector injector = this.injector.createChildInjector(abstractModule);
        Binding<?> binding = injector.getBinding(key2);
        if (assistData.optimized) {
            assistData.cachedBinding = binding;
        }
        return binding;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (this.methodHandleByMethod.containsKey((Object)method)) {
            return ((MethodHandle)this.methodHandleByMethod.get((Object)method)).invokeWithArguments(objectArray);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            if ("equals".equals(method.getName())) {
                return object == objectArray[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(object);
            }
            return method.invoke((Object)this, objectArray);
        }
        AssistData assistData = (AssistData)this.assistDataByMethod.get((Object)method);
        Preconditions.checkState((assistData != null ? 1 : 0) != 0, (String)"No data for method: %s", (Object)method);
        Provider<?> provider = assistData.cachedBinding != null ? assistData.cachedBinding.getProvider() : this.getBindingFromNewInjector(method, objectArray, assistData).getProvider();
        try {
            int n = 0;
            for (ThreadLocalProvider object2 : assistData.providers) {
                object2.set(objectArray[n++]);
            }
            Iterator<ThreadLocalProvider> iterator = provider.get();
            return iterator;
        }
        catch (ProvisionException provisionException) {
            Message message;
            Throwable throwable;
            if (provisionException.getErrorMessages().size() == 1 && (throwable = (message = (Message)Iterables.getOnlyElement(provisionException.getErrorMessages())).getCause()) != null && FactoryProvider2.canRethrow(method, throwable)) {
                throw throwable;
            }
            throw provisionException;
        }
        finally {
            for (ThreadLocalProvider threadLocalProvider : assistData.providers) {
                threadLocalProvider.remove();
            }
        }
    }

    public String toString() {
        return this.factory.getClass().getInterfaces()[0].getName();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.factoryKey, this.collector});
    }

    public boolean equals(Object object) {
        if (!(object instanceof FactoryProvider2)) {
            return false;
        }
        FactoryProvider2 factoryProvider2 = (FactoryProvider2)object;
        return this.factoryKey.equals(factoryProvider2.factoryKey) && Objects.equal((Object)this.collector, (Object)factoryProvider2.collector);
    }

    static boolean canRethrow(Method method, Throwable throwable) {
        if (throwable instanceof Error || throwable instanceof RuntimeException) {
            return true;
        }
        for (Class<?> clazz : method.getExceptionTypes()) {
            if (!clazz.isInstance(throwable)) continue;
            return true;
        }
        return false;
    }

    private static MethodHandle superMethodHandle(SuperMethodLookup superMethodLookup, Method method, Object object, MethodHandles.Lookup lookup) {
        MethodHandles.Lookup lookup2 = lookup == null ? MethodHandles.lookup() : lookup;
        MethodHandle methodHandle = superMethodLookup.superMethodHandle(method, lookup2);
        return methodHandle != null ? methodHandle.bindTo(object) : null;
    }

    static class PrivateLookup {
        private static final int ALL_MODES = 15;
        private static final Constructor<MethodHandles.Lookup> privateLookupCxtor = PrivateLookup.findPrivateLookupCxtor();

        PrivateLookup() {
        }

        private static Constructor<MethodHandles.Lookup> findPrivateLookupCxtor() {
            try {
                Constructor<MethodHandles.Lookup> constructor;
                try {
                    constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Class.class, Integer.TYPE);
                }
                constructor.setAccessible(true);
                return constructor;
            }
            catch (Exception exception) {
                return null;
            }
        }

        static MethodHandle superMethodHandle(Method method) {
            if (privateLookupCxtor == null) {
                return null;
            }
            Class<?> clazz = method.getDeclaringClass();
            MethodHandles.Lookup lookup = privateLookupCxtor.getParameterCount() == 2 ? privateLookupCxtor.newInstance(clazz, 15) : privateLookupCxtor.newInstance(clazz, null, 15);
            return lookup.unreflectSpecial(method, clazz);
        }
    }

    private static enum SuperMethodLookup {
        UNREFLECT_SPECIAL{

            @Override
            MethodHandle superMethodHandle(Method method, MethodHandles.Lookup lookup) {
                return lookup.unreflectSpecial(method, method.getDeclaringClass());
            }
        }
        ,
        FIND_SPECIAL{

            @Override
            MethodHandle superMethodHandle(Method method, MethodHandles.Lookup lookup) {
                Class<?> clazz = method.getDeclaringClass();
                return lookup.findSpecial(clazz, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), clazz);
            }
        }
        ,
        PRIVATE_LOOKUP{

            @Override
            MethodHandle superMethodHandle(Method method, MethodHandles.Lookup lookup) {
                return PrivateLookup.superMethodHandle(method);
            }
        };


        abstract MethodHandle superMethodHandle(Method var1, MethodHandles.Lookup var2);
    }

    private static class SuperMethodSupport {
        private static final SuperMethodLookup METHOD_LOOKUP;

        private SuperMethodSupport() {
        }

        static {
            SuperMethodLookup superMethodLookup = null;
            try {
                Class<?> clazz = Class.forName("com.plotsquared.google.assistedinject.internal.LookupTester$Hidden");
                Method method = clazz.getMethod("method", new Class[0]);
                Field field = clazz.getEnclosingClass().getDeclaredField("LOOKUP");
                field.setAccessible(true);
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)field.get(null);
                for (SuperMethodLookup superMethodLookup2 : SuperMethodLookup.values()) {
                    try {
                        superMethodLookup2.superMethodHandle(method, lookup);
                        superMethodLookup = superMethodLookup2;
                        break;
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                    }
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            if (superMethodLookup == null) {
                superMethodLookup = SuperMethodLookup.PRIVATE_LOOKUP;
            }
            METHOD_LOOKUP = superMethodLookup;
        }
    }

    private static class ThreadLocalProvider
    extends ThreadLocal<Object>
    implements Provider<Object> {
        private ThreadLocalProvider() {
        }

        @Override
        protected Object initialValue() {
            throw new IllegalStateException("Cannot use optimized @Assisted provider outside the scope of the constructor. (This should never happen.  If it does, please report it.)");
        }
    }

    private static class AssistData
    implements AssistedMethod {
        final Constructor<?> constructor;
        final Key<?> returnType;
        final ImmutableList<Key<?>> paramTypes;
        final TypeLiteral<?> implementationType;
        final Set<Dependency<?>> dependencies;
        final Method factoryMethod;
        final boolean optimized;
        final List<ThreadLocalProvider> providers;
        volatile Binding<?> cachedBinding;

        AssistData(Constructor<?> constructor, Key<?> key, ImmutableList<Key<?>> immutableList, TypeLiteral<?> typeLiteral, Method method, Set<Dependency<?>> set, boolean bl, List<ThreadLocalProvider> list) {
            this.constructor = constructor;
            this.returnType = key;
            this.paramTypes = immutableList;
            this.implementationType = typeLiteral;
            this.factoryMethod = method;
            this.dependencies = set;
            this.optimized = bl;
            this.providers = list;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("ctor", this.constructor).add("return type", this.returnType).add("param type", this.paramTypes).add("implementation type", this.implementationType).add("dependencies", this.dependencies).add("factory method", (Object)this.factoryMethod).add("optimized", this.optimized).add("providers", this.providers).add("cached binding", this.cachedBinding).toString();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        @Override
        public Method getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public Constructor<?> getImplementationConstructor() {
            return this.constructor;
        }

        @Override
        public TypeLiteral<?> getImplementationType() {
            return this.implementationType;
        }
    }
}

